/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portbordered;

import com.modeliosoft.modelio.diagram.elements.common.portbordered.PortBorderedFigure;
import com.modeliosoft.modelio.diagram.elements.common.portbordered.PortContainerFigure;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

class PortContainerFigure
extends Figure {
    Rectangle overallBounds = null;
    FigureListener portListener = null;

    public PortContainerFigure() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.portListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void add(IFigure figure, Object constraint, int index) {
        figure.addFigureListener(this.portListener);
        2 l = new /* Unavailable Anonymous Inner Class!! */;
        super.add(figure, (Object)l, index);
    }

    public void remove(IFigure figure) {
        figure.removeFigureListener(this.portListener);
        super.remove(figure);
    }

    public Rectangle getOverallBounds() {
        if (this.overallBounds == null) {
            this.overallBounds = this.getParent().getBounds().getCopy();
            for (Figure childFigure : this.getChildren()) {
                Rectangle childBounds = childFigure.getBounds();
                this.overallBounds.union(childBounds);
            }
        }
        return this.overallBounds;
    }

    public void repaint() {
        if (this.getChildren().isEmpty()) {
            super.repaint();
        } else {
            if (this.getParent() == null || !this.isVisible()) {
                return;
            }
            Rectangle rectBounds = this.getOverallBounds();
            this.getParent().getParent().repaint(rectBounds);
        }
    }

    public boolean containsPoint(int x, int y) {
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty() || !this.isVisible()) {
            return;
        }
        graphics.pushState();
        this.paintChildren(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    public boolean intersects(Rectangle rect) {
        Rectangle rectangle = this.getOverallBounds();
        return rectangle.intersects(rect);
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(pt.x, pt.y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        return null;
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(pt.x, pt.y)) continue;
            fig = fig.findMouseEventTargetAt(pt.x, pt.y);
            return fig;
        }
        return null;
    }

    public IFigure getMainFigure() {
        return ((PortBorderedFigure)this.getParent()).getPrimaryFigure();
    }

    public void erase() {
        if (this.getChildren().isEmpty()) {
            super.erase();
        } else {
            if (this.getParent() == null || !this.isVisible()) {
                return;
            }
            this.repaint();
        }
    }

    public void invalidate() {
        this.overallBounds = null;
        super.invalidate();
    }

    public void validate() {
        this.overallBounds = null;
        super.validate();
    }
}

