/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portcontainer;

import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortContainerEditPart;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortContainerFigure;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortContainerLayout;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.TranslateChildrenCommand;
import java.util.HashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class LastMinuteContainerAutoResizeCommand
extends Command {
    private EditPart host;

    public LastMinuteContainerAutoResizeCommand(EditPart host) {
        this.host = host;
    }

    private EditPart getHost() {
        return this.host;
    }

    private IFigure getHostFigure() {
        return ((GraphicalEditPart)this.host).getFigure();
    }

    public void execute() {
        if (((PortContainerEditPart)this.host).dirty) {
            this.getHostFigure().getUpdateManager().performValidation();
        }
        IFigure containerFigure = this.getHostFigure();
        Rectangle oldContainerBounds = containerFigure.getBounds().getCopy();
        containerFigure.translateToAbsolute((Translatable)oldContainerBounds);
        PortContainerLayout portContainerLayout = (PortContainerLayout)containerFigure.getLayoutManager();
        Rectangle updatedContainerBounds = portContainerLayout.getPreferredBounds(containerFigure);
        containerFigure.translateToAbsolute((Translatable)updatedContainerBounds);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(this.getHost());
        Point moveDelta = new Point(updatedContainerBounds.x - oldContainerBounds.x, updatedContainerBounds.y - oldContainerBounds.y);
        req.setMoveDelta(moveDelta);
        req.setSizeDelta(new Dimension(updatedContainerBounds.width - oldContainerBounds.width, updatedContainerBounds.height - oldContainerBounds.height));
        HashMap<String, Rectangle> map = new HashMap<String, Rectangle>();
        Rectangle newHandleBounds = ((PortContainerLayout)containerFigure.getLayoutManager()).getMainNodeConstraint();
        newHandleBounds = newHandleBounds != null ? newHandleBounds.getTranslated(((PortContainerLayout)containerFigure.getLayoutManager()).getOrigin(containerFigure)) : ((PortContainerFigure)containerFigure).getHandleBounds().getCopy();
        map.put("newHandleBounds", newHandleBounds);
        req.setExtendedData(map);
        Command resizeContainerCommand = this.getHost().getParent().getCommand((Request)req);
        TranslateChildrenCommand translateChildrenCommand = null;
        if (moveDelta.x != 0 || moveDelta.y != 0) {
            translateChildrenCommand = new TranslateChildrenCommand((GraphicalEditPart)this.getHost(), moveDelta.getNegated());
        }
        if (resizeContainerCommand != null && resizeContainerCommand.canExecute()) {
            resizeContainerCommand.execute();
            if (translateChildrenCommand != null && translateChildrenCommand.canExecute()) {
                translateChildrenCommand.execute();
            }
        }
    }
}

