/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portcontainer;

import com.modeliosoft.modelio.diagram.elements.common.freezone.BaseFreeZoneLayoutEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.LastMinuteContainerAutoResizeCommand;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortConstraint;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortContainerLayout;
import com.modeliosoft.modelio.diagram.elements.core.commands.NodeChangeLayoutCommand;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class PortContainerEditPolicy
extends BaseFreeZoneLayoutEditPolicy {
    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof GmNodeEditPart) {
            GmPortContainer pc;
            GmNodeEditPart childNodePart = (GmNodeEditPart)child;
            GmNodeModel childModel = (GmNodeModel)childNodePart.getModel();
            if (childModel == (pc = (GmPortContainer)childModel.getParentNode()).getMainNode()) {
                return null;
            }
            if (pc.isPort(childModel)) {
                SelectionEditPolicy childPolicy = childNodePart.getPreferredDragRolePolicy("resize");
                if (childPolicy != null) {
                    return childPolicy;
                }
                return new DefaultNodeResizableEditPolicy();
            }
            if (pc.isSatellite(childModel)) {
                SelectionEditPolicy childPolicy = childNodePart.getPreferredDragRolePolicy("resize");
                if (childPolicy != null) {
                    return childPolicy;
                }
                return new DefaultNodeResizableEditPolicy();
            }
            return null;
        }
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (child instanceof GmNodeEditPart) {
            LastMinuteContainerAutoResizeCommand resizeContainerCommand = new LastMinuteContainerAutoResizeCommand(this.getHost());
            NodeChangeLayoutCommand resizeChildCommand = new NodeChangeLayoutCommand();
            resizeChildCommand.setModel(child.getModel());
            resizeChildCommand.setConstraint(constraint);
            CompoundCommand command = new CompoundCommand();
            command.add((Command)resizeChildCommand);
            command.add((Command)resizeContainerCommand);
            return command.unwrap();
        }
        return null;
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        GmPortContainer pc;
        GmNodeModel childModel = (GmNodeModel)child.getModel();
        GmCompositeNode parentNode = childModel.getParentNode();
        if (parentNode instanceof GmPortContainer && ((pc = (GmPortContainer)parentNode).getMainNode() == childModel || pc.isSatellite(childModel))) {
            return super.getConstraintFor(request, child);
        }
        Object currentConstraint = childModel.getLayoutData();
        PortConstraint newConstraint = new PortConstraint();
        newConstraint.setRequestedBounds((Rectangle)super.getConstraintFor(request, child));
        if (request.getExtendedData().containsKey("newHandleBounds")) {
            Rectangle handleBounds = (Rectangle)request.getExtendedData().get("newHandleBounds");
            Point requestedCentre = handleBounds.getCenter();
            requestedCentre.translate(this.getLayoutOrigin().getNegated());
            newConstraint.setRequestedCenter(requestedCentre);
        }
        if ("resize children".equals(request.getType())) {
            newConstraint.setReferenceBorder(((PortConstraint)currentConstraint).getReferenceBorder());
        } else {
            PortContainerLayout layout = (PortContainerLayout)this.getHostFigure().getLayoutManager();
            layout.determineReferenceBorder(this.getHostFigure(), newConstraint);
        }
        return newConstraint;
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        Object constraint = fig.getParent().getLayoutManager().getConstraint(fig);
        if (constraint == null) {
            return null;
        }
        if (constraint instanceof Rectangle) {
            return (Rectangle)constraint;
        }
        return ((PortConstraint)constraint).getRequestedBounds();
    }

    protected Point getLayoutOrigin() {
        IFigure container = this.getLayoutContainer();
        PortContainerLayout layout = (PortContainerLayout)container.getLayoutManager();
        return layout.getOrigin(this.getLayoutContainer());
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart childPart = (GraphicalEditPart)editParts.get(i);
            Object constraint = this.getConstraintFor(request, childPart);
            Rectangle r = constraint instanceof Rectangle ? (Rectangle)constraint : ((PortConstraint)constraint).getRequestedBounds();
            r.translate(this.getLayoutOrigin());
            childPart.getFigure().translateToAbsolute((Translatable)r);
            this.getLayoutContainer().translateToRelative((Translatable)r);
            this.getLayoutContainer().translateFromParent((Translatable)r);
            r.translate(this.getLayoutOrigin().getNegated());
            if (constraint instanceof Rectangle) {
                constraint = r;
            } else {
                ((PortConstraint)constraint).setRequestedBounds(r);
            }
            command.add(this.createAddCommand((EditPart)childPart, this.translateToModelConstraint(constraint)));
            ++i;
        }
        return command.unwrap();
    }
}

