/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portcontainer;

import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.common.portcontainer.SatelliteChildrenSelectionPolicy;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public class SatelliteChildrenSelectionPolicy
extends GraphicalEditPolicy {
    private List<PolylineConnection> focuslinks = new ArrayList();
    private EditPartListener selectionListener;
    private EditPartListener compositionListener;
    private int state = -1;
    private EditPart mainEditPart;

    public void activate() {
        super.activate();
        this.addSelectionListener();
        this.setSelectedState(this.getHost().getSelected());
    }

    public void deactivate() {
        this.removeSelectionListener();
        this.setSelectedState(0);
        super.deactivate();
    }

    public EditPart getTargetEditPart(Request request) {
        if ("selection".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void addSelectionListener() {
        if (this.compositionListener == null) {
            this.compositionListener = new CompositionListener(this);
        }
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(this);
        }
        this.getHost().addEditPartListener(this.selectionListener);
        this.getHost().addEditPartListener(this.compositionListener);
        for (Object o : this.getHost().getChildren()) {
            EditPart c = (EditPart)o;
            c.addEditPartListener(this.selectionListener);
            if (!this.isMainPart(c)) continue;
            this.mainEditPart = c;
        }
    }

    protected EditPartListener getSelectionListener() {
        return this.selectionListener;
    }

    protected void hideSelection() {
        for (PolylineConnection l : this.focuslinks) {
            this.removeFeedback((IFigure)l);
        }
        this.focuslinks.clear();
    }

    protected boolean isMainPart(EditPart child) {
        if (!(child.getModel() instanceof GmNodeModel)) {
            return false;
        }
        GmNodeModel m = (GmNodeModel)child.getModel();
        GmPortContainer pc = (GmPortContainer)m.getParentNode();
        return pc != null && pc.getMainNode() == m;
    }

    protected boolean isSatellitePart(EditPart child) {
        if (!(child.getModel() instanceof GmNodeModel)) {
            return false;
        }
        GmNodeModel m = (GmNodeModel)child.getModel();
        GmPortContainer pc = (GmPortContainer)m.getParentNode();
        return pc.isSatellite(m);
    }

    protected void removeSelectionListener() {
        this.getHost().removeEditPartListener(this.selectionListener);
        this.getHost().removeEditPartListener(this.compositionListener);
        for (Object o : this.getHost().getChildren()) {
            EditPart c = (EditPart)o;
            c.removeEditPartListener(this.selectionListener);
        }
    }

    protected void setMainEditPart(EditPart p) {
        this.mainEditPart = p;
    }

    protected void setSelectedState(int type) {
        if (this.state == type) {
            return;
        }
        this.state = type;
        if (type == 2) {
            this.showPrimarySelection();
        } else if (type == 1) {
            this.showSelection();
        } else {
            this.hideSelection();
        }
    }

    protected void showPrimarySelection() {
        this.showSelection();
    }

    protected void showSelection() {
        if (this.mainEditPart == null) {
            return;
        }
        IFigure mainfig = ((GraphicalEditPart)this.mainEditPart).getFigure();
        ChopboxAnchor targetAnchor = new ChopboxAnchor(mainfig);
        for (Object o : this.getHost().getChildren()) {
            EditPart childPart = (EditPart)o;
            if (!this.isSatellitePart(childPart)) continue;
            IFigure childFig = ((GraphicalEditPart)childPart).getFigure();
            ChopboxAnchor srcAnchor = new ChopboxAnchor(childFig);
            PolylineConnection focuslink = new PolylineConnection();
            focuslink.setSourceAnchor((ConnectionAnchor)srcAnchor);
            focuslink.setTargetAnchor((ConnectionAnchor)targetAnchor);
            focuslink.setLineStyle(3);
            this.addFeedback((IFigure)focuslink);
            this.focuslinks.add(focuslink);
        }
    }
}

