/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portcontainer;

import com.modeliosoft.modelio.diagram.elements.common.portcontainer.PortConstraint;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;

public class TranslateChildrenCommand
extends Command {
    private Point moveDelta;
    private GraphicalEditPart container;
    private static final PrecisionRectangle tempRect = new PrecisionRectangle();
    private static final PrecisionPoint tempPoint = new PrecisionPoint();

    public TranslateChildrenCommand(GraphicalEditPart container, Point moveDelta) {
        this.container = container;
        this.moveDelta = moveDelta;
    }

    public void execute() {
        for (Object childObj : this.container.getChildren()) {
            EditPart childEditPart = (EditPart)childObj;
            GmNodeModel childModel = (GmNodeModel)childEditPart.getModel();
            if (!this.container.getModel().equals(childModel.getParent())) continue;
            if (childModel.getLayoutData() instanceof Rectangle) {
                Rectangle originalRect = (Rectangle)childModel.getLayoutData();
                Rectangle translatedRect = this.translateRect(originalRect);
                childModel.setLayoutData((Object)translatedRect);
                continue;
            }
            if (!(childModel.getLayoutData() instanceof PortConstraint)) continue;
            PortConstraint oldConstraint = (PortConstraint)childModel.getLayoutData();
            PortConstraint newConstraint = new PortConstraint();
            newConstraint.setRequestedBounds(this.translateRect(oldConstraint.getRequestedBounds()));
            if (oldConstraint.getRequestedCenter() != null) {
                newConstraint.setRequestedCenter(this.translatePoint(oldConstraint.getRequestedCenter()));
            }
            newConstraint.setReferenceBorder(oldConstraint.getReferenceBorder());
            childModel.setLayoutData((Object)newConstraint);
        }
    }

    private Rectangle translateRect(Rectangle rect) {
        tempRect.setBounds(rect);
        this.container.getFigure().translateToAbsolute((Translatable)tempRect);
        tempRect.translate(this.moveDelta);
        this.container.getFigure().translateToRelative((Translatable)tempRect);
        return new Rectangle((Rectangle)tempRect);
    }

    private Point translatePoint(Point point) {
        tempPoint.setLocation(point);
        this.container.getFigure().translateToAbsolute((Translatable)tempPoint);
        tempPoint.translate(this.moveDelta);
        this.container.getFigure().translateToRelative((Translatable)tempPoint);
        return new Point((Point)tempPoint);
    }
}

