/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.resizablegroup;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class AddChildToGroupCommand
extends Command {
    private int newConstraint;
    private ModelioCreationContext context;
    private GmNodeModel insertAfter;
    private IElement parentElement;
    private GmCompositeNode parentNode;

    public AddChildToGroupCommand(EditPart parentEditPart, ModelioCreationContext context, GmNodeModel insertAfter, int newConstraint) {
        this.parentNode = (GmCompositeNode)parentEditPart.getModel();
        this.parentElement = this.parentNode.getRelatedIElement();
        if (this.parentElement instanceof IAbstractDiagram) {
            this.parentElement = ((IAbstractDiagram)this.parentElement).getOrigin();
        }
        this.context = context;
        this.insertAfter = insertAfter;
        this.newConstraint = newConstraint;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IElement newElement = this.context.getElementToUnmask();
        if (newElement != null) {
            this.unmaskAdditionalChild(diagram, newElement);
        } else {
            this.executeCreation(diagram);
        }
    }

    private void executeCreation(GmAbstractDiagram diagram) {
        IModelFactory modelFactory = diagram.getModelFactory();
        IElement newElement = modelFactory.createElement(this.context.getMetaclass());
        Meta meta = new Meta(this.parentElement);
        try {
            String dependency = this.context.getDependency();
            if (dependency == null) {
                dependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
            }
            meta.appendToDependency(dependency, newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, newElement);
            }
            modelFactory.deleteElement(newElement);
            return;
        }
        if (this.context.getStereotype() != null) {
            ((IModelElement)newElement).addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        elementInitializer.initialize(newElement, this.context.getProperties());
        this.unmaskAdditionalChild(diagram, newElement);
    }

    private GmCompositeNode unmaskAdditionalChild(GmAbstractDiagram diagram, IElement newElement) {
        int nbOfChildren = this.parentNode.getChildren().size();
        for (GmNodeModel child : this.parentNode.getChildren()) {
            Integer childConstraint = (Integer)child.getLayoutData();
            if (childConstraint == -1) continue;
            childConstraint = childConstraint * nbOfChildren / (nbOfChildren + 1);
            child.setLayoutData((Object)childConstraint);
        }
        GmCompositeNode newChild = (GmCompositeNode)diagram.unmask(this.parentNode, newElement, (Object)this.newConstraint);
        this.parentNode.moveChild((GmNodeModel)newChild, this.parentNode.getChildren().indexOf(this.insertAfter));
        return newChild;
    }

    public boolean canExecute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)diagram)) {
            return false;
        }
        if (this.context.getElementToUnmask() == null) {
            return AuthHelper.canAdd((IElement)this.parentElement, (String)this.context.getMetaclass());
        }
        return true;
    }
}

