/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.text;

import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmSimpleNode;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.ProxyStyle;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.Collections;
import java.util.List;

public abstract class GmElementText
extends GmSimpleNode {
    protected String label = null;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmElementText() {
    }

    public GmElementText(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
    }

    public String getText() {
        if (this.label == null) {
            this.updateTextFromModel();
        }
        return this.label;
    }

    public final StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public StyleKey getStyleKey(MetaKey metakey) {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getStyleKey(metakey);
    }

    public List<StyleKey> getStyleKeys() {
        if (this.getParent() == null) {
            return Collections.emptyList();
        }
        return this.getParent().getStyleKeys();
    }

    public void refreshFromObModel() {
        if (this.updateTextFromModel()) {
            this.firePropertyChange("Name", null, (Object)this.label);
        }
    }

    public void setParentLink(GmLink parentLink) throws IllegalStateException {
        if (parentLink != null && this.getParent() != parentLink) {
            this.getStyle().setCascadedStyle(parentLink.getStyle());
        }
        super.setParentLink(parentLink);
    }

    protected abstract String computeText();

    protected IStyle createStyle(GmAbstractDiagram aDiagram) {
        return new ProxyStyle(aDiagram.getStyle());
    }

    protected void setParent(GmCompositeNode newParent) throws IllegalStateException {
        GmModel oldParent = this.getParent();
        super.setParent(newParent);
        if (newParent != null && oldParent != newParent) {
            this.getStyle().setCascadedStyle(newParent.getStyle());
        }
    }

    private boolean updateTextFromModel() {
        if (this.getRelatedIElement() != null) {
            String newLabel = this.computeText();
            if (newLabel.equals(this.label)) {
                return false;
            }
            this.label = newLabel;
            return true;
        }
        return false;
    }

    public abstract IEditableText getEditableText();

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmElementText.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        if (false) {
            out.writeProperty("GmElementText.version", (Object)0);
        }
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
    }

    public int getMajorVersion() {
        return 0;
    }
}

