/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.text;

import com.modeliosoft.modelio.diagram.elements.common.text.GmElementText;
import com.modeliosoft.modelio.diagram.elements.common.text.GmElementTextEditPart;
import com.modeliosoft.modelio.diagram.elements.common.text.MultilineTextFigure;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDirectEditPolicy;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class GmElementTextEditPart
extends GmNodeEditPart {
    public void performRequest(Request req) {
        if (req.getType() == "direct edit") {
            if (((GmModel)this.getModel()).getEditableText() == null) {
                return;
            }
            1 cellEditorLocator = new /* Unavailable Anonymous Inner Class!! */;
            2 manager = new /* Unavailable Anonymous Inner Class!! */;
            manager.show();
        }
        super.performRequest(req);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Name")) {
            IFigure aFigure = this.getFigure();
            Dimension currentSize = aFigure.getSize();
            aFigure.translateToAbsolute((Translatable)currentSize);
            this.refreshVisuals();
            Dimension updatedPrefSize = aFigure.getPreferredSize().getCopy();
            aFigure.translateToAbsolute((Translatable)updatedPrefSize);
            if (!currentSize.isEmpty() && !updatedPrefSize.equals((Object)currentSize)) {
                ChangeBoundsRequest changeBoundsRequest = new ChangeBoundsRequest((Object)"resize");
                changeBoundsRequest.setEditParts((EditPart)this);
                changeBoundsRequest.setSizeDelta(updatedPrefSize.getShrinked(currentSize));
                Command resizeCommand = this.getCommand((Request)changeBoundsRequest);
                if (resizeCommand != null && resizeCommand.canExecute()) {
                    resizeCommand.execute();
                }
            }
        } else {
            super.propertyChange(evt);
        }
    }

    protected void createEditPolicies() {
        if (((GmModel)this.getModel()).getEditableText() != null) {
            this.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new DefaultElementDirectEditPolicy());
        }
    }

    protected IFigure createFigure() {
        GmElementText model = (GmElementText)this.getModel();
        MultilineTextFigure f = new MultilineTextFigure(model.getText());
        f.setTextAlignment(1);
        f.setOpaque(false);
        this.refreshFromStyle((IFigure)f, model.getStyle());
        return f;
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        GmElementText model = (GmElementText)this.getModel();
        aFigure.setForegroundColor(style.getColor(model.getStyleKey(MetaKey.TEXTCOLOR)));
        aFigure.setFont(style.getFont(model.getStyleKey(MetaKey.FONT)));
        this.updateVisibility(aFigure);
    }

    protected void refreshVisuals() {
        GmElementText model = (GmElementText)this.getModel();
        MultilineTextFigure labelFigure = (MultilineTextFigure)this.getFigure();
        labelFigure.setText(model.getText());
        Object layoutData = model.getLayoutData();
        if (layoutData != null) {
            labelFigure.getParent().setConstraint((IFigure)labelFigure, layoutData);
        }
    }

    private void updateVisibility(IFigure aFigure) {
        boolean visible = ((GmElementText)this.getModel()).isVisible();
        if (visible) {
            aFigure.setVisible(true);
        } else {
            aFigure.setVisible(false);
        }
    }

    public boolean isSelectable() {
        return false;
    }
}

