/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.MmHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.gef.commands.Command;

public class DefaultCreateElementCommand
extends Command {
    private ModelioCreationContext context;
    private Object constraint;
    private IElement parentElement;
    private GmCompositeNode parentNode;

    public DefaultCreateElementCommand(GmCompositeNode parentNode, ModelioCreationContext context, Object constraint) {
        this.parentNode = parentNode;
        this.parentElement = parentNode.getRelatedIElement();
        this.context = context;
        this.constraint = constraint;
    }

    public DefaultCreateElementCommand(IElement parentElement, GmCompositeNode parentNode, ModelioCreationContext context, Object constraint) {
        this.parentNode = parentNode;
        this.parentElement = parentElement;
        this.context = context;
        this.constraint = constraint;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IElement newElement = this.context.getElementToUnmask();
        if (newElement == null) {
            IModelFactory modelFactory = diagram.getModelFactory();
            newElement = modelFactory.createElement(this.context.getMetaclass());
            String effectiveDependency = this.context.getDependency();
            if (effectiveDependency == null) {
                effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
            }
            Meta meta = new Meta(this.parentElement);
            try {
                meta.appendToDependency(effectiveDependency, newElement);
            }
            catch (InvalidModelManipulationException e) {
                String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
                if (compositionDep != null && !compositionDep.equals("")) {
                    meta.appendToDependency(compositionDep, newElement);
                }
                modelFactory.deleteElement(newElement);
                return;
            }
            if (this.context.getStereotype() != null && newElement instanceof IModelElement) {
                ((IModelElement)newElement).addExtension(this.context.getStereotype());
            }
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize(newElement, this.context.getProperties());
        }
        diagram.unmask(this.parentNode, newElement, this.constraint);
    }

    protected ModelioCreationContext getContext() {
        return this.context;
    }

    protected Object getConstraint() {
        return this.constraint;
    }

    protected IElement getParentElement() {
        return this.parentElement;
    }

    protected GmCompositeNode getParentNode() {
        return this.parentNode;
    }

    public boolean canExecute() {
        GmAbstractDiagram gmDiagram = this.parentNode.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        if (this.context.getElementToUnmask() == null) {
            Class toCreate = MetaModelExpert.getMetaclass((String)this.context.getMetaclass());
            if (!AuthHelper.canAdd((IElement)this.parentElement, (String)this.context.getMetaclass())) {
                return false;
            }
            return MmHelper.canAddTo((IElement)this.parentElement, (Class)toCreate);
        }
        return true;
    }
}

