/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.MmHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class DefaultReparentElementCommand
extends Command {
    private Object newLayoutData;
    private GmCompositeNode newParent;
    private IElement newParentElement;
    private GmNodeModel reparentedChild;

    public DefaultReparentElementCommand(IElement newParentElement, GmCompositeNode newParent, GmNodeModel reparentedChild, Object newLayoutData) {
        this.newParentElement = newParentElement;
        this.newParent = newParent;
        this.reparentedChild = reparentedChild;
        this.newLayoutData = newLayoutData;
    }

    public boolean canExecute() {
        IElement childElement = this.reparentedChild.getRelatedIElement();
        if (this.newParentElement == null || childElement == null) {
            return false;
        }
        if (this.newParentElement.equals((Object)childElement)) {
            return false;
        }
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.reparentedChild.getDiagram())) {
            return false;
        }
        if (!childElement.getElementStatus().isModifiable()) {
            return false;
        }
        if (!AuthHelper.canAdd((IElement)this.newParentElement, (String)childElement.getMetaclassName())) {
            return false;
        }
        if (!AuthHelper.canAdd((IElement)childElement.getCompositionOwner(), (String)childElement.getMetaclassName())) {
            return false;
        }
        return MmHelper.canAddTo((IElement)this.newParentElement, (IElement)childElement);
    }

    public void execute() {
        IElement childElement = this.reparentedChild.getRelatedIElement();
        assert (childElement != null) : "cannot reparent: child element is null";
        String oldParentDep = CompositionServices.getCompositionParentDep((IElement)childElement);
        IElement oldParentElement = childElement.getCompositionOwner();
        new Meta(oldParentElement).removeFromDependency(oldParentDep, childElement);
        GmModel oldParentModel = this.reparentedChild.getParent();
        assert (oldParentModel instanceof GmCompositeNode) : "This command should only be used if both old parent and new parent are instances of GmCompositeNode!";
        GmCompositeNode oldParent = (GmCompositeNode)oldParentModel;
        oldParent.removeChild(this.reparentedChild);
        try {
            new Meta(this.newParentElement).appendToDependency(oldParentDep, childElement);
        }
        catch (InvalidModelManipulationException e) {
            String newParentDep = CompositionExpert.getDefaultCompositionDep((IElement)this.newParentElement, (IElement)childElement);
            new Meta(this.newParentElement).appendToDependency(newParentDep, childElement);
        }
        this.reparentedChild.setLayoutData(this.newLayoutData);
        if (this.newParent.canContain(this.reparentedChild.getClass())) {
            this.newParent.addChild(this.reparentedChild);
        } else {
            if (this.newLayoutData instanceof Rectangle) {
                Rectangle r = (Rectangle)this.newLayoutData;
                this.newLayoutData = new Rectangle(r.x, r.y, -1, -1);
            }
            this.newParent.getDiagram().unmask(this.newParent, this.reparentedChild.getRelatedIElement(), this.newLayoutData);
            this.reparentedChild.delete();
        }
    }
}

