/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.GroupRequest;

public class DeferredGroupCommand
extends Command {
    private GroupRequest req;
    private GmCompositeNode gmClass;
    private Map<?, ?> editPartRegistry;

    public DeferredGroupCommand(GroupRequest req, EditPart sender) {
        this.req = req;
        this.gmClass = (GmCompositeNode)sender.getModel();
        this.editPartRegistry = sender.getViewer().getEditPartRegistry();
    }

    public boolean canExecute() {
        return this.getGmTarget() != null;
    }

    public void execute() {
        EditPart p;
        GmCompositeNode gmTarget = this.getGmTarget();
        if (!gmTarget.isVisible()) {
            gmTarget.setVisible(true);
        }
        if ((p = (EditPart)this.editPartRegistry.get(gmTarget)) != null) {
            p.getTargetEditPart((Request)this.req).getCommand((Request)this.req).execute();
        }
    }

    private GmCompositeNode getGmTarget() {
        GmCompositeNode gmTarget = null;
        for (Object o : this.req.getEditParts()) {
            EditPart part = (EditPart)o;
            GmModel model = (GmModel)part.getModel();
            String metaclassName = model.getRepresentedRef().mc;
            Class metaclass = MetaModelExpert.getMetaclass((String)metaclassName);
            GmCompositeNode cont = this.gmClass.getCompositeFor(metaclass);
            if (cont == null) {
                return null;
            }
            if (gmTarget == null) {
                gmTarget = cont;
                continue;
            }
            if (gmTarget == cont) continue;
            return null;
        }
        return gmTarget;
    }
}

