/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ExpandToContentCommand
extends Command {
    private GraphicalEditPart editPart;

    public ExpandToContentCommand(GraphicalEditPart editPart) {
        this.editPart = editPart;
    }

    public void execute() {
        Command resizeCommand = this.getResizeCommand();
        if (resizeCommand != null && resizeCommand.canExecute()) {
            resizeCommand.execute();
        }
    }

    private Command getResizeCommand() {
        IFigure fig = this.editPart.getFigure();
        Dimension oldSize = fig.getSize();
        Dimension newSize = fig.getPreferredSize();
        Dimension diff = newSize.getDifference(oldSize);
        if (diff.isEmpty()) {
            return null;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move");
        req.setEditParts((EditPart)this.editPart);
        req.setSizeDelta(diff);
        req.setMoveDelta(new Point(0, 0));
        return this.editPart.getCommand((Request)req);
    }

    public boolean canExecute() {
        Command resizeCommand = this.getResizeCommand();
        return resizeCommand != null && resizeCommand.canExecute();
    }
}

