/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class FitToContentCommand
extends Command {
    private GraphicalEditPart editPart;

    public FitToContentCommand(GraphicalEditPart editPart) {
        this.editPart = editPart;
    }

    public void execute() {
        Command resizeCommand = this.getResizeCommand();
        if (resizeCommand != null && resizeCommand.canExecute()) {
            resizeCommand.execute();
        }
    }

    private Command getResizeCommand() {
        Dimension newSize;
        IFigure fig = this.editPart.getFigure();
        Dimension oldSize = fig.getSize();
        if (oldSize.equals((Object)(newSize = fig.getPreferredSize()))) {
            return null;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setEditParts((EditPart)this.editPart);
        req.setSizeDelta(newSize.getShrinked(oldSize));
        req.setMoveDelta(new Point(0, 0));
        return this.editPart.getCommand((Request)req);
    }

    public boolean canExecute() {
        Command resizeCommand = this.getResizeCommand();
        return resizeCommand == null || resizeCommand.canExecute();
    }
}

