/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.diagram.elements.common.portcontainer.GmPortContainer;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class FitToMinSizeCommand
extends Command {
    private GraphicalEditPart editPart;

    public FitToMinSizeCommand(GraphicalEditPart editPart) {
        this.editPart = editPart;
    }

    public void execute() {
        Command resizeCommand = this.getResizeCommand();
        if (resizeCommand != null && resizeCommand.canExecute()) {
            resizeCommand.execute();
        }
    }

    private Command getResizeCommand() {
        IFigure fig = this.editPart.getFigure();
        Dimension oldSize = this.getEffectiveBounds(fig).getSize();
        fig.translateToAbsolute((Translatable)oldSize);
        Dimension newSize = this.getMinimumSize(fig);
        fig.translateToAbsolute((Translatable)newSize);
        if (oldSize.equals((Object)newSize)) {
            return null;
        }
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setEditParts((EditPart)this.editPart);
        req.setSizeDelta(newSize.getCopy().shrink(oldSize));
        req.setMoveDelta(new Point(0, 0));
        return this.editPart.getCommand((Request)req);
    }

    public boolean canExecute() {
        Command resizeCommand = this.getResizeCommand();
        return resizeCommand == null || resizeCommand.canExecute();
    }

    private Dimension getMinimumSize(IFigure figure) {
        GraphicalEditPart mainNodeEditPart;
        GmPortContainer gpc;
        GmNodeModel mainNode;
        if (this.editPart.getModel() instanceof GmPortContainer && (mainNode = (gpc = (GmPortContainer)this.editPart.getModel()).getMainNode()) != null && (mainNodeEditPart = (GraphicalEditPart)this.editPart.getViewer().getEditPartRegistry().get(mainNode)) != null) {
            IFigure mainFig = mainNodeEditPart.getFigure();
            return mainFig.getMinimumSize();
        }
        return figure.getMinimumSize();
    }

    protected Rectangle getEffectiveBounds(IFigure figure) {
        return figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds().getCopy() : figure.getBounds().getCopy();
    }
}

