/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultCreateElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.FitToMinSizeCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class SimpleModeDeferredCreateCommand
extends Command {
    private CreateRequest req;
    private GmCompositeNode gmComposite;
    private Map<?, ?> editPartRegistry;

    public SimpleModeDeferredCreateCommand(CreateRequest req, EditPart sender) {
        this.req = req;
        this.gmComposite = (GmCompositeNode)sender.getModel();
        this.editPartRegistry = sender.getViewer().getEditPartRegistry();
    }

    public boolean canExecute() {
        GmCompositeNode gmTarget = this.getTargetNode();
        if (gmTarget != null) {
            ModelioCreationContext ctx = (ModelioCreationContext)this.req.getNewObject();
            return new DefaultCreateElementCommand(gmTarget, ctx, (Object)this.req.getLocation()).canExecute();
        }
        return false;
    }

    public void execute() {
        Command cmd = this.getCommand();
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
            GmCompositeNode gmTarget = this.getTargetNode();
            EditPart p = (EditPart)this.editPartRegistry.get(gmTarget);
            this.autoSizeNode(p);
            for (Object sub : p.getChildren()) {
                this.autoSizeNode((EditPart)((GraphicalEditPart)sub));
            }
        }
    }

    private Command getCommand() {
        EditPart targetEditPart;
        EditPart p;
        GmCompositeNode gmTarget = this.getTargetNode();
        if (gmTarget == null) {
            return null;
        }
        if (!gmTarget.isVisible()) {
            gmTarget.setVisible(true);
        }
        if ((p = (EditPart)this.editPartRegistry.get(gmTarget)) != null && (targetEditPart = p.getTargetEditPart((Request)this.req)) != null) {
            return targetEditPart.getCommand((Request)this.req);
        }
        return null;
    }

    private GmCompositeNode getTargetNode() throws IllegalArgumentException {
        String metaclassName = (String)this.req.getNewObjectType();
        Class metaclass = MetaModelExpert.getMetaclass((String)metaclassName);
        GmCompositeNode gmTarget = this.gmComposite.getCompositeFor(metaclass);
        return gmTarget;
    }

    private void autoSizeNode(EditPart newEditPart) {
        ChangeBoundsRequest reqSize = new ChangeBoundsRequest((Object)"resize");
        reqSize.setEditParts(newEditPart);
        reqSize.setSizeDelta(new Dimension(-1, -1));
        EditPart editPart = newEditPart;
        while (editPart != null && !editPart.understandsRequest((Request)reqSize)) {
            editPart = editPart.getParent();
            reqSize.setEditParts(newEditPart);
        }
        if (editPart != null) {
            GraphicalEditPart graphicEditPart = (GraphicalEditPart)editPart;
            graphicEditPart.refresh();
            graphicEditPart.getFigure().getUpdateManager().performValidation();
            new FitToMinSizeCommand(graphicEditPart).execute();
        }
    }
}

