/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.commands;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.FitToMinSizeCommand;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;

public class SimpleModeDeferredGroupCommand
extends Command {
    private GroupRequest req;
    private GmCompositeNode gmComposite;
    private Map<?, ?> editPartRegistry;

    public SimpleModeDeferredGroupCommand(GroupRequest req, EditPart sender) {
        this.req = req;
        this.gmComposite = (GmCompositeNode)sender.getModel();
        this.editPartRegistry = sender.getViewer().getEditPartRegistry();
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.gmComposite.getDiagram())) {
            return false;
        }
        GmCompositeNode target = this.getGmTarget();
        if (target == null) {
            return false;
        }
        IElement parentEl = target.getRelatedIElement();
        if (parentEl == null) {
            return false;
        }
        for (Object o : this.req.getEditParts()) {
            EditPart part = (EditPart)o;
            GmModel model = (GmModel)part.getModel();
            IElement childEl = model.getRelatedIElement();
            if (childEl != null && AuthHelper.canAdd((IElement)parentEl, (String)childEl.getMetaclassName())) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        Command cmd = this.getCommand();
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
            GmCompositeNode gmTarget = this.getGmTarget();
            EditPart p = (EditPart)this.editPartRegistry.get(gmTarget);
            this.autoSizeNode((EditPart)((GraphicalEditPart)p));
        }
    }

    private GmCompositeNode getGmTarget() {
        GmCompositeNode gmTarget = null;
        for (Object o : this.req.getEditParts()) {
            EditPart part = (EditPart)o;
            GmModel model = (GmModel)part.getModel();
            String metaclassName = model.getRepresentedRef().mc;
            Class metaclass = MetaModelExpert.getMetaclass((String)metaclassName);
            GmCompositeNode cont = this.gmComposite.getCompositeFor(metaclass);
            if (cont == null) {
                return null;
            }
            if (gmTarget == null) {
                gmTarget = cont;
                continue;
            }
            if (gmTarget == cont) continue;
            return null;
        }
        return gmTarget;
    }

    private Command getCommand() {
        EditPart targetEditPart;
        EditPart p;
        GmCompositeNode gmTarget = this.getGmTarget();
        if (gmTarget == null) {
            return null;
        }
        if (!gmTarget.isVisible()) {
            gmTarget.setVisible(true);
        }
        if ((p = (EditPart)this.editPartRegistry.get(gmTarget)) != null && (targetEditPart = p.getTargetEditPart((Request)this.req)) != null) {
            return targetEditPart.getCommand((Request)this.req);
        }
        return null;
    }

    private void autoSizeNode(EditPart newEditPart) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setEditParts(newEditPart);
        req.setSizeDelta(new Dimension(-1, -1));
        EditPart editPart = newEditPart;
        while (editPart != null && !editPart.understandsRequest((Request)req)) {
            editPart = editPart.getParent();
            req.setEditParts(newEditPart);
        }
        if (editPart != null) {
            GraphicalEditPart graphicEditPart = (GraphicalEditPart)editPart;
            graphicEditPart.refresh();
            graphicEditPart.getFigure().getUpdateManager().performValidation();
            new FitToMinSizeCommand(graphicEditPart).execute();
        }
    }
}

