/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ColorizableImageFigure
extends Figure {
    private Image originalImage;
    private Color color;

    public ColorizableImageFigure(Image image) {
        this(image, Display.getCurrent().getSystemColor(2));
    }

    public ColorizableImageFigure(Image image, Color color) {
        assert (image != null);
        assert (color != null);
        this.color = color;
        this.originalImage = image;
    }

    protected void paintFigure(Graphics gc) {
        super.paintFigure(gc);
        Image colorizedImage = new Image(this.originalImage.getDevice(), this.originalImage.getImageData());
        this.colorize(colorizedImage, this.color);
        org.eclipse.swt.graphics.Rectangle rect = colorizedImage.getBounds();
        Rectangle area = this.getClientArea();
        gc.drawImage(colorizedImage, rect.x, rect.y, rect.width, rect.height, area.x, area.y, area.width, area.height);
        colorizedImage.dispose();
    }

    protected void finalize() {
        this.originalImage = null;
    }

    private void colorize(Image image, Color color) {
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRectangle(image.getBounds());
        gc.dispose();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
    }
}

