/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.elements.core.figures.EllipseShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.IShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.ShapedFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ShapedBorder;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class EllipseFigure
extends ShapedFigure {
    private ShapedBorder shapedBorder;
    private String label = null;
    private Dimension textSize = null;
    private Font textFont = null;

    public EllipseFigure() {
        super((IShaper)new EllipseShaper());
        this.shapedBorder = new ShapedBorder(this.penOptions.lineColor, this.penOptions.lineWidth, this.shaper);
        this.setBorder((Border)this.shapedBorder);
        this.setSize(20, 20);
        this.setOpaque(true);
    }

    public void setBounds(Rectangle rect) {
        Rectangle oldBounds = this.getBounds();
        if (oldBounds == null || oldBounds.width != rect.width || oldBounds.height != rect.height) {
            super.setBounds(rect);
            this.computeFont(this.getClientArea());
        } else {
            super.setBounds(rect);
        }
    }

    public void setLabel(String string) {
        this.label = string;
        this.computeFont(this.getClientArea());
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.shapedBorder.setColor(lineColor);
            super.setLineColor(lineColor);
        }
    }

    public void setLinePattern(StyleKey.LinePattern lineStyle) {
        if (this.penOptions.linePattern != lineStyle) {
            this.shapedBorder.setStyle(lineStyle.toSWTConstant());
            super.setLinePattern(lineStyle);
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            if (lineWidth == 0) {
                this.setBorder(null);
            } else {
                this.setBorder((Border)this.shapedBorder);
                this.shapedBorder.setWidth(lineWidth);
            }
            super.setLineWidth(lineWidth);
        }
    }

    public void setTextFont(Font textFont) {
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.label != null) {
            if (this.textSize == null) {
                this.computeFont(this.getClientArea());
            }
            Dimension delta = this.getBounds().getSize().getDifference(this.textSize).scale(0.5);
            Point textLocation = this.getBounds().getLocation().translate(delta);
            graphics.setFont(this.textFont);
            graphics.setForegroundColor(this.getLineColor());
            graphics.drawText(this.label, textLocation);
            graphics.restoreState();
        }
    }

    private void computeFont(Rectangle rect) {
        FontData[] fontData;
        Font figureFont = this.getFont();
        if (this.label == null || figureFont == null) {
            return;
        }
        double maxTextW = rect.width - 2;
        double maxTextH = rect.height - 2;
        Dimension extents = FigureUtilities.getStringExtents((String)this.label, (Font)figureFont);
        double zoomH = maxTextH / (double)extents.height;
        double zoomW = maxTextW / (double)extents.width;
        double neededZoom = Math.max(zoomH, zoomW);
        if ((double)extents.width * neededZoom > maxTextW) {
            neededZoom = zoomW;
        } else if ((double)extents.height * neededZoom > maxTextH) {
            neededZoom = zoomH;
        }
        this.textSize = extents.scale(neededZoom);
        FontData[] fontDataArray = fontData = figureFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData d = fontDataArray[n2];
            d.setHeight((int)((double)d.getHeight() * neededZoom));
            ++n2;
        }
        this.textFont = CoreFontRegistry.getFont((FontData[])fontData);
    }
}

