/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import com.modeliosoft.modelio.diagram.elements.core.figures.BrushOptions;
import com.modeliosoft.modelio.diagram.elements.core.figures.IBrushOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.IPenOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.PenOptions;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;

public class GradientFigure
extends Figure
implements HandleBounds,
IBrushOptionsSupport,
IPenOptionsSupport {
    protected BrushOptions brushOptions = new BrushOptions();
    private static Rectangle tempRect = new Rectangle();
    protected PenOptions penOptions = new PenOptions();

    public Rectangle getHandleBounds() {
        return this.getBounds().getCopy();
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque() && this.brushOptions.fillColor != null) {
            Color base = this.brushOptions.fillColor;
            Color gradientColor = this.brushOptions.useGradient ? this.computeGradientColor(base) : base;
            graphics.setBackgroundColor(gradientColor);
            graphics.setForegroundColor(base);
            tempRect = this.getBounds();
            if (this.brushOptions.useGradient) {
                graphics.fillGradient(tempRect, false);
                gradientColor.dispose();
            } else {
                graphics.fillRectangle(tempRect);
            }
        }
        graphics.restoreState();
    }

    protected Color computeGradientColor(Color base) {
        Color derivedColor = new Color(base.getDevice(), new RGB(255, 255, 255));
        return derivedColor;
    }

    public void setFillColor(Color fillColor) {
        if (this.brushOptions.fillColor != fillColor) {
            this.setBackgroundColor(fillColor);
            this.brushOptions.fillColor = fillColor;
            this.repaint();
        }
    }

    public Color getFillColor() {
        return this.brushOptions.fillColor;
    }

    public boolean getUseGradient() {
        return this.brushOptions.useGradient;
    }

    public void setUseGradient(boolean useGradient) {
        if (this.brushOptions.useGradient != useGradient) {
            this.brushOptions.useGradient = useGradient;
            this.repaint();
        }
    }

    public Color getLineColor() {
        return this.penOptions.lineColor;
    }

    public int getLineWidth() {
        return this.penOptions.lineWidth;
    }

    public Color getTextColor() {
        return this.penOptions.textColor;
    }

    public Font getTextFont() {
        return this.penOptions.textFont;
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.penOptions.lineColor = lineColor;
            this.repaint();
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            this.penOptions.lineWidth = lineWidth;
            this.repaint();
        }
    }

    public void setTextColor(Color textColor) {
        if (this.penOptions.textColor != textColor) {
            this.penOptions.textColor = textColor;
            this.repaint();
        }
    }

    public void setTextFont(Font textFont) {
        if (this.penOptions.textFont != textFont) {
            this.penOptions.textFont = textFont;
            this.repaint();
        }
    }

    public StyleKey.LinePattern getLinePattern() {
        return this.penOptions.linePattern;
    }

    public void setLinePattern(StyleKey.LinePattern lineStyle) {
        if (this.penOptions.linePattern != lineStyle) {
            this.penOptions.linePattern = lineStyle;
            this.repaint();
        }
    }
}

