/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import com.modeliosoft.modelio.diagram.elements.core.figures.BrushOptions;
import com.modeliosoft.modelio.diagram.elements.core.figures.IBrushOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.IPenOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.PenOptions;
import com.modeliosoft.modelio.diagram.elements.core.figures.RoundedBoxFigure;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class RoundedBoxFigure
extends Figure
implements HandleBounds,
IBrushOptionsSupport,
IPenOptionsSupport {
    private int radius = 14;
    protected BrushOptions brushOptions = new BrushOptions();
    protected PenOptions penOptions = new PenOptions();
    private static Rectangle tempRect = new Rectangle();

    public RoundedBoxFigure() {
        this.setBorder((Border)new RoundedRectangleBorder(this, null, 1));
    }

    public int getAdjustedRadius(Rectangle rect) {
        if (rect.width < this.radius * 3) {
            return rect.width / 3;
        }
        if (rect.height < this.radius * 3) {
            return rect.height / 3;
        }
        return this.radius;
    }

    public Color getFillColor() {
        return this.isOpaque() ? this.brushOptions.fillColor : null;
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCopy();
    }

    public Color getLineColor() {
        return this.penOptions.lineColor;
    }

    public StyleKey.LinePattern getLinePattern() {
        return this.penOptions.linePattern;
    }

    public int getLineWidth() {
        return this.penOptions.lineWidth;
    }

    public int getRadius() {
        return this.radius;
    }

    public Color getTextColor() {
        return this.penOptions.textColor;
    }

    public Font getTextFont() {
        return this.penOptions.textFont;
    }

    public boolean getUseGradient() {
        return this.brushOptions.useGradient;
    }

    public void setFillColor(Color fillColor) {
        if (this.brushOptions.fillColor == fillColor) {
            return;
        }
        this.setOpaque(fillColor != null);
        this.setBackgroundColor(fillColor);
        this.brushOptions.fillColor = fillColor;
        this.repaint();
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor == lineColor) {
            return;
        }
        this.penOptions.lineColor = lineColor;
        ((RoundedRectangleBorder)this.getBorder()).setColor(lineColor);
        this.repaint();
    }

    public void setLinePattern(StyleKey.LinePattern linePattern) {
        if (this.penOptions.linePattern != linePattern) {
            this.penOptions.linePattern = linePattern;
            ((RoundedRectangleBorder)this.getBorder()).setStyle(linePattern.toSWTConstant());
            this.repaint();
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth == lineWidth) {
            return;
        }
        this.penOptions.lineWidth = lineWidth;
        ((RoundedRectangleBorder)this.getBorder()).setWidth(lineWidth);
        this.repaint();
    }

    public void setRadius(int value) {
        this.radius = value;
    }

    public void setTextColor(Color textColor) {
        if (this.penOptions.textColor == textColor) {
            return;
        }
        this.penOptions.textColor = textColor;
        this.repaint();
    }

    public void setTextFont(Font textFont) {
        if (this.penOptions.textFont == textFont) {
            return;
        }
        this.penOptions.textFont = textFont;
        this.repaint();
    }

    public void setUseGradient(boolean useGradient) {
        if (this.brushOptions.useGradient == useGradient) {
            return;
        }
        this.brushOptions.useGradient = useGradient;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        tempRect = this.getBounds();
        int adjustedRadius = this.getAdjustedRadius(tempRect);
        int x = RoundedBoxFigure.tempRect.x;
        int y = RoundedBoxFigure.tempRect.y;
        int w = RoundedBoxFigure.tempRect.width;
        int h = RoundedBoxFigure.tempRect.height;
        if (this.isOpaque()) {
            Color base = this.brushOptions.fillColor;
            Color gradientColor = this.brushOptions.useGradient ? this.computeGradientColor(base) : base;
            graphics.setBackgroundColor(gradientColor);
            graphics.setForegroundColor(base);
            if (adjustedRadius > 0) {
                Path path = new Path((Device)Display.getCurrent());
                path.moveTo((float)x, (float)(y + adjustedRadius));
                path.lineTo((float)x, (float)(y + h - adjustedRadius));
                path.addArc((float)x, (float)(y + h - 2 * adjustedRadius), (float)(2 * adjustedRadius), (float)(2 * adjustedRadius), 180.0f, 90.0f);
                path.lineTo((float)(x + w - adjustedRadius), (float)(y + h));
                path.addArc((float)(x + w - 2 * adjustedRadius), (float)(y + h - 2 * adjustedRadius), (float)(2 * adjustedRadius), (float)(2 * adjustedRadius), -90.0f, 90.0f);
                path.lineTo((float)(x + w), (float)(y + adjustedRadius));
                path.addArc((float)(x + w - 2 * adjustedRadius), (float)y, (float)(2 * adjustedRadius), (float)(2 * adjustedRadius), 0.0f, 90.0f);
                path.lineTo((float)(x + adjustedRadius), (float)y);
                path.addArc((float)x, (float)y, (float)(2 * adjustedRadius), (float)(2 * adjustedRadius), 90.0f, 90.0f);
                graphics.clipPath(path);
            }
            if (this.brushOptions.useGradient) {
                graphics.fillGradient(tempRect, false);
                gradientColor.dispose();
            } else {
                graphics.fillRectangle(tempRect);
            }
        }
        graphics.restoreState();
    }

    private Color computeGradientColor(Color base) {
        Color derivedColor = new Color(base.getDevice(), new RGB(255, 255, 255));
        return derivedColor;
    }
}

