/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import com.modeliosoft.modelio.diagram.elements.core.figures.LinkFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.ZoomDrawer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class RoundedLinkFigure
extends LinkFigure {
    private static final int BRIDGE_RADIUS = 5;
    private boolean bridgesEnabled = false;
    private int radius = 0;

    public Rectangle getBounds() {
        return super.getBounds().getCopy().expand(10, 10);
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isBridgesEnabled() {
        return this.bridgesEnabled;
    }

    public void setBridgesEnabled(boolean value) {
        this.bridgesEnabled = value;
        this.invalidate();
        this.repaint();
    }

    public void setRadius(int radius) {
        if (this.radius == radius) {
            return;
        }
        this.radius = radius;
        this.invalidate();
        this.repaint();
    }

    protected void outlineShape(Graphics g) {
        if (this.radius == 0) {
            this.outlineStraightShape(g);
        } else {
            this.outlineRoundedShape(g);
        }
    }

    private ArrayList<Connection> collectConnections() {
        ArrayList<Connection> result = new ArrayList<Connection>();
        this.collectConnections(this.getRoot(), result);
        return result;
    }

    private void collectConnections(IFigure figure, ArrayList<Connection> list) {
        for (Object I : figure.getChildren()) {
            IFigure child = (IFigure)I;
            if (child instanceof Layer || child instanceof Viewport) {
                this.collectConnections(child, list);
            }
            if (!(child instanceof Connection)) continue;
            list.add((Connection)child);
        }
    }

    private void drawLine(Graphics g, Point pp, Point p1, ArrayList<Connection> connections) {
        if (this.bridgesEnabled && pp.x == p1.x) {
            ArrayList<Integer> segments = new ArrayList<Integer>();
            for (Connection conn : connections) {
                PointList cps = conn.getPoints();
                int j = 0;
                while (j < cps.size() - 1) {
                    Point cp1 = cps.getPoint(j);
                    Point cp2 = cps.getPoint(j + 1);
                    if (cp1.y == cp2.y && (cp1.x < pp.x && cp2.x > pp.x || cp1.x > pp.x && cp2.x < pp.x) && (pp.y < cp1.y && p1.y > cp1.y || pp.y > cp1.y && p1.y < cp1.y)) {
                        segments.add(cp1.y);
                    }
                    ++j;
                }
            }
            if (segments.size() > 0) {
                Collections.sort(segments);
                int y1 = Math.min(pp.y, p1.y);
                int y2 = Math.max(pp.y, p1.y);
                int y = y1;
                Iterator I = segments.iterator();
                while (I.hasNext()) {
                    int y0 = (Integer)I.next();
                    g.drawLine(pp.x, y, pp.x, y0 - 5);
                    if (y2 - y0 > 5) {
                        g.drawArc(pp.x - 5, y0 - 5, 10, 10, 90, 180);
                    } else {
                        g.drawLine(pp.x, y, pp.x, y2);
                    }
                    y = y0 + 5;
                }
                g.drawLine(pp.x, y, pp.x, y2);
            } else {
                g.drawLine(pp, p1);
            }
        } else {
            g.drawLine(pp, p1);
        }
    }

    private IFigure getRoot() {
        RoundedLinkFigure figure = this;
        while (figure.getParent() != null) {
            figure = figure.getParent();
        }
        return figure;
    }

    private int min0(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private void outlineRoundedShape(Graphics g) {
        ArrayList connections = this.bridgesEnabled ? this.collectConnections() : null;
        PointList ps = this.getPoints();
        int psCount = ps.size();
        if (psCount == 0) {
            return;
        }
        ZoomDrawer.setLineWidth((Graphics)g, (int)this.getLineWidth());
        Point pp = ps.getPoint(0);
        int i = 1;
        while (i < psCount) {
            Point p = ps.getPoint(i);
            Point ppo = ps.getPoint(i - 1);
            if (i == psCount - 1) {
                this.drawLine(g, pp, p, connections);
            } else {
                Point p1 = p.getCopy();
                Point p2 = p.getCopy();
                Point pn = ps.getPoint(i + 1).getCopy();
                int dx = this.min0(Math.abs(ppo.x - p.x), Math.abs(p.x - pn.x));
                int dy = this.min0(Math.abs(ppo.y - p.y), Math.abs(p.y - pn.y));
                int d = this.min0(dx, dy);
                int r = Math.min(this.radius, d / 2);
                int r2 = 2 * r;
                if (pp.y == p.y && p.x == pn.x && r2 != 0) {
                    if (pp.x < p.x && p.y < pn.y) {
                        p1.x -= r;
                        p2.y += r;
                        g.drawArc(p.x - r2, p.y, r2, r2, 0, 90);
                    } else if (pp.x > p.x && p.y < pn.y) {
                        p1.x += r;
                        p2.y += r;
                        g.drawArc(p.x, p.y, r2, r2, 90, 90);
                    } else if (pp.x < p.x && p.y > pn.y) {
                        p1.x -= r;
                        p2.y -= r;
                        g.drawArc(p.x - r2, p.y - r2, r2, r2, 270, 90);
                    } else if (pp.x > p.x && p.y > pn.y) {
                        p1.x += r;
                        p2.y -= r;
                        g.drawArc(p.x, p.y - r2, r2, r2, 180, 90);
                    }
                }
                if (pp.x == p.x && p.y == pn.y && r2 != 0) {
                    if (pp.y < p.y && p.x < pn.x) {
                        p1.y -= r;
                        p2.x += r;
                        g.drawArc(p.x, p.y - r2, r2, r2, 180, 90);
                    } else if (pp.y < p.y && p.x > pn.x) {
                        p1.y -= r;
                        p2.x -= r;
                        g.drawArc(p.x - r2, p.y - r2, r2, r2, 270, 90);
                    } else if (pp.y > p.y && p.x < pn.x) {
                        p1.y += r;
                        p2.x += r;
                        g.drawArc(p.x, p.y, r2, r2, 90, 90);
                    } else if (pp.y > p.y && p.x > pn.x) {
                        p1.y += r;
                        p2.x -= r;
                        g.drawArc(p.x - r2, p.y, r2, r2, 0, 90);
                    }
                }
                this.drawLine(g, pp, p1, connections);
                pp = p2;
            }
            ++i;
        }
    }

    private void outlineStraightShape(Graphics g) {
        ArrayList connections = this.bridgesEnabled ? this.collectConnections() : null;
        PointList ps = this.getPoints();
        int psCount = ps.size();
        if (psCount == 0) {
            return;
        }
        ZoomDrawer.setLineWidth((Graphics)g, (int)this.getLineWidth());
        Point pp = ps.getPoint(0);
        int i = 1;
        while (i < psCount) {
            Point p = ps.getPoint(i);
            this.drawLine(g, pp, p, connections);
            pp = p;
            ++i;
        }
    }
}

