/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import com.modeliosoft.modelio.diagram.elements.core.figures.IShaper;
import com.modeliosoft.modelio.diagram.elements.core.figures.ShapedFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.borders.ShapedBorder;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Color;

public class ShapedBorderedFigure
extends ShapedFigure {
    private ShapedBorder shapedBorder;
    private static final int MARGIN = 2;

    public ShapedBorderedFigure(IShaper aShaper) {
        super(aShaper);
        this.setSize(30, 40);
        this.setOpaque(true);
        this.setShaper(aShaper);
    }

    public void setLineColor(Color lineColor) {
        if (lineColor != this.penOptions.lineColor) {
            super.setLineColor(lineColor);
            this.shapedBorder.setColor(lineColor);
        }
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth != this.penOptions.lineWidth) {
            super.setLineWidth(lineWidth);
            this.shapedBorder.setWidth(lineWidth);
        }
    }

    public void setShaper(IShaper value) {
        super.setShaper(value);
        this.updateBorder();
    }

    protected void updateBorder() {
        this.shapedBorder = new ShapedBorder(this.penOptions.lineColor, this.penOptions.lineWidth, this.shaper);
        this.shapedBorder.setStyle(this.getLinePattern().toSWTConstant());
        this.setBorder((Border)new CompoundBorder((Border)this.shapedBorder, (Border)new MarginBorder(2)));
    }

    public void setLinePattern(StyleKey.LinePattern lineStyle) {
        if (lineStyle != this.penOptions.linePattern) {
            super.setLinePattern(lineStyle);
            this.shapedBorder.setStyle(lineStyle.toSWTConstant());
        }
    }
}

