/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ToolbarLayoutWithGrab
extends ToolbarLayout {
    public ToolbarLayoutWithGrab() {
    }

    public ToolbarLayoutWithGrab(boolean isHorizontal) {
        super(isHorizontal);
    }

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(this.getChildPreferredSize(child, wHint, hHint));
            minSizes[i] = this.transposer.t(this.getChildMinimumSize(child, wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.spacing) - (totalMinHeight += (numChildren - 1) * this.spacing);
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        if (amntShrinkHeight < 0) {
            amntShrinkHeight = 0;
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int width = Math.min(prefWidth, this.transposer.t((Dimension)child.getMaximumSize()).width);
            width = this.matchWidth ? clientArea.width : Math.max(minWidth, Math.min(clientArea.width, width));
            newBounds.width = width;
            newBounds.height -= amntShrinkCurrentHeight;
            if (i2 == numChildren - 1) {
                newBounds.height = clientArea.bottom() - newBounds.y;
            }
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }

    @Deprecated
    private void layout0(IFigure parent) {
        super.layout(parent);
        List children = parent.getChildren();
        if (children.isEmpty()) {
            return;
        }
        if (this.matchWidth) {
            Rectangle clientArea = this.transposer.t(parent.getClientArea());
            for (IFigure child : children) {
                Rectangle bounds = this.transposer.t(child.getBounds());
                bounds.width = clientArea.width;
                child.setBounds(this.transposer.t(bounds));
            }
        }
        IFigure lastChild = (IFigure)children.get(children.size() - 1);
        Rectangle childBounds = lastChild.getBounds().getCopy();
        Rectangle area = parent.getClientArea();
        int remainingW = area.right() - childBounds.right();
        int remainingH = area.bottom() - childBounds.bottom();
        if (remainingW > 0) {
            childBounds.resize(remainingW, 0);
        }
        if (remainingH > 0) {
            childBounds.resize(0, remainingH);
        }
        if (remainingW > 0 || remainingH > 0) {
            lastChild.setBounds(childBounds);
        }
    }
}

