/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.anchors;

import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class BorderAnchor
extends AbstractConnectionAnchor {
    private int border;
    private int offset;

    public BorderAnchor(IFigure owner, int border, int offset) {
        super(owner);
        this.border = border;
        this.offset = offset;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public Point getLocation(Point reference) {
        return this.getReferencePoint();
    }

    public Point getReferencePoint() {
        Point ret;
        Rectangle rect = this.getOwner().getBounds().getCopy();
        Dimension tmpOffset = Dimension.SINGLETON;
        tmpOffset.width = this.offset;
        this.getOwner().translateToAbsolute((Translatable)rect);
        this.getOwner().translateToAbsolute((Translatable)tmpOffset);
        int absOffset = tmpOffset.width;
        switch (this.border) {
            case 1: {
                if (absOffset > rect.width) {
                    absOffset = rect.width;
                }
                ret = rect.getTopLeft().translate(absOffset, 0);
                break;
            }
            case 4: {
                if (absOffset > rect.width) {
                    absOffset = rect.width;
                }
                ret = rect.getBottomLeft().translate(absOffset, 0);
                break;
            }
            case 16: {
                if (absOffset > rect.height) {
                    absOffset = rect.height;
                }
                ret = rect.getTopRight().translate(0, absOffset);
                break;
            }
            case 8: {
                if (absOffset > rect.height) {
                    absOffset = rect.height;
                }
                ret = rect.getTopLeft().translate(0, absOffset);
                break;
            }
            default: {
                throw new IllegalStateException("Unknow border:" + this.border);
            }
        }
        return ret;
    }

    public int getBorder() {
        return this.border;
    }

    public int getOffset() {
        return this.offset;
    }
}

