/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.anchors;

import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.ISlidableAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.LineSeg;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.PrecisionPointList;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

/*
 * Exception performing whole class analysis ignored.
 */
public class LinearSlidableAnchor
extends AbstractConnectionAnchor
implements ISlidableAnchor {
    private PrecisionPoint relativeReference;
    private static int STRAIGHT_LINE_TOLERANCE = 3;

    private static PrecisionPoint getAnchorRelativeLocation(Point p, Rectangle bounds) {
        PrecisionPoint relLocation;
        if (bounds.width == 0 || bounds.height == 0) {
            return new PrecisionPoint(0.5, 0.5);
        }
        PrecisionPoint temp = new PrecisionPoint(p);
        if (p.x < bounds.x || p.x > bounds.x + bounds.width || p.y < bounds.y || p.y > bounds.y + bounds.height) {
            if (p.x < bounds.x || p.x > bounds.x + bounds.width) {
                temp.preciseX = p.x < bounds.x ? bounds.x : bounds.x + bounds.width;
            }
            if (p.y < bounds.y || p.y > bounds.y + bounds.height) {
                temp.preciseY = p.y < bounds.y ? bounds.y : bounds.y + bounds.height;
            }
            relLocation = new PrecisionPoint((temp.preciseX - (double)bounds.x) / (double)bounds.width, (temp.preciseY - (double)bounds.y) / (double)bounds.height);
        } else {
            relLocation = new PrecisionPoint((temp.preciseX - (double)bounds.x) / (double)bounds.width, (temp.preciseY - (double)bounds.y) / (double)bounds.height);
        }
        return relLocation;
    }

    private static Point pickClosestPoint(PointList points, Point p) {
        Point result = null;
        if (points.size() != 0) {
            result = points.getFirstPoint();
            int i = 1;
            while (i < points.size()) {
                Point temp = points.getPoint(i);
                if (Math.abs(temp.x - p.x) < Math.abs(result.x - p.x)) {
                    result = temp;
                } else if (Math.abs(temp.y - p.y) < Math.abs(result.y - p.y)) {
                    result = temp;
                }
                ++i;
            }
        }
        return result;
    }

    public LinearSlidableAnchor() {
    }

    public LinearSlidableAnchor(IFigure f) {
        super(f);
    }

    public LinearSlidableAnchor(IFigure f, PrecisionPoint p) {
        super(f);
        this.relativeReference = new PrecisionPoint(p.preciseX, p.preciseY);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LinearSlidableAnchor) {
            LinearSlidableAnchor anchor = (LinearSlidableAnchor)obj;
            if (this.getOwner() == anchor.getOwner()) {
                if (this.isDefaultAnchor()) {
                    return anchor.isDefaultAnchor();
                }
                return this.relativeReference.equals((Object)anchor.relativeReference);
            }
        }
        return false;
    }

    public Point getLocation(Point orthoReference) {
        PrecisionPoint ownReference = new PrecisionPoint(this.getReferencePoint());
        PrecisionRectangle bounds = new PrecisionRectangle(this.getOwner().getBounds());
        this.getOwner().translateToAbsolute((Translatable)bounds);
        bounds.expand(1.0E-6, 1.0E-6);
        PrecisionPoint preciseOrthoReference = new PrecisionPoint(orthoReference);
        int orientation = 0;
        if (preciseOrthoReference.preciseX >= bounds.preciseX && preciseOrthoReference.preciseX <= bounds.preciseX + bounds.preciseWidth) {
            ownReference.preciseX = preciseOrthoReference.preciseX;
            orientation = 128;
        } else if (preciseOrthoReference.preciseY >= bounds.preciseY && preciseOrthoReference.preciseY <= bounds.preciseY + bounds.preciseHeight) {
            ownReference.preciseY = preciseOrthoReference.preciseY;
            orientation = 64;
        }
        ownReference.updateInts();
        Point location = this.getLocation((Point)ownReference, (Point)preciseOrthoReference);
        if (location == null) {
            location = this.getDefaultLocation(orthoReference);
            orientation = 0;
        }
        if (orientation != 0) {
            PrecisionPoint loc = new PrecisionPoint(location);
            if (orientation == 128) {
                loc.preciseX = preciseOrthoReference.preciseX;
            } else {
                loc.preciseY = preciseOrthoReference.preciseY;
            }
            loc.updateInts();
            location = loc;
        }
        return location;
    }

    public Point getReferencePoint() {
        return this.getAnchorPosition();
    }

    public int hashCode() {
        int figureHashCode;
        int n = figureHashCode = this.getOwner() != null ? this.getOwner().hashCode() : 0;
        if (this.relativeReference == null) {
            return figureHashCode;
        }
        return new Double(this.relativeReference.preciseX()).hashCode() ^ new Double(this.relativeReference.preciseY()).hashCode() ^ figureHashCode;
    }

    public boolean isDefaultAnchor() {
        return this.relativeReference == null;
    }

    protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
        PointList polygon = this.getPolygonPoints();
        return new LineSeg(ownReference, foreignReference).getLineIntersectionsWithLineSegs(polygon);
    }

    protected Point getLocation(Point ownReference, Point foreignReference) {
        PointList intersections = this.getIntersectionPoints(ownReference, foreignReference);
        if (intersections != null && intersections.size() != 0) {
            Point location = LinearSlidableAnchor.pickClosestPoint((PointList)intersections, (Point)foreignReference);
            return location;
        }
        return null;
    }

    protected PointList getPolygonPoints() {
        PrecisionRectangle r = new PrecisionRectangle(this.getBox());
        PrecisionPointList ptList = new PrecisionPointList(5);
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX + r.preciseWidth, r.preciseY));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX + r.preciseWidth, r.preciseY + r.preciseHeight));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY + r.preciseHeight));
        ptList.addPoint((Point)new PrecisionPoint(r.preciseX, r.preciseY));
        return ptList;
    }

    protected Point normalizeToStraightlineTolerance(Point foreignReference, Point ownReference, int tolerance) {
        PrecisionPoint preciseOwnReference = new PrecisionPoint(ownReference);
        PrecisionPoint normalizedReference = (PrecisionPoint)preciseOwnReference.getCopy();
        PrecisionPoint preciseForeignReference = new PrecisionPoint(foreignReference);
        if (Math.abs(preciseForeignReference.preciseX - preciseOwnReference.preciseX) < (double)tolerance) {
            normalizedReference.preciseX = preciseForeignReference.preciseX;
            normalizedReference.updateInts();
            return normalizedReference;
        }
        if (Math.abs(preciseForeignReference.preciseY - preciseOwnReference.preciseY) < (double)tolerance) {
            normalizedReference.preciseY = preciseForeignReference.preciseY;
            normalizedReference.updateInts();
        }
        return normalizedReference;
    }

    private Point getAnchorPosition() {
        PrecisionRectangle rBox = new PrecisionRectangle(this.getBox());
        if (this.isDefaultAnchor()) {
            return rBox.getCenter();
        }
        return new PrecisionPoint(this.relativeReference.preciseX * rBox.preciseWidth + rBox.preciseX, this.relativeReference.preciseY * rBox.preciseHeight + rBox.preciseY);
    }

    private Rectangle getBox() {
        Rectangle rBox = this.getOwner() instanceof Connection ? ((Connection)this.getOwner()).getPoints().getBounds() : this.getOwner().getBounds();
        PrecisionRectangle box = new PrecisionRectangle(rBox);
        this.getOwner().translateToAbsolute((Translatable)box);
        return box;
    }

    private Point getDefaultLocation(Point reference) {
        Point ownReference = this.normalizeToStraightlineTolerance(reference, this.getReferencePoint(), STRAIGHT_LINE_TOLERANCE);
        Point location = this.getLocation(ownReference, reference);
        if (location == null && (location = this.getLocation((Point)new PrecisionPoint(this.getBox().getCenter()), reference)) == null) {
            location = this.getBox().getCenter();
        }
        return location;
    }

    public void setLocation(Point newlocation) {
        Rectangle bounds = this.getBox();
        double w = newlocation.x - bounds.x;
        double h = newlocation.y - bounds.y;
        this.relativeReference = new PrecisionPoint(w / (double)bounds.width, h / (double)bounds.height);
    }
}

