/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.anchors;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.GeomUtils;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class NodeAnchor
extends AbstractConnectionAnchor {
    private Dimension anchorOffset;
    private static Rectangle A_RECTANGLE = new Rectangle();
    private static Point A_POINT = new Point();

    public NodeAnchor(IFigure owner, Dimension anchorLocation) {
        super(owner);
        this.anchorOffset = new Dimension(anchorLocation);
    }

    public Point getLocation(Point reference) {
        Point anchor = A_POINT;
        this.getReferencePoint(anchor);
        Rectangle r = A_RECTANGLE;
        r.setBounds(this.getOwner().getBounds());
        r.expand(1, 1);
        this.getOwner().translateToAbsolute((Translatable)r);
        if (r.isEmpty()) {
            return r.getLocation();
        }
        if (reference.x == anchor.x && reference.y == anchor.y) {
            return new Point(anchor);
        }
        Point ret = GeomUtils.getLineIntersection((Point)anchor, (Point)reference, (Rectangle)r);
        if (ret == null) {
            ret = r.getLocation();
        }
        return ret;
    }

    public Dimension getOffset() {
        return this.anchorOffset;
    }

    public Point getReferencePoint() {
        Point ret = new Point();
        this.getReferencePoint(ret);
        return ret;
    }

    public void setReference(Dimension d) {
        this.anchorOffset.setSize(d);
        this.fireAnchorMoved();
    }

    protected void fixPointInto(Point p, Rectangle r) {
        p.x = Math.max(p.x, r.x);
        p.x = Math.min(p.x, r.right());
        p.y = Math.max(p.y, r.y);
        p.y = Math.min(p.y, r.bottom());
    }

    private void getReferencePoint(Point refPoint) {
        Rectangle bounds = this.getOwner().getBounds();
        refPoint.setLocation(bounds.x(), bounds.y());
        refPoint.translate(this.anchorOffset);
        this.fixPointInto(refPoint, bounds.getExpanded(-1, -1));
        this.getOwner().translateToAbsolute((Translatable)refPoint);
    }
}

