/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.geometry;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Direction;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.LineSeg;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Orientation;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeomUtils {
    public static Direction getDirection(Point p, Rectangle rect) {
        Point center = rect.getCenter();
        if (p.x == center.x) {
            if (p.y == center.y) {
                return Direction.NONE;
            }
            if (p.y >= center.y) {
                return Direction.SOUTH;
            }
            return Direction.NORTH;
        }
        Point upright = rect.getTopRight();
        double a = (double)(center.y - upright.y) / (double)(upright.x - center.x);
        double b = (double)(center.y - p.y) / (double)(p.x - center.x);
        if (-a < b && b < a) {
            if (p.x == center.x) {
                return Direction.NONE;
            }
            if (p.x >= center.x) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        if (p.y == center.y) {
            return Direction.NONE;
        }
        if (p.y >= center.y) {
            return Direction.SOUTH;
        }
        return Direction.NORTH;
    }

    public static Point getLineIntersection(Point p1, Point p2, Rectangle r) {
        if (r.isEmpty()) {
            return null;
        }
        ArrayList<Point> pts = new ArrayList<Point>(4);
        pts.add(GeomUtils.getLineIntersection((Point)p1, (Point)p2, (LineSeg)new LineSeg(r.getTopLeft(), r.getTopRight())));
        pts.add(GeomUtils.getLineIntersection((Point)p1, (Point)p2, (LineSeg)new LineSeg(r.getTopLeft(), r.getBottomLeft())));
        pts.add(GeomUtils.getLineIntersection((Point)p1, (Point)p2, (LineSeg)new LineSeg(r.getTopRight(), r.getBottomRight())));
        pts.add(GeomUtils.getLineIntersection((Point)p1, (Point)p2, (LineSeg)new LineSeg(r.getBottomLeft(), r.getBottomRight())));
        return GeomUtils.getNearestPoint(pts, (Point)p2);
    }

    public static Point getNearestPoint(Point origin, Point destination, Point p) {
        if (p.getDistance(origin) < p.getDistance(destination)) {
            return origin;
        }
        return destination;
    }

    public static Point getNearestPoint(Collection<Point> candidates, Point ref) {
        Point ret = null;
        int min = -1;
        for (Point p : candidates) {
            if (p == null) continue;
            int dist = ref.getDistance2(p);
            if (ret != null && dist >= min) continue;
            min = dist;
            ret = p;
        }
        return ret;
    }

    public static Point getSegmentIntersection(Point p1, Point p2, Rectangle r) {
        if (r.isEmpty()) {
            return null;
        }
        ArrayList<Point> pts = new ArrayList<Point>(4);
        pts.add(GeomUtils.getSegmentsIntersection((Point)p1, (Point)p2, (Point)r.getTopLeft(), (Point)r.getTopRight()));
        pts.add(GeomUtils.getSegmentsIntersection((Point)p1, (Point)p2, (Point)r.getTopLeft(), (Point)r.getBottomLeft()));
        pts.add(GeomUtils.getSegmentsIntersection((Point)p1, (Point)p2, (Point)r.getTopRight(), (Point)r.getBottomRight()));
        pts.add(GeomUtils.getSegmentsIntersection((Point)p1, (Point)p2, (Point)r.getBottomLeft(), (Point)r.getBottomRight()));
        return GeomUtils.getNearestPoint(pts, (Point)p2);
    }

    private static boolean areSameSign(long a, long b) {
        return (a ^ b) >= 0L;
    }

    private static Point getLineIntersection(Point p1, Point p2, LineSeg segment) {
        LineSeg s1 = new LineSeg(p1, p2);
        PointList intersections = s1.getLinesIntersections(segment);
        if (intersections != null && intersections.size() > 0 && segment.containsPoint(intersections.getFirstPoint(), 0)) {
            return intersections.getFirstPoint();
        }
        return null;
    }

    private static Point getSegmentsIntersection(Point p1, Point p2, Point p3, Point p4) {
        long a1 = p2.y - p1.y;
        long b1 = p1.x - p2.x;
        long c1 = p2.x * p1.y - p1.x * p2.y;
        long r3 = a1 * (long)p3.x + b1 * (long)p3.y + c1;
        long r4 = a1 * (long)p4.x + b1 * (long)p4.y + c1;
        if (r3 != 0L && r4 != 0L && GeomUtils.areSameSign((long)r3, (long)r4)) {
            return null;
        }
        long a2 = p4.y - p3.y;
        long b2 = p3.x - p4.x;
        long c2 = p4.x * p3.y - p3.x * p4.y;
        long r1 = a2 * (long)p1.x + b2 * (long)p1.y + c2;
        long r2 = a2 * (long)p2.x + b2 * (long)p2.y + c2;
        if (r1 != 0L && r2 != 0L && GeomUtils.areSameSign((long)r1, (long)r2)) {
            return null;
        }
        long denom = a1 * b2 - a2 * b1;
        if (denom == 0L) {
            return null;
        }
        long offset = denom < 0L ? -denom / 2L : denom / 2L;
        Point ret = new Point();
        long num = b1 * c2 - b2 * c1;
        ret.x = (int)((num < 0L ? num - offset : num + offset) / denom);
        num = a2 * c1 - a1 * c2;
        ret.y = (int)((num < 0L ? num - offset : num + offset) / denom);
        return ret;
    }

    public static Orientation getOrientation(Direction anchorRelativeLocation) {
        if (anchorRelativeLocation == Direction.EAST || anchorRelativeLocation == Direction.WEST) {
            return Orientation.HORIZONTAL;
        }
        if (anchorRelativeLocation == Direction.NORTH || anchorRelativeLocation == Direction.SOUTH) {
            return Orientation.VERTICAL;
        }
        return Orientation.NONE;
    }
}

