/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.geometry;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.LineSeg;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.PrecisionPointList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

/*
 * Exception performing whole class analysis ignored.
 */
public class LineSeg
implements Cloneable,
Serializable,
Translatable {
    private static final int DEFAULT_INTERSECTION_TOLERANCE = 1;
    private Point origin;
    private Point terminus;
    static final long serialVersionUID = 1L;
    private static final float BIGSLOPE = 9999.0f;

    public static double[] getLineEquation(double x1, double y1, double x2, double y2) {
        double[] equation = new double[3];
        int i = 0;
        while (i < 3) {
            equation[i] = 0.0;
            ++i;
        }
        if (x1 == x2 && y1 == y2) {
            return equation;
        }
        if (x1 == x2) {
            equation[0] = 1.0;
            equation[1] = 0.0;
            equation[2] = x1;
            return equation;
        }
        equation[0] = (y1 - y2) / (x2 - x1);
        equation[1] = 1.0;
        equation[2] = y2 + equation[0] * x2;
        return equation;
    }

    public LineSeg(Point ptStart, Point ptEnd) {
        this.origin = ptStart.getCopy();
        this.terminus = ptEnd.getCopy();
    }

    public LineSeg(KeyPoint start, int fromX, int fromY, float slope, long len, int xdir) {
        this.origin = new Point();
        this.terminus = new Point();
        double len_squared = start == KeyPoint.ORIGIN ? (double)((float)len * (float)len) : (double)len / 2.0 * (double)len / 2.0;
        double slope_squared = slope * slope;
        float dx_float = (float)Math.sqrt(len_squared / (slope_squared + 1.0));
        int dx = (int)((double)(dx_float *= (float)xdir) + 0.5);
        int dy = (int)((double)(slope * dx_float) + 0.5);
        if (start == KeyPoint.ORIGIN) {
            this.origin.x = fromX;
            this.origin.y = fromY;
        } else {
            this.origin.x = fromX - dx;
            this.origin.y = fromY - dy;
        }
        this.terminus.x = fromX + dx;
        this.terminus.y = fromY + dy;
    }

    public final boolean containsPoint(Point aPoint, int tolerance) {
        double lengthOfSegment = this.origin.getDistance(this.terminus);
        double lengthFromOriginToPoint = this.origin.getDistance(aPoint);
        double lengthFromTerminusToPoint = this.terminus.getDistance(aPoint);
        return lengthFromTerminusToPoint + lengthFromOriginToPoint - lengthOfSegment <= (double)tolerance;
    }

    public final float distanceAlong(Point coord) {
        int xCoord = coord.x;
        int yCoord = coord.y;
        long dirx = (long)this.terminus.x - (long)this.origin.x;
        long diry = (long)this.terminus.y - (long)this.origin.y;
        long qpx = (long)xCoord - (long)this.origin.x;
        long qpy = (long)yCoord - (long)this.origin.y;
        long dotprod = qpx * dirx + qpy * diry;
        if (dirx == 0L && diry == 0L) {
            return -1.0f;
        }
        return (float)dotprod / (float)(dirx * dirx + diry * diry);
    }

    public final long distanceToPoint(int xCoord, int yCoord) {
        long d2;
        double proj = this.projection(xCoord, yCoord);
        if (proj > 0.0 && proj < 1.0) {
            Point pt = this.perpIntersect(xCoord, yCoord);
            return Math.round(pt.getDistance(new Point(xCoord, yCoord)));
        }
        long d1 = Math.round(this.getOrigin().getDistance(new Point(xCoord, yCoord)));
        return d1 < (d2 = Math.round(this.getTerminus().getDistance(new Point(xCoord, yCoord)))) ? d1 : d2;
    }

    public boolean equals(Object seg) {
        if (!(seg instanceof LineSeg)) {
            return false;
        }
        LineSeg ls = (LineSeg)seg;
        return this.getOrigin().equals((Object)ls.getOrigin()) && this.getTerminus().equals((Object)ls.getTerminus());
    }

    public double[] getEquation() {
        PrecisionPoint preciseOrigin = new PrecisionPoint(this.origin);
        PrecisionPoint preciseTerminus = new PrecisionPoint(this.terminus);
        return LineSeg.getLineEquation((double)preciseOrigin.preciseX, (double)preciseOrigin.preciseY, (double)preciseTerminus.preciseX, (double)preciseTerminus.preciseY);
    }

    public final Point getInfimum() {
        return new Point(Math.min(this.origin.x, this.terminus.x), Math.min(this.origin.y, this.terminus.y));
    }

    public PointList getLineIntersectionsWithEllipse(Rectangle ellipseBounds) {
        PrecisionPointList intersections = new PrecisionPointList();
        PrecisionPoint preciseOrigin = new PrecisionPoint(this.origin);
        PrecisionPoint preciseTerminus = new PrecisionPoint(this.terminus);
        PrecisionRectangle preciseEllipseBounds = new PrecisionRectangle(ellipseBounds);
        if (preciseEllipseBounds.preciseWidth == 0.0 || preciseEllipseBounds.preciseHeight == 0.0) {
            return intersections;
        }
        PrecisionPoint ellipsePreciseCenter = new PrecisionPoint(preciseEllipseBounds.getCenter());
        double xl1 = preciseOrigin.preciseX - ellipsePreciseCenter.preciseX;
        double yl1 = preciseOrigin.preciseY - ellipsePreciseCenter.preciseY;
        double xl2 = preciseTerminus.preciseX - ellipsePreciseCenter.preciseX;
        double yl2 = preciseTerminus.preciseY - ellipsePreciseCenter.preciseY;
        double[] equation = LineSeg.getLineEquation((double)xl1, (double)yl1, (double)xl2, (double)yl2);
        if (equation.length < 3 || equation[0] == 0.0 && equation[1] == 0.0) {
            return intersections;
        }
        double a = equation[0];
        double b = equation[1];
        double c = equation[2];
        double w = preciseEllipseBounds.preciseWidth;
        double h = preciseEllipseBounds.preciseHeight;
        if (b == 0.0) {
            double x = c / a;
            double y = Math.pow(h / 2.0, 2.0) - Math.pow(h * c / (a * w), 2.0);
            if (y < 0.0) {
                return intersections;
            }
            intersections.addPoint((Point)new PrecisionPoint(x + ellipsePreciseCenter.preciseX, Math.sqrt(y) + ellipsePreciseCenter.preciseY));
            intersections.addPoint((Point)new PrecisionPoint(x + ellipsePreciseCenter.preciseX, -Math.sqrt(y) + ellipsePreciseCenter.preciseY));
        } else {
            double xA = Math.pow(h, 2.0) + Math.pow(w * a / b, 2.0);
            double xB = -2.0 * Math.pow(w, 2.0) * a * c / Math.pow(b, 2.0);
            double xC = Math.pow(w * c / b, 2.0) - Math.pow(h * w / 2.0, 2.0);
            double xD = Math.pow(xB, 2.0) - 4.0 * xA * xC;
            if (xD < 0.0) {
                return intersections;
            }
            double x1 = (-xB + Math.sqrt(xD)) / (2.0 * xA);
            double x2 = (-xB - Math.sqrt(xD)) / (2.0 * xA);
            intersections.addPoint((Point)new PrecisionPoint(x1 + ellipsePreciseCenter.preciseX, (c - a * x1) / b + ellipsePreciseCenter.preciseY));
            intersections.addPoint((Point)new PrecisionPoint(x2 + ellipsePreciseCenter.preciseX, (c - a * x2) / b + ellipsePreciseCenter.preciseY));
        }
        return intersections;
    }

    public PointList getLineIntersectionsWithLineSegs(PointList points) {
        PrecisionPointList intersections = new PrecisionPointList();
        if (points.size() < 2) {
            if (this.containsPoint(points.getFirstPoint(), 1)) {
                intersections.addPoint(points.getFirstPoint());
            }
        } else {
            int i = 0;
            while (i < points.size() - 1) {
                LineSeg seg = new LineSeg(points.getPoint(i), points.getPoint(i + 1));
                PointList currentIntersections = this.getLinesIntersections(seg);
                int j = 0;
                while (j < currentIntersections.size()) {
                    Point intersection = currentIntersections.getPoint(j);
                    if (seg.containsPoint(intersection, 1)) {
                        intersections.addPoint(currentIntersections.getPoint(j));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return intersections;
    }

    public PointList getLinesIntersections(LineSeg line) {
        PrecisionPointList intersections = new PrecisionPointList();
        double[] temp = this.getEquation();
        double a1 = temp[0];
        double b1 = temp[1];
        double c1 = temp[2];
        temp = line.getEquation();
        double a2 = temp[0];
        double b2 = temp[1];
        double c2 = temp[2];
        double det = a1 * b2 - b1 * a2;
        if (det == 0.0) {
            if (a1 == a2 && b1 == b2 && c1 == c2) {
                ArrayList<Point> points = new ArrayList<Point>(4);
                points.add(this.getOrigin());
                points.add(this.getTerminus());
                points.add(line.getOrigin());
                points.add(line.getTerminus());
                Collections.sort(points, new /* Unavailable Anonymous Inner Class!! */);
                intersections.addPoint((Point)points.get(1));
                intersections.addPoint((Point)points.get(2));
            }
        } else {
            intersections.addPoint((Point)new PrecisionPoint((c1 * b2 - b1 * c2) / det, (a1 * c2 - c1 * a2) / det));
        }
        return intersections;
    }

    public Point getOrigin() {
        return this.origin.getCopy();
    }

    public final LineSeg getParallelLineSegThroughPoint(Point ptLoc) {
        if (this.isHorizontal()) {
            return new LineSeg(new Point(this.getOrigin().x, ptLoc.y), new Point(this.getTerminus().x, ptLoc.y));
        }
        if (this.isVertical()) {
            return new LineSeg(new Point(ptLoc.x, this.getOrigin().y), new Point(ptLoc.x, this.getTerminus().y));
        }
        Point ptProj = this.perpIntersect(ptLoc.x, ptLoc.y);
        long nHeight = Math.round(ptProj.getDistance(ptLoc));
        Sign position = this.positionRelativeTo(ptLoc);
        return new LineSeg(this.locatePoint(0.0, nHeight, position), this.locatePoint(1.0, nHeight, position));
    }

    public final Point getSupremum() {
        return new Point(Math.max(this.origin.x, this.terminus.x), Math.max(this.origin.y, this.terminus.y));
    }

    public Point getTerminus() {
        return this.terminus.getCopy();
    }

    public TrigValues getTrigValues(Ray ptToVector) {
        double dFromLength = this.length();
        double dToLength = ptToVector.length();
        Ray ptFromVector = new Ray(this.getOrigin(), this.getTerminus());
        if (dFromLength <= 0.0 || dToLength <= 0.0) {
            return null;
        }
        double dCosAlpha = (double)ptFromVector.x / dFromLength;
        double dSinAlpha = (double)ptFromVector.y / dFromLength;
        double dAlpha = Math.atan2(dSinAlpha, dCosAlpha);
        dCosAlpha = Math.cos(-dAlpha);
        dSinAlpha = Math.sin(-dAlpha);
        double dRotateX = (double)ptToVector.x * dCosAlpha - (double)ptToVector.y * dSinAlpha;
        double dRotateY = (double)ptToVector.x * dSinAlpha + (double)ptToVector.y * dCosAlpha;
        TrigValues val = new TrigValues();
        val.cosTheta = dRotateX / dToLength;
        val.sinTheta = dRotateY / dToLength;
        return val;
    }

    public int hashCode() {
        return this.getOrigin().hashCode() ^ this.getTerminus().hashCode();
    }

    public Point intersect(LineSeg line, int nTolerance) {
        PointList intersections = this.getLinesIntersections(line);
        if (intersections.size() > 1) {
            intersections.addPoint(this.getOrigin().getCopy());
            intersections.addPoint(this.getTerminus().getCopy());
        }
        int i = 0;
        while (i < intersections.size()) {
            Point result = intersections.getPoint(i).getCopy();
            if (this.containsPoint(result, nTolerance) && line.containsPoint(result, nTolerance)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public final boolean isHorizontal() {
        return this.origin.y == this.terminus.y;
    }

    public final boolean isVertical() {
        return this.origin.x == this.terminus.x;
    }

    public final double length() {
        return this.getOrigin().getDistance(this.getTerminus());
    }

    public final Point locatePoint(double pctDist, long theHeight, Sign asOriented) {
        int dist = (int)(pctDist * this.length());
        Point pt = new Point();
        this.pointOn((long)dist, KeyPoint.ORIGIN, pt);
        int xdir = this.getOrigin().y > this.getTerminus().y || this.getOrigin().y == this.getTerminus().y && this.getOrigin().x < this.getTerminus().x ? (asOriented == Sign.POSITIVE ? -1 : 1) : (asOriented == Sign.POSITIVE ? 1 : -1);
        LineSeg linesegAB = new LineSeg(KeyPoint.ORIGIN, pt.x, pt.y, this.perpSlope(), theHeight, xdir);
        return new Point(linesegAB.getTerminus().x, linesegAB.getTerminus().y);
    }

    public void performScale(double factor) {
        this.setOrigin(this.getOrigin().scale(factor));
        this.setTerminus(this.getTerminus().scale(factor));
    }

    public void performTranslate(int dx, int dy) {
        this.setOrigin(this.getOrigin().translate(dx, dy));
        this.setTerminus(this.getTerminus().translate(dx, dy));
    }

    public final Point perpIntersect(int startX, int startY) {
        Point ptResult = new Point();
        float m = this.slope();
        float fx = (m * (float)startY - m * (float)this.getOrigin().y + m * m * (float)this.getOrigin().x + (float)startX) / (float)((double)(m * m) + 1.0);
        ptResult.y = m == 0.0f ? this.getOrigin().y : (int)((double)((float)startY + ((float)startX - fx) / m) + 0.5);
        ptResult.x = Math.round(fx);
        return ptResult;
    }

    public final float perpSlope() {
        float m = this.slope();
        if ((double)m == 0.0) {
            return 9999.0f;
        }
        return -(1.0f / m);
    }

    public final boolean pointOn(long theDistance, KeyPoint fromKeyPoint, Point ptResult) {
        boolean in_line;
        int startX = 0;
        int startY = 0;
        int otherX = 0;
        int otherY = 0;
        if (fromKeyPoint == KeyPoint.ORIGIN) {
            startX = this.getOrigin().x;
            startY = this.getOrigin().y;
            otherX = this.getTerminus().x;
            otherY = this.getTerminus().y;
        } else if (fromKeyPoint == KeyPoint.TERMINUS) {
            startX = this.getTerminus().x;
            startY = this.getTerminus().y;
            otherX = this.getOrigin().x;
            otherY = this.getOrigin().y;
        } else if (fromKeyPoint == KeyPoint.MIDPOINT) {
            startX = (this.getOrigin().x + this.getTerminus().x) / 2;
            startY = (this.getOrigin().y + this.getTerminus().y) / 2;
            otherX = this.getTerminus().x;
            otherY = this.getTerminus().y;
        } else {
            return false;
        }
        float m = this.slope();
        double d_squared = (float)theDistance * (float)theDistance;
        double m_squared = m * m;
        float dx_float = (float)Math.sqrt(d_squared / (m_squared + 1.0));
        int dx = (int)((double)dx_float + 0.5);
        int dy = (int)(Math.sqrt(d_squared * m_squared / (m_squared + 1.0)) + 0.5);
        if (theDistance < 0L) {
            dx = -dx;
            dy = -dy;
        }
        ptResult.x = startX > otherX ? startX - dx : startX + dx;
        int n = ptResult.y = startY > otherY ? startY - dy : startY + dy;
        if (startX > otherX) {
            in_line = ptResult.x >= otherX;
        } else {
            boolean bl = in_line = ptResult.x <= otherX;
        }
        if (in_line) {
            in_line = startY > otherY ? ptResult.y >= otherY : ptResult.y <= otherY;
        }
        return in_line;
    }

    public final Sign positionRelativeTo(Point rel) {
        double dNewAngle;
        Ray ptRelRay = new Ray(this.getOrigin(), rel);
        TrigValues val = this.getTrigValues(ptRelRay);
        if (val != null && (dNewAngle = Math.atan2(-val.sinTheta, -val.cosTheta)) > 0.0) {
            return Sign.POSITIVE;
        }
        return Sign.NEGATIVE;
    }

    public final double projection(int xCoord, int yCoord) {
        long dirx = (long)this.getTerminus().x - (long)this.getOrigin().x;
        long diry = (long)this.getTerminus().y - (long)this.getOrigin().y;
        long qpx = (long)xCoord - (long)this.getOrigin().x;
        long qpy = (long)yCoord - (long)this.getOrigin().y;
        long dotprod = qpx * dirx + qpy * diry;
        if (dirx == 0L && diry == 0L) {
            return -1.0;
        }
        return (double)dotprod / (double)(dirx * dirx + diry * diry);
    }

    public void setOrigin(Point origin) {
        this.origin = origin.getCopy();
    }

    public void setTerminus(Point terminus) {
        this.terminus = terminus.getCopy();
    }

    public final float slope() {
        if (this.isVertical()) {
            return 9999.0f;
        }
        return (float)(this.terminus.y - this.origin.y) / (float)(this.terminus.x - this.origin.x);
    }
}

