/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.geometry;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.LineSeg;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.PointListUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;

/*
 * Exception performing whole class analysis ignored.
 */
public class PointListUtilities {
    static final int INTERSECT_TOLERANCE = 1;
    static final int MIN_LINE_LENGTH = 5;
    public static final int DEFAULT_BEZIERLINES = 16;
    static final int MAX_BEZIERLINES = 32;
    public static final int DEFAULT_CORNER_APPROXIMATION_PTS = 15;
    private static final int BIGDISTANCE = 32766;

    public static PointList calcRoundedCornersPolyline(PointList points, int r, Hashtable<Integer, Integer> rForBendpoint, boolean calculateAppoxPoints) {
        PointList newPoints = new PointList();
        int k = 1;
        while (k < points.size() - 1) {
            int x0 = points.getPoint((int)(k - 1)).x;
            int y0 = points.getPoint((int)(k - 1)).y;
            int x1 = points.getPoint((int)k).x;
            int y1 = points.getPoint((int)k).y;
            int x2 = points.getPoint((int)(k + 1)).x;
            int y2 = points.getPoint((int)(k + 1)).y;
            if (x0 == x1 && x1 == x2 || y0 == y1 && y1 == y2) {
                points.removePoint(k);
                continue;
            }
            ++k;
        }
        newPoints.addPoint(points.getFirstPoint());
        int rDefault = r;
        int i = 1;
        while (i < points.size() - 1) {
            int q;
            int p;
            int cornerCase;
            int x0 = points.getPoint((int)(i - 1)).x;
            int y0 = points.getPoint((int)(i - 1)).y;
            int x1 = points.getPoint((int)i).x;
            int y1 = points.getPoint((int)i).y;
            int x2 = points.getPoint((int)(i + 1)).x;
            int y2 = points.getPoint((int)(i + 1)).y;
            if (x0 == x1 && x2 > x1 && y0 < y1 && y2 == y1) {
                cornerCase = 1;
            } else if (x0 > x1 && x2 == x1 && y0 == y1 && y2 < y1) {
                cornerCase = 2;
            } else if (x0 < x1 && x2 == x1 && y0 == y1 && y2 < y1) {
                cornerCase = 3;
            } else if (x0 == x1 && x2 < x1 && y0 < y1 && y2 == y1) {
                cornerCase = 4;
            } else if (x0 > x1 && x2 == x1 && y0 == y1 && y2 > y1) {
                cornerCase = 5;
            } else if (x0 == x1 && x2 > x1 && y0 > y1 && y2 == y1) {
                cornerCase = 6;
            } else if (x0 == x1 && x2 < x1 && y0 > y1 && y2 == y1) {
                cornerCase = 7;
            } else if (x0 < x1 && x2 == x1 && y0 == y1 && y2 > y1) {
                cornerCase = 8;
            } else {
                return null;
            }
            r = rDefault;
            int distance = Math.min(points.getPoint(i - 1).getDistanceOrthogonal(points.getPoint(i)), points.getPoint(i).getDistanceOrthogonal(points.getPoint(i + 1)));
            if (r > distance / 2) {
                r = distance / 2 - 1;
                rForBendpoint.put(new Integer(i), new Integer(r));
            }
            int sign = 1;
            switch (cornerCase) {
                case 1: 
                case 2: {
                    p = x1 + r;
                    q = y1 - r;
                    break;
                }
                case 3: 
                case 4: {
                    p = x1 - r;
                    q = y1 - r;
                    break;
                }
                case 5: 
                case 6: {
                    p = x1 + r;
                    q = y1 + r;
                    sign = -1;
                    break;
                }
                default: {
                    p = x1 - r;
                    q = y1 + r;
                    sign = -1;
                }
            }
            Point lastPoint = null;
            switch (cornerCase) {
                case 1: 
                case 4: 
                case 6: 
                case 7: {
                    newPoints.addPoint(new Point(x1, q));
                    lastPoint = new Point(p, y1);
                    break;
                }
                default: {
                    newPoints.addPoint(new Point(p, y1));
                    lastPoint = new Point(x1, q);
                }
            }
            int incrementSign = 1;
            switch (cornerCase) {
                case 2: 
                case 4: 
                case 5: 
                case 7: {
                    incrementSign = -1;
                }
            }
            if (calculateAppoxPoints) {
                int x = newPoints.getLastPoint().x;
                int rSq = r * r;
                int increment = incrementSign * r / 15;
                int nrOfIncrement = 15;
                if (increment == 0) {
                    increment = incrementSign * 1;
                    nrOfIncrement = r;
                }
                int j = 1;
                while (j < nrOfIncrement) {
                    int y = (int)((double)q + (double)sign * Math.sqrt(rSq - ((x += increment) - p) * (x - p)));
                    newPoints.addPoint(new Point(x, y));
                    ++j;
                }
            }
            newPoints.addPoint(lastPoint);
            ++i;
        }
        newPoints.addPoint(points.getLastPoint());
        return newPoints;
    }

    public static final PointList calcSmoothPolyline(PointList points, int nSmoothFactor, int nBezierSteps) {
        PointList theBezierPoints = PointListUtilities.calcBezier((PointList)points, (int)nSmoothFactor, (int)0, (int)(points.size() - 1));
        return PointListUtilities.calcApproxPolylineFromBezier((PointList)theBezierPoints, (int)nBezierSteps);
    }

    public static PointList calcSmoothPolyline(PointList points, int nSmoothFactor, int nBezierSteps, int nStartIndex, int nEndIndex) {
        PointList theBezierPoints = PointListUtilities.calcBezier((PointList)points, (int)nSmoothFactor, (int)nStartIndex, (int)nEndIndex);
        return PointListUtilities.calcApproxPolylineFromBezier((PointList)theBezierPoints, (int)nBezierSteps);
    }

    public static Point calculatePointRelativeToLine(PointList pointList, int fromLine, int fromEnd, boolean isPercentage) {
        double fractionDistance = 0.0;
        fractionDistance = isPercentage ? (double)fromEnd / 100.0 : (double)fromEnd / (double)pointList.size();
        LocateInfo locateInfo = new LocateInfo(null);
        if (PointListUtilities.locateSegment((List)PointListUtilities.getLineSegments((PointList)pointList), (double)fractionDistance, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (LocateInfo)locateInfo)) {
            double inSegPercDist = 0.0;
            LineSeg seg = locateInfo.theSegment;
            if (seg != null) {
                if (seg.length() > 0.0) {
                    inSegPercDist = (double)locateInfo.remainingDist / seg.length();
                }
                Point location = seg.locatePoint(inSegPercDist, (long)Math.abs(fromLine), fromLine > 0 ? LineSeg.Sign.POSITIVE : LineSeg.Sign.NEGATIVE);
                return location;
            }
        }
        return null;
    }

    public static boolean containsPoint(PointList points, Point point) {
        boolean isOdd = false;
        int[] pointsxy = points.toIntArray();
        int n = pointsxy.length;
        if (n > 3) {
            int x0 = pointsxy[n - 2];
            int y0 = pointsxy[n - 1];
            int i = 0;
            while (i < n) {
                int x1 = pointsxy[i++];
                int y1 = pointsxy[i++];
                if (y0 <= point.y && point.y < y1 && PointListUtilities.crossProduct((int)x1, (int)y1, (int)x0, (int)y0, (int)point.x, (int)point.y) > 0) {
                    boolean bl = isOdd = !isOdd;
                }
                if (y1 <= point.y && point.y < y0 && PointListUtilities.crossProduct((int)x0, (int)y0, (int)x1, (int)y1, (int)point.x, (int)point.y) > 0) {
                    isOdd = !isOdd;
                }
                x0 = x1;
                y0 = y1;
            }
            if (isOdd) {
                return true;
            }
        }
        return false;
    }

    public static PointList copyPoints(PointList pointsFrom) {
        PointList points = new PointList(pointsFrom.size());
        PointListUtilities.copyFrom((PointList)points, (PointList)pointsFrom);
        return points;
    }

    public static PointList createPointsFromRect(Rectangle rBox) {
        PointList points = new PointList(5);
        Point pt = new Point(rBox.getLeft().x, rBox.getTop().y);
        points.addPoint(pt);
        pt = new Point(rBox.getRight().x, rBox.getTop().y);
        points.addPoint(pt);
        pt = new Point(rBox.getRight().x, rBox.getBottom().y);
        points.addPoint(pt);
        pt = new Point(rBox.getLeft().x, rBox.getBottom().y);
        points.addPoint(pt);
        pt = new Point(rBox.getLeft().x, rBox.getTop().y);
        points.addPoint(pt);
        return points;
    }

    public static boolean findIntersections(PointList points, PointList poly, PointList intersections, PointList distances) {
        List polySegments = PointListUtilities.getLineSegments((PointList)poly);
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        Point pLastIntersect = null;
        double dCurrentLength = 0.0;
        ListIterator segIter = mySegments.listIterator();
        while (segIter.hasNext()) {
            LineSeg pSegment = (LineSeg)segIter.next();
            double dSegLength = pSegment.length();
            ListIterator polyIter = polySegments.listIterator();
            while (polyIter.hasNext()) {
                LineSeg pPolySegment = (LineSeg)polyIter.next();
                Point ptIntersect = pSegment.intersect(pPolySegment, 1);
                if (ptIntersect == null) continue;
                boolean bAddIntersect = true;
                if (pLastIntersect != null && Math.abs(pLastIntersect.x - ptIntersect.x) < 2 && Math.abs(pLastIntersect.y - ptIntersect.y) < 2) {
                    bAddIntersect = false;
                }
                if (!bAddIntersect) continue;
                pLastIntersect = new Point(ptIntersect);
                intersections.addPoint(pLastIntersect);
                Point ptDistance = new Point(0, 0);
                ptDistance.x = (int)Math.round(dCurrentLength + (double)pSegment.distanceAlong(ptIntersect) * dSegLength);
                distances.addPoint(ptDistance);
            }
            dCurrentLength += dSegLength;
        }
        return intersections.size() > 0;
    }

    public static int findNearestLineSegIndexOfPoint(PointList points, Point ptCoord) {
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        ListIterator lineIter = mySegments.listIterator();
        int nNextIndex = 0;
        int nMinIndex = 0;
        long minDistance = 32766L;
        long nextDistance = 0L;
        while (lineIter.hasNext()) {
            LineSeg aSegment = (LineSeg)lineIter.next();
            ++nNextIndex;
            nextDistance = aSegment.distanceToPoint(ptCoord.x, ptCoord.y);
            if (nextDistance >= minDistance) continue;
            minDistance = nextDistance;
            nMinIndex = nNextIndex;
        }
        return nMinIndex;
    }

    public static List<LineSeg> getLineSegments(PointList points) {
        if (points.size() <= 1) {
            return new ArrayList<LineSeg>(0);
        }
        ArrayList<LineSeg> lines = new ArrayList<LineSeg>(points.size() - 1);
        int i = 0;
        while (i < points.size() - 1) {
            Point pt2;
            Point pt1 = points.getPoint(i);
            if (!pt1.equals((Object)(pt2 = points.getPoint(i + 1)))) {
                lines.add(new LineSeg(pt1, pt2));
            }
            ++i;
        }
        return lines;
    }

    public static LineSeg getNearestSegment(List<LineSeg> mySegments, int xCoord, int yCoord) {
        long minDistance = 32766L;
        long nextDistance = 0L;
        LineSeg closeSegment = null;
        LineSeg firstSegment = mySegments.isEmpty() ? null : mySegments.get(0);
        ListIterator<LineSeg> lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = lineIter.next();
            nextDistance = aSegment.distanceToPoint(xCoord, yCoord);
            if (nextDistance >= minDistance) continue;
            closeSegment = aSegment;
            minDistance = nextDistance;
        }
        if (closeSegment != null) {
            return closeSegment;
        }
        return firstSegment;
    }

    public static Point getPointsInfimum(PointList points) {
        Point theInfimum = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point other = points.getPoint(i);
            theInfimum = new Point(Math.min(theInfimum.x, other.x), Math.min(theInfimum.y, other.y));
            ++i;
        }
        return theInfimum;
    }

    public static long getPointsLength(PointList points) {
        List segs = PointListUtilities.getLineSegments((PointList)points);
        return PointListUtilities.length((List)segs);
    }

    public static Point getPointsSupremum(PointList points) {
        Point theSupremum = points.getFirstPoint();
        int i = 1;
        while (i < points.size()) {
            Point other = points.getPoint(i);
            theSupremum = new Point(Math.max(theSupremum.x, other.x), Math.max(theSupremum.y, other.y));
            ++i;
        }
        return theSupremum;
    }

    public static boolean normalizeSegments(PointList points) {
        return PointListUtilities.normalizeSegments((PointList)points, (int)0);
    }

    public static boolean normalizeSegments(PointList points, int straightLineTolerance) {
        boolean hasChanged = false;
        int i = 1;
        while (i < points.size() - 1) {
            double diffY;
            Point pt1 = points.getPoint(i);
            Point pt2 = points.getPoint(i - 1);
            double diffX = pt1.preciseX() - pt2.preciseX();
            double nextLength = Math.sqrt(diffX * diffX + (diffY = pt1.preciseY() - pt2.preciseY()) * diffY);
            if (nextLength <= (double)straightLineTolerance) {
                points.removePoint(i--);
                hasChanged = true;
            }
            ++i;
        }
        if (hasChanged |= PointListUtilities.flattenSegments((PointList)points, (int)straightLineTolerance)) {
            PointListUtilities.normalizeSegments((PointList)points, (int)straightLineTolerance);
        }
        return hasChanged;
    }

    public static Point pickClosestPoint(PointList points, Point p) {
        Point result = null;
        if (points.size() != 0) {
            result = points.getFirstPoint();
            int i = 1;
            while (i < points.size()) {
                Point temp = points.getPoint(i);
                if (Math.abs(temp.x - p.x) < Math.abs(result.x - p.x)) {
                    result = temp;
                } else if (Math.abs(temp.y - p.y) < Math.abs(result.y - p.y)) {
                    result = temp;
                }
                ++i;
            }
        }
        return result;
    }

    public static Point pickFarestPoint(PointList points, Point p) {
        Point result = null;
        if (points.size() != 0) {
            result = points.getFirstPoint();
            int i = 1;
            while (i < points.size()) {
                Point temp = points.getPoint(i);
                if (Math.abs(temp.x - p.x) > Math.abs(result.x - p.x)) {
                    result = temp;
                } else if (Math.abs(temp.y - p.y) > Math.abs(result.y - p.y)) {
                    result = temp;
                }
                ++i;
            }
        }
        return result;
    }

    public static Point pointOn(PointList points, long theDistance, LineSeg.KeyPoint fromKeyPoint, Point ptResult) {
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        return PointListUtilities.pointOn((List)mySegments, (long)theDistance, (LineSeg.KeyPoint)fromKeyPoint, (Point)ptResult);
    }

    public static PointList routeAroundPoint(PointList points, Point ptCenter, int nHeight, int nWidth, int nSmoothFactor, int nInclineOffset, boolean bTop) {
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        long nPolyLength = PointListUtilities.length((List)mySegments);
        long nCenterDistance = Math.round(PointListUtilities.distanceAlong((List)mySegments, (Point)ptCenter) * (double)nPolyLength);
        Point ptMidStart = new Point();
        PointListUtilities.pointOn((List)mySegments, (long)(nCenterDistance - (long)(nWidth / 2)), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)ptMidStart);
        Point ptMidEnd = new Point();
        PointListUtilities.pointOn((List)mySegments, (long)(nCenterDistance + (long)(nWidth / 2)), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)ptMidEnd);
        LineSeg lineNew = new LineSeg(ptMidStart, ptMidEnd);
        Point ptStart = new Point();
        lineNew.pointOn((long)nInclineOffset, LineSeg.KeyPoint.ORIGIN, ptStart);
        LocateInfo locateInfo = new LocateInfo(null);
        if (!PointListUtilities.locateSegment((List)mySegments, (double)((double)(nCenterDistance - (long)nWidth / 2L) / (double)nPolyLength), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (LocateInfo)locateInfo)) {
            return null;
        }
        LineSeg pStartSeg = locateInfo.theSegment;
        Point ptEnd = new Point();
        lineNew.pointOn((long)nInclineOffset, LineSeg.KeyPoint.TERMINUS, ptEnd);
        if (!PointListUtilities.locateSegment((List)mySegments, (double)((double)(nCenterDistance + (long)nWidth / 2L) / (double)nPolyLength), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (LocateInfo)locateInfo)) {
            return null;
        }
        LineSeg pEndSeg = locateInfo.theSegment;
        float fSlope = lineNew.slope();
        int nDir = 1;
        if (bTop && fSlope <= 0.0f || !bTop && fSlope > 0.0f) {
            nDir *= -1;
        }
        LineSeg lineStart = new LineSeg(LineSeg.KeyPoint.ORIGIN, ptStart.x, ptStart.y, lineNew.perpSlope(), (long)nHeight, nDir);
        LineSeg lineEnd = new LineSeg(LineSeg.KeyPoint.ORIGIN, ptEnd.x, ptEnd.y, lineNew.perpSlope(), (long)nHeight, nDir);
        PointList rRotatedBox = new PointList();
        rRotatedBox.addPoint(new Point(ptMidStart));
        rRotatedBox.addPoint(new Point(lineStart.getTerminus()));
        rRotatedBox.addPoint(new Point(lineEnd.getTerminus()));
        rRotatedBox.addPoint(new Point(ptMidEnd));
        rRotatedBox.addPoint(new Point(ptMidStart));
        PointList rPolyPoints = new PointList(rRotatedBox.size() * 32 + points.size());
        boolean bFoundStart = false;
        boolean bFoundEnd = false;
        int nPointsSinceStart = 0;
        List boxSegments = PointListUtilities.getLineSegments((PointList)rRotatedBox);
        ListIterator lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg pSegment = (LineSeg)lineIter.next();
            if (pSegment.equals((Object)pStartSeg)) {
                rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
                bFoundStart = true;
            }
            if (pSegment == pEndSeg) {
                PointList newRoutePoints = new PointList(rRotatedBox.size() * 32);
                LineSeg pCurSeg1 = (LineSeg)boxSegments.get(0);
                LineSeg pCurSeg2 = (LineSeg)boxSegments.get(boxSegments.size() - 1);
                PointListUtilities.getRoutedPoints((PointList)points, (PointList)newRoutePoints, (Point)ptMidStart, (Point)ptMidEnd, (Point)ptMidStart, (Point)ptMidEnd, (LineSeg)pCurSeg1, (LineSeg)pCurSeg2, (PointList)rRotatedBox, (int)nSmoothFactor, (boolean)false, (boolean)true, (int)0);
                while (nPointsSinceStart > 0) {
                    rPolyPoints.removePoint(rPolyPoints.size() - 1);
                    --nPointsSinceStart;
                }
                int i = 0;
                while (i < newRoutePoints.size()) {
                    rPolyPoints.addPoint(new Point(newRoutePoints.getPoint(i)));
                    ++i;
                }
                rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
                bFoundEnd = true;
                continue;
            }
            rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
            if (bFoundStart) {
                ++nPointsSinceStart;
            }
            if (lineIter.hasNext()) continue;
            rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
        }
        if (bFoundEnd) {
            return rPolyPoints;
        }
        return null;
    }

    public static PointList routeAroundPoly(PointList points, PointList poly, int nSmoothFactor, boolean bShortestDistance, boolean bIncludeIntersectionPoints, int nBuffer) {
        LineSeg pCurBoxSeg = null;
        Point ptIntersect = new Point();
        PointList rPolyPoints = new PointList(points.size() * 2);
        List rBoxSegments = PointListUtilities.getLineSegments((PointList)poly);
        Point ptIntersect1 = null;
        Point ptPrevIntersect = new Point(-100, -100);
        int nPointsSinceFirstIntersection = 0;
        int nCurrentLength1 = 0;
        int nCurrentLength = 0;
        List mySegments = PointListUtilities.getLineSegments((PointList)points);
        ListIterator listIter = mySegments.listIterator();
        while (listIter.hasNext()) {
            LineSeg pSegment = (LineSeg)listIter.next();
            boolean bFoundIntersects = false;
            ListIterator boxIter = rBoxSegments.listIterator();
            while (boxIter.hasNext()) {
                LineSeg pBoxSegment = (LineSeg)boxIter.next();
                ptIntersect = pSegment.intersect(pBoxSegment, 1);
                if (ptIntersect == null) continue;
                if (Math.abs(ptPrevIntersect.x - ptIntersect.x) > 2 || Math.abs(ptPrevIntersect.y - ptIntersect.y) > 2) {
                    if (ptIntersect1 != null) {
                        LineSeg pCurBoxSeg2;
                        Point ptIntersect2 = null;
                        PointList newRoutePoints = new PointList();
                        int nCurrentLength2 = nCurrentLength + (int)((double)pSegment.distanceAlong(ptIntersect) * pSegment.length());
                        if (nCurrentLength1 < nCurrentLength2) {
                            ptIntersect2 = new Point(ptIntersect);
                            pCurBoxSeg2 = pBoxSegment;
                        } else {
                            ptIntersect2 = new Point(ptIntersect1);
                            pCurBoxSeg2 = pCurBoxSeg;
                            ptIntersect1 = new Point(ptIntersect);
                            pCurBoxSeg = pBoxSegment;
                        }
                        PointListUtilities.getRoutedPoints((PointList)points, (PointList)newRoutePoints, (Point)ptIntersect1, (Point)ptIntersect2, (Point)rPolyPoints.getLastPoint(), (Point)pSegment.getTerminus(), (LineSeg)pCurBoxSeg, (LineSeg)pCurBoxSeg2, (PointList)poly, (int)nSmoothFactor, (boolean)bShortestDistance, (boolean)bIncludeIntersectionPoints, (int)nBuffer);
                        while (nPointsSinceFirstIntersection > 0) {
                            rPolyPoints.removePoint(rPolyPoints.size() - 1);
                            --nPointsSinceFirstIntersection;
                        }
                        int i = 0;
                        while (i < newRoutePoints.size()) {
                            rPolyPoints.addPoint(newRoutePoints.getPoint(i));
                            ++i;
                        }
                        rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
                        ptIntersect1 = null;
                        bFoundIntersects = true;
                        break;
                    }
                    ptIntersect1 = new Point(ptIntersect);
                    pCurBoxSeg = pBoxSegment;
                    rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
                    nPointsSinceFirstIntersection = 0;
                    nCurrentLength1 = nCurrentLength + (int)((double)pSegment.distanceAlong(ptIntersect) * pSegment.length());
                }
                ptPrevIntersect = new Point(ptIntersect);
            }
            nCurrentLength = (int)((double)nCurrentLength + pSegment.length());
            if (bFoundIntersects) continue;
            rPolyPoints.addPoint(new Point(pSegment.getOrigin()));
            if (ptIntersect1 != null) {
                ++nPointsSinceFirstIntersection;
            }
            if (listIter.hasNext()) continue;
            rPolyPoints.addPoint(new Point(pSegment.getTerminus()));
        }
        if (points.size() != rPolyPoints.size()) {
            return rPolyPoints;
        }
        return null;
    }

    public static PointList routeAroundRect(PointList points, Rectangle rBox, int nSmoothFactor, boolean bIncludeIntersectionPoints, int nBuffer) {
        Point infimumPoint = PointListUtilities.getPointsInfimum((PointList)points);
        Point supremumPoint = PointListUtilities.getPointsSupremum((PointList)points);
        Ray diameter = new Ray(infimumPoint, supremumPoint);
        Rectangle rPoly = new Rectangle(infimumPoint.x, infimumPoint.y, diameter.x, diameter.y);
        rPoly.expand(1, 1);
        if (rPoly.intersects(rBox)) {
            PointList rBoxPoly = PointListUtilities.createPointsFromRect((Rectangle)rBox);
            Point firstPoint = points.getFirstPoint();
            Point lastPoint = points.getLastPoint();
            boolean bFPContained = rBox.contains(firstPoint);
            boolean bLPContained = rBox.contains(lastPoint);
            if (bFPContained || bLPContained) {
                List boxSegs = PointListUtilities.getLineSegments((PointList)rBoxPoly);
                if (bFPContained) {
                    PointListUtilities.reAdjustBoxSize((List)boxSegs, (Point)firstPoint);
                }
                if (bLPContained) {
                    PointListUtilities.reAdjustBoxSize((List)boxSegs, (Point)lastPoint);
                }
                rBoxPoly.removeAllPoints();
                ListIterator li = boxSegs.listIterator();
                while (li.hasNext()) {
                    LineSeg seg = (LineSeg)li.next();
                    rBoxPoly.addPoint(seg.getOrigin());
                    if (li.hasNext()) continue;
                    rBoxPoly.addPoint(seg.getTerminus());
                }
            }
            return PointListUtilities.routeAroundPoly((PointList)points, (PointList)rBoxPoly, (int)nSmoothFactor, (boolean)true, (boolean)bIncludeIntersectionPoints, (int)nBuffer);
        }
        return null;
    }

    static boolean flattenSegments(PointList points, int straightLineTolerance) {
        boolean changed = false;
        int i = 0;
        while (i < points.size() - 1) {
            Point ptStart = points.getPoint(i);
            Point ptTerm = null;
            if (i + 1 < points.size()) {
                ptTerm = points.getPoint(i + 1);
            }
            Point ptNext = null;
            if (i + 2 < points.size()) {
                ptNext = points.getPoint(i + 2);
            }
            if (points.size() <= 2 || ptTerm == null || ptNext == null) {
                return changed;
            }
            if (PointListUtilities.sameOrientation((Point)ptStart, (Point)ptTerm, (Point)ptNext, (int)straightLineTolerance)) {
                PointListUtilities.removePoint((PointList)points, (int)(i + 1));
                Ray seg = new Ray(ptStart, ptTerm);
                if (Math.abs(seg.y) < straightLineTolerance) {
                    points.setPoint(new Point(ptNext.x, ptStart.y), i + 1);
                } else if (Math.abs(seg.x) < straightLineTolerance) {
                    points.setPoint(new Point(ptStart.x, ptNext.y), i + 1);
                }
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    static boolean sameOrientation(Point pt1, Point pt2, Point pt3, int straightLineTolerance) {
        LineSeg line = new LineSeg(pt1, pt3);
        Point pt = line.perpIntersect(pt2.x, pt2.y);
        return Math.round(pt.getDistance(new Point(pt2.x, pt2.y))) < (long)straightLineTolerance;
    }

    protected static double distanceAlong(List<LineSeg> mySegments, Point aPoint) {
        LineSeg theSegment = PointListUtilities.getNearestSegment(mySegments, (int)aPoint.x, (int)aPoint.y);
        double linePct = PointListUtilities.segmentDistance(mySegments, (LineSeg)theSegment, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN);
        double segmentPct = theSegment.distanceAlong(aPoint);
        if (0.0 <= segmentPct && segmentPct <= 1.0) {
            long polyLength = PointListUtilities.length(mySegments);
            if (polyLength != 0L) {
                linePct += segmentPct * (theSegment.length() / (double)polyLength);
            }
            return linePct;
        }
        return segmentPct;
    }

    protected static long length(List<LineSeg> mySegments) {
        long theLength = 0L;
        ListIterator<LineSeg> lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = lineIter.next();
            theLength += Math.round(aSegment.length());
        }
        return theLength;
    }

    protected static Point pointOn(List<LineSeg> mySegments, long theDistance, LineSeg.KeyPoint fromKeyPoint, Point ptResult) {
        long thisLength = PointListUtilities.length(mySegments);
        long halfLength = thisLength / 2L;
        if (theDistance >= thisLength) {
            if (fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
                mySegments.get(mySegments.size() - 1).pointOn(theDistance - thisLength, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                mySegments.get(mySegments.size() - 1).pointOn(theDistance - halfLength, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                mySegments.get(mySegments.size() - 1).pointOn(theDistance, LineSeg.KeyPoint.TERMINUS, ptResult);
                return ptResult;
            }
            IllegalArgumentException iae = new IllegalArgumentException();
            throw iae;
        }
        if (theDistance < 0L) {
            if (fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
                mySegments.get(0).pointOn(theDistance, fromKeyPoint, ptResult);
                return ptResult;
            }
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                return PointListUtilities.pointOn(mySegments, (long)(halfLength + theDistance), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)ptResult);
            }
            if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                mySegments.get(mySegments.size() - 1).pointOn(theDistance, fromKeyPoint, ptResult);
                return ptResult;
            }
            IllegalArgumentException iae = new IllegalArgumentException();
            throw iae;
        }
        LocateInfo locateInfo = new LocateInfo(null);
        if (!PointListUtilities.locateSegment(mySegments, (double)((double)theDistance / (double)thisLength), (LineSeg.KeyPoint)fromKeyPoint, (LocateInfo)locateInfo)) {
            return null;
        }
        locateInfo.theSegment.pointOn(locateInfo.remainingDist, fromKeyPoint == LineSeg.KeyPoint.MIDPOINT ? LineSeg.KeyPoint.ORIGIN : fromKeyPoint, ptResult);
        return ptResult;
    }

    protected static double segmentDistance(List<LineSeg> mySegments, LineSeg theSegment, LineSeg.KeyPoint uptoKeyPoint) {
        long accumulatedLength = 0L;
        ListIterator<LineSeg> lineIter = mySegments.listIterator();
        while (lineIter.hasNext()) {
            LineSeg aSegment = lineIter.next();
            if (theSegment.equals((Object)aSegment)) {
                long polyLength;
                if (uptoKeyPoint != LineSeg.KeyPoint.ORIGIN) {
                    if (uptoKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                        accumulatedLength = (long)((double)accumulatedLength + aSegment.length() / 2.0);
                    } else if (uptoKeyPoint == LineSeg.KeyPoint.TERMINUS) {
                        accumulatedLength = (long)((double)accumulatedLength + aSegment.length());
                    } else {
                        IllegalArgumentException iae = new IllegalArgumentException();
                        throw iae;
                    }
                }
                if ((polyLength = PointListUtilities.length(mySegments)) != 0L) {
                    return (double)accumulatedLength / (double)polyLength;
                }
                return 0.0;
            }
            accumulatedLength = (long)((double)accumulatedLength + aSegment.length());
        }
        return 0.0;
    }

    private static boolean BezierToLines(PointList thePolyPoints, Point ptCtl1, Point ptCtl2, Point ptCtl3, Point ptCtl4, int nSteps) {
        int i;
        boolean bRC = true;
        nSteps = Math.min(32, nSteps);
        double[] lpWorkX = new double[3 * nSteps + 2];
        double[] lpWorkY = new double[3 * nSteps + 2];
        lpWorkX[0] = ptCtl1.x;
        lpWorkX[1] = ptCtl2.x;
        lpWorkX[2] = ptCtl3.x;
        lpWorkX[3] = ptCtl4.x;
        lpWorkY[0] = ptCtl1.y;
        lpWorkY[1] = ptCtl2.y;
        lpWorkY[2] = ptCtl3.y;
        lpWorkY[3] = ptCtl4.y;
        int nLinePoints = 2;
        int nTotalPoints = 4;
        while (nLinePoints <= nSteps) {
            i = nTotalPoints - 1;
            while (i > 0) {
                lpWorkX[2 * i] = lpWorkX[i];
                lpWorkY[2 * i] = lpWorkY[i];
                --i;
            }
            nTotalPoints = 2 * nTotalPoints - 1;
            i = nTotalPoints - 2;
            while (i > 0) {
                lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                i -= 2;
            }
            i = nTotalPoints - 3;
            while (i > 0) {
                if (i % 6 != 0) {
                    lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                    lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                }
                i -= 2;
            }
            i = nTotalPoints - 4;
            while (i > 0) {
                lpWorkX[i] = (lpWorkX[i - 1] + lpWorkX[i + 1]) / 2.0;
                lpWorkY[i] = (lpWorkY[i - 1] + lpWorkY[i + 1]) / 2.0;
                i -= 6;
            }
            nLinePoints = nTotalPoints / 3 + 1;
        }
        i = 0;
        while (i < nSteps) {
            Point ptTemp = new Point();
            int j = 3 * i;
            ptTemp.x = (int)Math.round(lpWorkX[j]);
            ptTemp.y = (int)Math.round(lpWorkY[j]);
            thePolyPoints.addPoint(ptTemp);
            ++i;
        }
        return bRC;
    }

    private static int addRoutedPoints(PointList routePoints, LineSeg pCurBoxSeg1, LineSeg pCurBoxSeg2, PointList routePoly, boolean bForward, int nBuffer) {
        Point pNewPoint = null;
        float fOffset = 0.0f;
        int nDistance = 0;
        List rBoxSegments = PointListUtilities.getLineSegments((PointList)routePoly);
        ListIterator boxIter = bForward ? rBoxSegments.listIterator() : rBoxSegments.listIterator(rBoxSegments.size());
        while (!(bForward ? !boxIter.hasNext() : !boxIter.hasPrevious())) {
            LineSeg seg;
            LineSeg lineSeg = seg = bForward ? (LineSeg)boxIter.next() : (LineSeg)boxIter.previous();
            if (seg.equals((Object)pCurBoxSeg1)) break;
        }
        do {
            Point ptEnd;
            fOffset = (float)nBuffer / (float)pCurBoxSeg1.length();
            if (bForward) {
                fOffset = (float)((double)fOffset + 1.0);
                ptEnd = pCurBoxSeg1.getTerminus();
            } else {
                fOffset = (float)((double)fOffset * -1.0);
                ptEnd = pCurBoxSeg1.getOrigin();
            }
            if (routePoints.size() > 0) {
                nDistance = (int)((double)nDistance + routePoints.getLastPoint().getDistance(ptEnd));
            }
            pNewPoint = nBuffer > 0 ? new Point(pCurBoxSeg1.locatePoint((double)fOffset, (long)nBuffer, LineSeg.Sign.POSITIVE)) : new Point(ptEnd);
            routePoints.addPoint(pNewPoint);
            if (pCurBoxSeg1.equals((Object)pCurBoxSeg2)) continue;
            if (bForward) {
                if (!boxIter.hasNext()) {
                    boxIter = rBoxSegments.listIterator();
                }
                pCurBoxSeg1 = (LineSeg)boxIter.next();
                continue;
            }
            if (!boxIter.hasPrevious()) {
                boxIter = rBoxSegments.listIterator(rBoxSegments.size());
            }
            pCurBoxSeg1 = (LineSeg)boxIter.previous();
        } while (!pCurBoxSeg1.equals((Object)pCurBoxSeg2));
        return nDistance;
    }

    private static PointList calcApproxPolylineFromBezier(PointList points, int nBezierSteps) {
        PointList thePolyPoints = new PointList(points.size() * nBezierSteps + 2);
        boolean bStart = true;
        if (points.size() < 4) {
            return thePolyPoints;
        }
        Point ptCtl1 = new Point();
        int i = 0;
        while (i < points.size() - 3) {
            if (bStart) {
                ptCtl1 = new Point(points.getPoint(i));
                bStart = false;
            } else {
                thePolyPoints.removePoint(thePolyPoints.size() - 1);
            }
            Point ptCtl2 = new Point(points.getPoint(i + 1));
            Point ptCtl3 = new Point(points.getPoint(i + 2));
            Point ptCtl4 = new Point(points.getPoint(i + 3));
            if (!PointListUtilities.BezierToLines((PointList)thePolyPoints, (Point)ptCtl1, (Point)ptCtl2, (Point)ptCtl3, (Point)ptCtl4, (int)nBezierSteps)) {
                return null;
            }
            ptCtl1 = new Point(ptCtl4);
            i += 3;
        }
        thePolyPoints.setPoint(points.getPoint(0), 0);
        thePolyPoints.setPoint(points.getPoint(points.size() - 1), thePolyPoints.size() - 1);
        return thePolyPoints;
    }

    private static PointList calcBezier(PointList points, int nSmoothFactor, int nStartIndex, int nEndIndex) {
        Point ptPrevControl = null;
        PointList theBezierPoints = new PointList(points.size() * 2);
        List theSegments = PointListUtilities.getLineSegments((PointList)points);
        int i = 0;
        while (i < theSegments.size()) {
            LineSeg pLineSeg = (LineSeg)theSegments.get(i);
            double dLineLength = pLineSeg.length();
            double dControlLength = dLineLength * (double)nSmoothFactor / 100.0;
            boolean bAddToBezier = false;
            if (i >= nStartIndex && i <= nEndIndex) {
                bAddToBezier = true;
            } else if (i > nEndIndex) {
                return theBezierPoints;
            }
            if (dLineLength > 5.0) {
                Point ptStartControl = new Point();
                Point ptTerminusControl = new Point();
                Point ptStart = new Point(pLineSeg.getOrigin());
                Point ptTerminus = new Point(pLineSeg.getTerminus());
                if (theBezierPoints.size() == 0 && bAddToBezier) {
                    theBezierPoints.addPoint(ptStart);
                }
                if (ptPrevControl != null) {
                    LineSeg prevControlSeg = new LineSeg(ptPrevControl, ptStart);
                    ptStartControl = new Point();
                    prevControlSeg.pointOn((long)((int)Math.round(prevControlSeg.length() + dControlLength)), LineSeg.KeyPoint.ORIGIN, ptStartControl);
                } else {
                    ptStartControl = new Point();
                    pLineSeg.pointOn((long)((int)Math.round(dControlLength)), LineSeg.KeyPoint.ORIGIN, ptStartControl);
                }
                if (bAddToBezier) {
                    theBezierPoints.addPoint(ptStartControl);
                }
                Object pNextSeg = null;
                if (i + 1 < theSegments.size()) {
                    pNextSeg = (LineSeg)theSegments.get(i + 1);
                    while (pNextSeg != null && pNextSeg.length() < 5.0) {
                        pNextSeg = ++i + 1 < theSegments.size() ? (LineSeg)theSegments.get(i + 1) : null;
                    }
                }
                if (pNextSeg != null) {
                    Ray ptVector1 = new Ray(pLineSeg.getOrigin(), pLineSeg.getTerminus());
                    Ray ptVector2 = new Ray(pNextSeg.getOrigin(), pNextSeg.getTerminus());
                    double dNewAngle = 0.0;
                    LineSeg.TrigValues val = pLineSeg.getTrigValues(ptVector2);
                    dNewAngle = Math.atan2(-val.sinTheta, -val.cosTheta);
                    dNewAngle = dNewAngle > 0.0 ? (Math.PI - dNewAngle) / -2.0 : (-Math.PI - dNewAngle) / -2.0;
                    Transform trans = new Transform();
                    trans.setRotation(dNewAngle);
                    Point ptVector1Prime = trans.getTransformed(new Point(ptVector1.x, ptVector1.y));
                    LineSeg nextControlSeg = new LineSeg(new Point(0, 0), new Point(ptVector1Prime.x, ptVector1Prime.y));
                    Point ptProjection = new Point();
                    nextControlSeg.pointOn((long)((int)Math.round(dControlLength)), LineSeg.KeyPoint.ORIGIN, ptProjection);
                    ptTerminusControl = new Point(pLineSeg.getTerminus().x - ptProjection.x, pLineSeg.getTerminus().y - ptProjection.y);
                } else {
                    pLineSeg.pointOn((long)((int)Math.round(dLineLength - dControlLength)), LineSeg.KeyPoint.ORIGIN, ptTerminusControl);
                }
                ptPrevControl = new Point(ptTerminusControl);
                if (bAddToBezier) {
                    theBezierPoints.addPoint(ptTerminusControl);
                    theBezierPoints.addPoint(ptTerminus);
                }
            }
            ++i;
        }
        return theBezierPoints;
    }

    private static void copyFrom(PointList pointsTo, PointList pointsFrom) {
        pointsTo.removeAllPoints();
        int i = 0;
        while (i < pointsFrom.size()) {
            pointsTo.addPoint(pointsFrom.getPoint(i));
            ++i;
        }
    }

    private static int crossProduct(int ax, int ay, int bx, int by, int cx, int cy) {
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }

    private static void getRoutedPoints(PointList points, PointList newRoutePoints, Point ptIntersect1, Point ptIntersect2, Point ptPrev, Point ptNext, LineSeg pCurBoxSeg1, LineSeg pCurBoxSeg2, PointList routePoly, int nSmoothFactor, boolean bShortestDistance, boolean bIncludeIntersectionPoints, int nBuffer) {
        PointList newRoutePoints1 = new PointList();
        PointList newRoutePoints2 = new PointList();
        Point ptAbove = new Point(ptIntersect1);
        if (nBuffer > 0) {
            float dDistance = pCurBoxSeg1.distanceAlong(ptIntersect1);
            ptAbove = pCurBoxSeg1.locatePoint((double)dDistance, (long)nBuffer, LineSeg.Sign.POSITIVE);
        }
        newRoutePoints1.addPoint(new Point(ptAbove));
        newRoutePoints2.addPoint(new Point(ptAbove));
        int nDistance1 = 0;
        int nDistance2 = 0;
        LineSeg pCurSeg = pCurBoxSeg1;
        nDistance1 += PointListUtilities.addRoutedPoints((PointList)newRoutePoints1, (LineSeg)pCurSeg, (LineSeg)pCurBoxSeg2, (PointList)routePoly, (boolean)true, (int)nBuffer);
        nDistance1 = (int)((double)nDistance1 + newRoutePoints1.getLastPoint().getDistance(ptIntersect2));
        pCurSeg = pCurBoxSeg1;
        nDistance2 += PointListUtilities.addRoutedPoints((PointList)newRoutePoints2, (LineSeg)pCurSeg, (LineSeg)pCurBoxSeg2, (PointList)routePoly, (boolean)false, (int)nBuffer);
        nDistance2 = (int)((double)nDistance2 + newRoutePoints2.getLastPoint().getDistance(ptIntersect2));
        ptAbove = new Point(ptIntersect2);
        if (nBuffer > 0) {
            float dDistance = pCurBoxSeg2.distanceAlong(ptIntersect2);
            ptAbove = pCurBoxSeg2.locatePoint((double)dDistance, (long)nBuffer, LineSeg.Sign.POSITIVE);
        }
        newRoutePoints1.addPoint(new Point(ptAbove));
        newRoutePoints2.addPoint(new Point(ptAbove));
        if (nDistance1 < nDistance2 && bShortestDistance || nDistance1 > nDistance2 && !bShortestDistance) {
            PointListUtilities.copyFrom((PointList)newRoutePoints, (PointList)newRoutePoints1);
        } else {
            PointListUtilities.copyFrom((PointList)newRoutePoints, (PointList)newRoutePoints2);
        }
        if (!bIncludeIntersectionPoints && newRoutePoints.size() >= 3) {
            PointList checkPoints = new PointList(newRoutePoints.size() + 2);
            checkPoints.addPoint(new Point(ptPrev));
            int i = 0;
            while (i < newRoutePoints.size()) {
                checkPoints.addPoint(new Point(newRoutePoints.getPoint(i)));
                ++i;
            }
            checkPoints.addPoint(new Point(ptNext));
            int nIndex = 0;
            Point ptStart = checkPoints.getPoint(nIndex++);
            Point ptCheckSkip = checkPoints.getPoint(nIndex++);
            Object ptEnd = checkPoints.getPoint(nIndex++);
            List polySegments = PointListUtilities.getLineSegments((PointList)routePoly);
            newRoutePoints.removeAllPoints();
            while (ptEnd != null) {
                LineSeg tempSeg = new LineSeg(ptStart, ptEnd);
                Point ptIntersect = new Point();
                boolean bAddPoint = false;
                ListIterator segIter = polySegments.listIterator();
                while (segIter.hasNext()) {
                    LineSeg pPolySegment = (LineSeg)segIter.next();
                    ptIntersect = tempSeg.intersect(pPolySegment, 1);
                    if (ptIntersect == null) continue;
                    bAddPoint = true;
                    break;
                }
                if (bAddPoint) {
                    newRoutePoints.addPoint(new Point(ptCheckSkip));
                    ptStart = new Point(ptCheckSkip);
                }
                ptCheckSkip = new Point(ptEnd);
                ptEnd = nIndex < checkPoints.size() ? checkPoints.getPoint(nIndex++) : null;
            }
        }
        if (nSmoothFactor > 0) {
            PointList tempPoly = PointListUtilities.calcSmoothPolyline((PointList)newRoutePoints, (int)nSmoothFactor, (int)16);
            PointListUtilities.copyFrom((PointList)newRoutePoints, (PointList)tempPoly);
        }
    }

    private static boolean locateSegment(List<LineSeg> mySegments, double pctDist, LineSeg.KeyPoint fromKeyPoint, LocateInfo locateInfo) {
        double thePctDist = pctDist;
        if (pctDist < 0.0) {
            thePctDist = 0.0;
        } else if (1.0 < pctDist) {
            thePctDist = 1.0;
        }
        long theLength = PointListUtilities.length(mySegments);
        long remainingLength = Math.round(thePctDist * (double)theLength);
        long nextLength = 0L;
        locateInfo.theSegment = null;
        if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT || fromKeyPoint == LineSeg.KeyPoint.ORIGIN) {
            if (fromKeyPoint == LineSeg.KeyPoint.MIDPOINT) {
                remainingLength += theLength / 2L;
            }
            ListIterator<LineSeg> lineIter = mySegments.listIterator();
            while (lineIter.hasNext()) {
                LineSeg aSegment = lineIter.next();
                nextLength = Math.round(aSegment.length());
                if (nextLength >= remainingLength) {
                    locateInfo.theSegment = aSegment;
                    break;
                }
                remainingLength -= nextLength;
            }
        } else if (fromKeyPoint == LineSeg.KeyPoint.TERMINUS) {
            ListIterator<LineSeg> lineIter = mySegments.listIterator(mySegments.size());
            while (lineIter.hasPrevious()) {
                LineSeg aSegment = lineIter.previous();
                nextLength = Math.round(aSegment.length());
                if (nextLength >= remainingLength) {
                    locateInfo.theSegment = aSegment;
                    break;
                }
                remainingLength -= nextLength;
            }
        } else {
            IllegalArgumentException iae = new IllegalArgumentException();
            throw iae;
        }
        locateInfo.remainingDist = remainingLength;
        return true;
    }

    private static void reAdjustBoxSize(List<LineSeg> boxSegs, Point containedPoint) {
        assert (boxSegs.size() == 4);
        LineSeg seg = PointListUtilities.getNearestSegment(boxSegs, (int)containedPoint.x, (int)containedPoint.y);
        LineSeg newSeg = seg.getParallelLineSegThroughPoint(containedPoint);
        ListIterator<LineSeg> li = boxSegs.listIterator();
        Object prev = null;
        LineSeg next = null;
        LineSeg current = null;
        if (li.hasNext()) {
            current = li.next();
        }
        while (current != null) {
            next = li.hasNext() ? li.next() : null;
            if (current.equals((Object)seg)) {
                if (prev != null) {
                    prev.setTerminus(newSeg.getOrigin());
                }
                current.setOrigin(newSeg.getOrigin());
                current.setTerminus(newSeg.getTerminus());
                if (next != null) {
                    next.setOrigin(newSeg.getTerminus());
                }
            }
            current = next;
        }
    }

    private static Point removePoint(PointList points, int index) {
        Point removedPt = points.getPoint(index);
        int i = index;
        while (i < points.size() - 1) {
            points.setPoint(points.getPoint(i + 1), i);
            ++i;
        }
        points.setSize(points.size() - 1);
        return removedPt;
    }
}

