/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.routers;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Direction;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.GeomUtils;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Orientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;

public class OrthogonalRouter
extends BendpointConnectionRouter {
    private static final PrecisionPoint A_POINT = new PrecisionPoint();

    public void route(Connection conn) {
        ConnectionAnchor sourceAnchor = conn.getSourceAnchor();
        ConnectionAnchor targetAnchor = conn.getTargetAnchor();
        List bendpoints = this.computeInitialBendpointsList(conn, sourceAnchor, targetAnchor);
        Point sourceLocation = ((Bendpoint)bendpoints.get(0)).getLocation();
        Point targetLocation = ((Bendpoint)bendpoints.get(bendpoints.size() - 1)).getLocation();
        Rectangle sourceRelativeBounds = this.getAnchorOwnerAbsoluteBounds(sourceAnchor).expand(1, 1);
        conn.translateToRelative((Translatable)sourceRelativeBounds);
        Rectangle targetRelativeBounds = this.getAnchorOwnerAbsoluteBounds(targetAnchor).expand(1, 1);
        conn.translateToRelative((Translatable)targetRelativeBounds);
        Direction sourceAnchorOrientation = GeomUtils.getDirection((Point)sourceLocation, (Rectangle)sourceRelativeBounds);
        Direction targetAnchorOrientation = GeomUtils.getDirection((Point)targetLocation, (Rectangle)targetRelativeBounds);
        if (bendpoints.size() == 2) {
            this.fixNoBendpointsLink(bendpoints, sourceLocation, targetLocation, sourceAnchorOrientation, targetAnchorOrientation);
        } else if (bendpoints.size() == 3) {
            this.fixOneBendpointLink(bendpoints, sourceLocation, targetLocation, sourceAnchorOrientation, targetAnchorOrientation);
        } else {
            this.fixSeveralBendpointsLink(bendpoints, sourceLocation, targetLocation, sourceAnchorOrientation, targetAnchorOrientation);
        }
        this.cleanup(bendpoints);
        PointList points = conn.getPoints();
        points.removeAllPoints();
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        conn.setPoints(points);
    }

    private List<Bendpoint> getBendpoints(Connection conn) {
        return (List)this.getConstraint(conn);
    }

    private Rectangle getAnchorOwnerAbsoluteBounds(ConnectionAnchor anchor) {
        IFigure f = anchor.getOwner();
        if (f == null) {
            Point p = anchor.getReferencePoint();
            return new Rectangle(p.x, p.y, 1, 1);
        }
        PrecisionRectangle bounds = new PrecisionRectangle(f instanceof HandleBounds ? ((HandleBounds)f).getHandleBounds() : f.getBounds());
        f.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private void cleanup(List<Bendpoint> bendpoints) {
        ArrayList<Integer> indexesToRemove = new ArrayList<Integer>();
        int i = 1;
        while (i < bendpoints.size() - 2) {
            Point p2;
            Point p1 = bendpoints.get(i).getLocation();
            if (p1.getDistance(p2 = bendpoints.get(i + 1).getLocation()) < 1.0) {
                indexesToRemove.add(i);
            }
            ++i;
        }
        i = indexesToRemove.size() - 1;
        while (i >= 0) {
            bendpoints.remove((Integer)indexesToRemove.get(i));
            --i;
        }
        indexesToRemove.clear();
        i = 1;
        while (i < bendpoints.size() - 1) {
            if (bendpoints.get((int)(i - 1)).getLocation().x == bendpoints.get((int)(i + 1)).getLocation().x || bendpoints.get((int)(i - 1)).getLocation().y == bendpoints.get((int)(i + 1)).getLocation().y) {
                indexesToRemove.add(i);
            }
            ++i;
        }
        i = indexesToRemove.size() - 1;
        while (i >= 0) {
            bendpoints.remove((Integer)indexesToRemove.get(i));
            --i;
        }
    }

    private void fixSeveralBendpointsLink(List<Bendpoint> bendpoints, Point sourceLocation, Point targetLocation, Direction sourceAnchorOrientation, Direction targetAnchorOrientation) {
        Point fixedPoint = bendpoints.get(1).getLocation();
        Point nextPoint = bendpoints.get(2).getLocation();
        Orientation nextSegmentOrientation = Orientation.NONE;
        if (fixedPoint.x == nextPoint.x) {
            nextSegmentOrientation = Orientation.VERTICAL;
        } else if (fixedPoint.y == nextPoint.y) {
            nextSegmentOrientation = Orientation.HORIZONTAL;
        } else assert (false) : "impossible to determine orientation of start segment, something is wrong with the provided list of bendpoints!";
        if (sourceAnchorOrientation == Direction.NONE) {
            if (nextSegmentOrientation == Orientation.VERTICAL) {
                fixedPoint.y = sourceLocation.y;
            } else if (nextSegmentOrientation == Orientation.HORIZONTAL) {
                fixedPoint.x = sourceLocation.x;
            }
        } else if (sourceAnchorOrientation == Direction.NORTH || sourceAnchorOrientation == Direction.SOUTH) {
            if (nextSegmentOrientation != Orientation.HORIZONTAL) {
                bendpoints.add(1, null);
                fixedPoint = new Point(fixedPoint);
            }
            fixedPoint.x = sourceLocation.x;
        } else {
            if (nextSegmentOrientation != Orientation.VERTICAL) {
                bendpoints.add(1, null);
                fixedPoint = new Point(fixedPoint);
            }
            fixedPoint.y = sourceLocation.y;
        }
        AbsoluteBendpoint fixedBendpoint = new AbsoluteBendpoint(fixedPoint);
        bendpoints.set(1, (Bendpoint)fixedBendpoint);
        int lastBendpointIndex = bendpoints.size() - 2;
        fixedPoint = bendpoints.get(lastBendpointIndex).getLocation();
        nextPoint = bendpoints.get(lastBendpointIndex - 1).getLocation();
        Orientation previousSegmentOrientation = Orientation.NONE;
        if (fixedPoint.x == nextPoint.x) {
            previousSegmentOrientation = Orientation.VERTICAL;
        } else if (fixedPoint.y == nextPoint.y) {
            previousSegmentOrientation = Orientation.HORIZONTAL;
        } else assert (false) : "impossible to determine orientation of last segment, something is wrong with the provided list of bendpoints!";
        if (targetAnchorOrientation == Direction.NONE) {
            if (previousSegmentOrientation == Orientation.VERTICAL) {
                fixedPoint.y = targetLocation.y;
            } else if (previousSegmentOrientation == Orientation.HORIZONTAL) {
                fixedPoint.x = targetLocation.x;
            }
        } else if (targetAnchorOrientation == Direction.NORTH || targetAnchorOrientation == Direction.SOUTH) {
            if (previousSegmentOrientation != Orientation.HORIZONTAL) {
                bendpoints.add(++lastBendpointIndex, null);
                fixedPoint = new Point(fixedPoint);
            }
            fixedPoint.x = targetLocation.x;
        } else {
            if (previousSegmentOrientation != Orientation.VERTICAL) {
                bendpoints.add(++lastBendpointIndex, null);
                fixedPoint = new Point(fixedPoint);
            }
            fixedPoint.y = targetLocation.y;
        }
        fixedBendpoint = new AbsoluteBendpoint(fixedPoint);
        bendpoints.set(lastBendpointIndex, (Bendpoint)fixedBendpoint);
    }

    private void fixOneBendpointLink(List<Bendpoint> bendpoints, Point sourceLocation, Point targetLocation, Direction sourceAnchorOrientation, Direction targetAnchorOrientation) {
        Point fixedPoint = bendpoints.get(1).getLocation();
        if (sourceAnchorOrientation == Direction.NORTH || sourceAnchorOrientation == Direction.SOUTH) {
            fixedPoint.x = sourceLocation.x;
            if (targetAnchorOrientation == Direction.NORTH || targetAnchorOrientation == Direction.SOUTH) {
                if (targetLocation.x != fixedPoint.x) {
                    A_POINT.setLocation(targetLocation.x, fixedPoint.y);
                    bendpoints.add(2, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
                }
            } else {
                fixedPoint.y = targetLocation.y;
            }
        } else {
            fixedPoint.y = sourceLocation.y;
            if (targetAnchorOrientation == Direction.NORTH || targetAnchorOrientation == Direction.SOUTH || targetAnchorOrientation == Direction.NONE) {
                fixedPoint.x = targetLocation.x;
            } else if (targetLocation.y != fixedPoint.y) {
                A_POINT.setLocation(fixedPoint.x, targetLocation.y);
                bendpoints.add(2, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
            }
        }
        AbsoluteBendpoint fixedBendpoint = new AbsoluteBendpoint(fixedPoint);
        bendpoints.add(1, (Bendpoint)fixedBendpoint);
        bendpoints.remove(2);
    }

    private void fixNoBendpointsLink(List<Bendpoint> bendpoints, Point sourceLocation, Point targetLocation, Direction sourceAnchorOrientation, Direction targetAnchorOrientation) {
        if (sourceAnchorOrientation == Direction.NORTH || sourceAnchorOrientation == Direction.SOUTH) {
            if (targetAnchorOrientation == Direction.NORTH || targetAnchorOrientation == Direction.SOUTH) {
                if (sourceLocation.x != targetLocation.x) {
                    A_POINT.setLocation(sourceLocation.x, (sourceLocation.y + targetLocation.y) / 2);
                    bendpoints.add(1, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
                    A_POINT.setLocation(targetLocation.x, (sourceLocation.y + targetLocation.y) / 2);
                    bendpoints.add(2, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
                }
            } else {
                A_POINT.setLocation(sourceLocation.x, targetLocation.y);
                bendpoints.add(1, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
            }
        } else if (targetAnchorOrientation == Direction.NONE) {
            if (sourceLocation.y != targetLocation.y) {
                A_POINT.setLocation(targetLocation.x, sourceLocation.y);
                bendpoints.add(1, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
            }
        } else if (targetAnchorOrientation == Direction.SOUTH || targetAnchorOrientation == Direction.NORTH) {
            A_POINT.setLocation(targetLocation.x, sourceLocation.y);
            bendpoints.add(1, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        } else if (sourceLocation.y != targetLocation.y) {
            A_POINT.setLocation((sourceLocation.x + targetLocation.x) / 2, sourceLocation.y);
            bendpoints.add(1, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
            A_POINT.setLocation((sourceLocation.x + targetLocation.x) / 2, targetLocation.y);
            bendpoints.add(2, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        }
    }

    private List<Bendpoint> computeInitialBendpointsList(Connection conn, ConnectionAnchor sourceAnchor, ConnectionAnchor targetAnchor) {
        boolean targetContainsSource;
        List<Bendpoint> origBendpoints = this.getBendpoints(conn);
        if (origBendpoints == null) {
            origBendpoints = Collections.emptyList();
        }
        ArrayList<Bendpoint> bendpoints = new ArrayList<Bendpoint>();
        A_POINT.setLocation(sourceAnchor.getReferencePoint());
        conn.translateToRelative((Translatable)A_POINT);
        bendpoints.add((Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        for (Bendpoint bendpoint : origBendpoints) {
            bendpoints.add((Bendpoint)new AbsoluteBendpoint(bendpoint.getLocation()));
        }
        A_POINT.setLocation(targetAnchor.getReferencePoint());
        conn.translateToRelative((Translatable)A_POINT);
        bendpoints.add((Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        Rectangle srcBounds = this.getAnchorOwnerAbsoluteBounds(sourceAnchor).expand(1, 1);
        conn.translateToRelative((Translatable)srcBounds);
        Rectangle targetBounds = this.getAnchorOwnerAbsoluteBounds(targetAnchor).expand(1, 1);
        conn.translateToRelative((Translatable)targetBounds);
        boolean sourceContainsTarget = srcBounds.contains(targetBounds);
        if (!sourceContainsTarget) {
            while (bendpoints.size() > 2 && srcBounds.contains(((Bendpoint)bendpoints.get(1)).getLocation())) {
                bendpoints.remove(1);
            }
        }
        if (!(targetContainsSource = targetBounds.contains(srcBounds))) {
            while (bendpoints.size() > 2 && targetBounds.contains(((Bendpoint)bendpoints.get(bendpoints.size() - 2)).getLocation())) {
                bendpoints.remove(bendpoints.size() - 2);
            }
        }
        A_POINT.setLocation(((Bendpoint)bendpoints.get(1)).getLocation());
        conn.translateToAbsolute((Translatable)A_POINT);
        A_POINT.setLocation(sourceAnchor.getLocation((Point)A_POINT));
        conn.translateToRelative((Translatable)A_POINT);
        bendpoints.set(0, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        int index = bendpoints.size() - 1;
        A_POINT.setLocation(((Bendpoint)bendpoints.get(index - 1)).getLocation());
        conn.translateToAbsolute((Translatable)A_POINT);
        A_POINT.setLocation(targetAnchor.getLocation((Point)A_POINT));
        conn.translateToRelative((Translatable)A_POINT);
        bendpoints.set(index, (Bendpoint)new AbsoluteBendpoint((Point)A_POINT));
        return bendpoints;
    }
}

