/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.routers;

import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;

public class RakeConstraint
implements IPersistent {
    private XYAnchor sourceRakeAnchor;
    private XYAnchor targetRakeAnchor;
    private static final int MAJOR_VERSION = 0;

    public RakeConstraint(RakeConstraint other) {
        this.sourceRakeAnchor = other.sourceRakeAnchor;
        this.targetRakeAnchor = other.targetRakeAnchor;
    }

    public RakeConstraint getCopy() {
        RakeConstraint ret = new RakeConstraint();
        ret.sourceRakeAnchor = this.sourceRakeAnchor == null ? null : new XYAnchor(this.sourceRakeAnchor.getReferencePoint());
        ret.targetRakeAnchor = this.targetRakeAnchor == null ? null : new XYAnchor(this.targetRakeAnchor.getReferencePoint());
        return ret;
    }

    public RakeConstraint() {
    }

    public void setSourceRakeAnchor(XYAnchor rakeAnchor) {
        this.sourceRakeAnchor = rakeAnchor;
    }

    public XYAnchor getSourceRakeAnchor() {
        return this.sourceRakeAnchor;
    }

    public void setTargetRakeAnchor(XYAnchor rakeAnchor) {
        this.targetRakeAnchor = rakeAnchor;
    }

    public XYAnchor getTargetRakeAnchor() {
        return this.targetRakeAnchor;
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public void read(IDiagramReader in) {
        Point p = (Point)in.readProperty("src");
        if (p != null) {
            this.sourceRakeAnchor = new XYAnchor(p);
        }
        if ((p = (Point)in.readProperty("target")) != null) {
            this.targetRakeAnchor = new XYAnchor(p);
        }
    }

    public void write(IDiagramWriter out) {
        if (this.sourceRakeAnchor != null) {
            out.writeProperty("src", this.sourceRakeAnchor.getReferencePoint());
        }
        if (this.targetRakeAnchor != null) {
            out.writeProperty("target", this.targetRakeAnchor.getReferencePoint());
        }
    }

    void addListener(AnchorListener connection) {
        if (this.sourceRakeAnchor != null) {
            this.sourceRakeAnchor.addAnchorListener(connection);
        }
        if (this.targetRakeAnchor != null) {
            this.targetRakeAnchor.addAnchorListener(connection);
        }
    }

    void removeListener(AnchorListener connection) {
        if (this.sourceRakeAnchor != null) {
            this.sourceRakeAnchor.removeAnchorListener(connection);
        }
        if (this.targetRakeAnchor != null) {
            this.targetRakeAnchor.removeAnchorListener(connection);
        }
    }

    public Point getSourceRakeLocation() {
        if (this.sourceRakeAnchor != null) {
            return this.sourceRakeAnchor.getReferencePoint();
        }
        return null;
    }

    public Point getTargetRakeLocation() {
        if (this.targetRakeAnchor != null) {
            return this.targetRakeAnchor.getReferencePoint();
        }
        return null;
    }

    public int getMajorVersion() {
        return 0;
    }
}

