/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.figures.routers;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Direction;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.GeomUtils;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Orientation;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class RakeRouter
implements ConnectionRouter {
    private Map<Connection, RakeConstraint> constraints = new HashMap();
    private static final Point P1 = new Point();
    private static final Point P2 = new Point();
    private static final Point P3 = new Point();
    private static final Point P4 = new Point();
    private static final Point rakePos = new Point();

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void invalidate(Connection connection) {
    }

    public void remove(Connection connection) {
        RakeConstraint old = (RakeConstraint)this.constraints.remove(connection);
        old.removeListener((AnchorListener)connection);
    }

    private void routeToTarget(Connection conn) {
        Point srcRef;
        ConnectionAnchor sourceAnchor = conn.getSourceAnchor();
        ConnectionAnchor targetAnchor = conn.getTargetAnchor();
        Rectangle targetBounds = this.getAnchorBounds(targetAnchor);
        PointList points = conn.getPoints();
        points.removeAllPoints();
        RakeConstraint c = (RakeConstraint)this.constraints.get(conn);
        if (c == null) {
            throw new IllegalStateException("The connection has no layout constraint.");
        }
        rakePos.setLocation(c.getTargetRakeAnchor().getReferencePoint());
        conn.translateToAbsolute((Translatable)rakePos);
        Direction rakeDir = GeomUtils.getDirection((Point)conn.getTargetAnchor().getLocation(rakePos), (Rectangle)targetBounds);
        Orientation rakeOrientation = GeomUtils.getOrientation((Direction)rakeDir);
        if (rakeOrientation == Orientation.VERTICAL) {
            srcRef = new Point(sourceAnchor.getReferencePoint().x, RakeRouter.rakePos.y);
            RakeRouter.rakePos.x = targetAnchor.getReferencePoint().x;
        } else {
            srcRef = new Point(RakeRouter.rakePos.x, sourceAnchor.getReferencePoint().y);
            RakeRouter.rakePos.y = targetAnchor.getReferencePoint().y;
        }
        P1.setLocation(sourceAnchor.getLocation(srcRef));
        P2.setLocation(srcRef);
        P3.setLocation(rakePos);
        P4.setLocation(targetAnchor.getLocation(rakePos));
        if (rakeOrientation == Orientation.VERTICAL) {
            RakeRouter.P3.x = RakeRouter.P4.x;
        } else {
            RakeRouter.P3.y = RakeRouter.P4.y;
        }
        conn.translateToRelative((Translatable)P1);
        conn.translateToRelative((Translatable)P2);
        conn.translateToRelative((Translatable)P3);
        conn.translateToRelative((Translatable)P4);
        points.addPoint(P1);
        points.addPoint(P2);
        points.addPoint(P3);
        points.addPoint(P4);
        conn.setPoints(points);
    }

    private void routeToSource(Connection conn) {
        Point ref2;
        ConnectionAnchor sourceAnchor = conn.getSourceAnchor();
        ConnectionAnchor targetAnchor = conn.getTargetAnchor();
        Rectangle srcBounds = this.getAnchorBounds(sourceAnchor);
        PointList points = conn.getPoints();
        points.removeAllPoints();
        RakeConstraint c = (RakeConstraint)this.constraints.get(conn);
        if (c == null) {
            throw new IllegalStateException("The connection has no layout constraint.");
        }
        rakePos.setLocation(c.getSourceRakeAnchor().getReferencePoint());
        conn.translateToAbsolute((Translatable)rakePos);
        Direction rakeDir = GeomUtils.getDirection((Point)conn.getSourceAnchor().getLocation(rakePos), (Rectangle)srcBounds);
        Orientation rakeOrientation = GeomUtils.getOrientation((Direction)rakeDir);
        if (rakeOrientation == Orientation.VERTICAL) {
            ref2 = new Point(targetAnchor.getReferencePoint().x, RakeRouter.rakePos.y);
            RakeRouter.rakePos.x = sourceAnchor.getReferencePoint().x;
        } else {
            ref2 = new Point(RakeRouter.rakePos.x, targetAnchor.getReferencePoint().y);
            RakeRouter.rakePos.y = targetAnchor.getReferencePoint().y;
        }
        P1.setLocation(sourceAnchor.getLocation(rakePos));
        P2.setLocation(rakePos);
        P3.setLocation(ref2);
        P4.setLocation(targetAnchor.getLocation(ref2));
        conn.translateToRelative((Translatable)P1);
        conn.translateToRelative((Translatable)P2);
        conn.translateToRelative((Translatable)P3);
        conn.translateToRelative((Translatable)P4);
        points.addPoint(P1);
        points.addPoint(P2);
        points.addPoint(P3);
        points.addPoint(P4);
        conn.setPoints(points);
    }

    private Rectangle getAnchorBounds(ConnectionAnchor anchor) {
        IFigure f = anchor.getOwner();
        if (f == null) {
            Point p = anchor.getReferencePoint();
            return new Rectangle(p.x, p.y, 1, 1);
        }
        Rectangle bounds = f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    public void setConstraint(Connection connection, Object constraint) {
        RakeConstraint old = (RakeConstraint)this.constraints.get(connection);
        if (old == constraint) {
            return;
        }
        if (old != null) {
            old.removeListener((AnchorListener)connection);
        }
        RakeConstraint rakeConstraint = (RakeConstraint)constraint;
        this.constraints.put(connection, rakeConstraint);
        rakeConstraint.addListener((AnchorListener)connection);
    }

    public void route(Connection connection) {
        RakeConstraint c = (RakeConstraint)this.constraints.get(connection);
        if (c == null) {
            return;
        }
        if (c.getSourceRakeAnchor() != null) {
            this.routeToSource(connection);
        } else {
            this.routeToTarget(connection);
        }
    }
}

