/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.helpers;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import java.util.ArrayList;
import java.util.Collections;

public class MmHelper {
    public static boolean canAddTo(IElement parentElement, IElement childElement) {
        if (!parentElement.isValid()) {
            return false;
        }
        if (!CreationExpertRegistry.getExpert(parentElement.getClass()).canOwn(parentElement, childElement, null)) {
            return false;
        }
        if (parentElement instanceof IModelElement) {
            IModelElement parentModel = (IModelElement)parentElement;
            for (IStereotype ste : parentModel.getExtension()) {
                ICreationExpert steExpert = CreationExpertRegistry.getExpert((IStereotype)ste);
                if (steExpert == null || steExpert.canOwn(parentElement, childElement, null)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canAddTo(IElement parentElement, Class<? extends IElement> toCreate) {
        if (!parentElement.isValid()) {
            return false;
        }
        if (!CreationExpertRegistry.getExpert(parentElement.getClass()).canOwn(parentElement, toCreate, null)) {
            return false;
        }
        if (parentElement instanceof IModelElement) {
            IModelElement parentModel = (IModelElement)parentElement;
            for (IStereotype ste : parentModel.getExtension()) {
                ICreationExpert expert = CreationExpertRegistry.getExpert((IStereotype)ste);
                if (expert == null || expert.canOwn(parentElement, toCreate, null)) continue;
                return false;
            }
        }
        return true;
    }

    public static INameSpace getCommonNameSpace(IElement aSource, IElement aTarget) throws IllegalArgumentException {
        ArrayList<IElement> l1 = new ArrayList<IElement>(20);
        ArrayList<IElement> l2 = new ArrayList<IElement>(20);
        IElement el = aSource;
        while (el != null) {
            l1.add(el);
            el = el.getCompositionOwner();
        }
        el = aTarget;
        while (el != null) {
            l2.add(el);
            el = el.getCompositionOwner();
        }
        Collections.reverse(l1);
        Collections.reverse(l2);
        IElement ret = null;
        int i = 0;
        int max = Math.min(l1.size(), l2.size());
        do {
            if ((el = (IElement)l1.get(i)) instanceof INameSpace) {
                if (el.equals(l2.get(i))) {
                    ret = el;
                    continue;
                }
                return (INameSpace)ret;
            }
            if (ret == null) continue;
            return (INameSpace)ret;
        } while (++i < max);
        if (ret != null) {
            return (INameSpace)ret;
        }
        throw new IllegalArgumentException("No common namespace between " + aSource + " and " + aTarget);
    }
}

