/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.ModelManager;
import com.modeliosoft.modelio.diagram.elements.core.obfactory.IModelLinkFactory;
import org.eclipse.gef.commands.Command;

public class DefaultCreateLinkCommand
extends Command {
    private IGmPath path;
    protected ModelioLinkCreationContext context;
    protected IGmLinkable sourceNode;
    protected IGmLinkable targetNode;

    public DefaultCreateLinkCommand(ModelioLinkCreationContext context) {
        this.context = context;
    }

    public boolean canExecute() {
        GmAbstractDiagram gmDiagram = this.sourceNode.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        if (this.context.getElementToUnmask() == null) {
            IElement srcElement = this.sourceNode.getRelatedIElement();
            Class toCreate = MetaModelExpert.getMetaclass((String)this.context.getMetaclass());
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert((IStereotype)this.context.getStereotype());
            if (this.targetNode == null) {
                if (!CreationExpertRegistry.getExpert((Class)toCreate).canLinkFrom(srcElement, null)) {
                    return false;
                }
                if (this.context.getStereotype() != null && stereotypeExpert != null && !stereotypeExpert.canLinkFrom(srcElement, null)) {
                    return false;
                }
                if (!AuthHelper.canCreateLinkFrom((Class)toCreate, (IElement)srcElement)) {
                    return false;
                }
            } else {
                IElement targetEl = this.targetNode.getRelatedIElement();
                if (targetEl == null || !targetEl.isValid()) {
                    return false;
                }
                if (!CreationExpertRegistry.getExpert((Class)toCreate).canLink(srcElement, targetEl, null)) {
                    return false;
                }
                if (this.context.getStereotype() != null && stereotypeExpert != null && !stereotypeExpert.canLink(srcElement, targetEl, null)) {
                    return false;
                }
                if (!AuthHelper.canCreateLink((Class)toCreate, (IElement)srcElement, (IElement)targetEl)) {
                    return false;
                }
            }
        }
        return true;
    }

    public void execute() {
        GmAbstractDiagram gmDiagram = this.sourceNode.getDiagram();
        IElement linkElement = this.context.getElementToUnmask();
        if (linkElement == null) {
            linkElement = this.createElement();
        }
        this.unmaskElement(gmDiagram, linkElement);
    }

    public void setContext(ModelioLinkCreationContext newContext) {
        this.context = newContext;
    }

    public void setSource(IGmLinkable sourceNode) {
        this.sourceNode = sourceNode;
    }

    public void setTarget(IGmLinkable targetNode) {
        this.targetNode = targetNode;
    }

    public void setPath(IGmPath path) {
        this.path = path;
    }

    protected GmLink unmaskElement(GmAbstractDiagram gmDiagram, IElement linkElement) {
        return gmDiagram.unmaskLink(linkElement, this.sourceNode, this.targetNode, (Object)this.path);
    }

    protected IElement createElement() {
        GmAbstractDiagram gmDiagram = this.sourceNode.getDiagram();
        ModelManager manager = gmDiagram.getModelManager();
        IModelLinkFactory modelFactory = manager.getModelLinkFactory();
        IElement srcElement = this.sourceNode.getRelatedIElement();
        IElement targetElement = this.targetNode.getRelatedIElement();
        IElement linkElement = modelFactory.createLink(this.context.getMetaclass(), srcElement, targetElement);
        if (this.context.getStereotype() != null && linkElement instanceof IModelElement) {
            ((IModelElement)linkElement).addExtension(this.context.getStereotype());
        }
        gmDiagram.getElementInitializer().initialize(linkElement, this.context.getProperties());
        return linkElement;
    }
}

