/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.model.LinkExpert;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.diagram.elements.core.figures.FigureUtilities2;
import com.modeliosoft.modelio.diagram.elements.core.link.ConnectionRouterRegistry;
import com.modeliosoft.modelio.diagram.elements.core.link.CreateBendedConnectionRequest;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultCreateLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultReconnectSourceCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.DefaultReconnectTargetCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.IAnchorModelProvider;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.link.path.ConnectionHelperFactory;
import com.modeliosoft.modelio.diagram.elements.core.link.path.GmPathDataExtractor;
import com.modeliosoft.modelio.diagram.elements.core.link.path.IConnectionHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.path.RawPathData;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class DefaultCreateLinkEditPolicy
extends GraphicalNodeEditPolicy {
    private static final int ARROW_DEPTH = 9;
    private static final int ARROW_WIDTH = 4;
    private boolean isOpaque = true;
    private XYAnchor dummyAnchor = new XYAnchor(new Point(10, 10));
    private IFigure highlight;

    public DefaultCreateLinkEditPolicy() {
        this(true);
    }

    public DefaultCreateLinkEditPolicy(boolean isOpaque) {
        this.isOpaque = isOpaque;
    }

    public void eraseSourceFeedback(Request request) {
        if ("add bendpoint to future connection".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("add bendpoint to future connection".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((DropRequest)request);
        } else {
            super.eraseTargetFeedback(request);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType())) {
            return this.getTargetEditPartConnectionStart((CreateConnectionRequest)request);
        }
        if ("connection end".equals(request.getType())) {
            return this.getTargetEditPartConnectionEnd((CreateConnectionRequest)request);
        }
        if ("Reconnection source".equals(request.getType())) {
            return this.getReconnectSourceTargetEditPart((ReconnectRequest)request);
        }
        if ("Reconnection target".equals(request.getType())) {
            return this.getReconnectTargetTargetEditPart((ReconnectRequest)request);
        }
        return super.getTargetEditPart(request);
    }

    public void showSourceFeedback(Request request) {
        if ("add bendpoint to future connection".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
        } else {
            super.showSourceFeedback(request);
        }
    }

    public void showTargetFeedback(Request request) {
        if ("add bendpoint to future connection".equals(request.getType())) {
            this.showTargetConnectionFeedback((DropRequest)request);
        } else {
            super.showTargetFeedback(request);
        }
    }

    protected Connection createDummyConnection(Request req) {
        PolylineConnection ret = new PolylineConnection();
        PolylineDecoration arrow = new PolylineDecoration();
        arrow.setTemplate(PolylineDecoration.TRIANGLE_TIP);
        arrow.setScale(9.0, 4.0);
        arrow.setOpaque(false);
        arrow.setBackgroundColor(null);
        arrow.setFill(false);
        ret.setTargetDecoration((RotatableDecoration)arrow);
        return ret;
    }

    protected IGmPath createPathModel(CreateConnectionRequest req) {
        GmPath ret = new GmPath();
        ret.setRouterKind(StyleKey.ConnectionRouterId.DIRECT);
        NodeEditPart sourceEditPart = (NodeEditPart)req.getSourceEditPart();
        ConnectionAnchor srcAnchor = sourceEditPart.getSourceConnectionAnchor((Request)req);
        ret.setSourceAnchor(this.getAnchorModel(sourceEditPart, srcAnchor));
        NodeEditPart targetPart = (NodeEditPart)req.getTargetEditPart();
        ConnectionAnchor targetAnchor = targetPart.getTargetConnectionAnchor((Request)req);
        ret.setTargetAnchor(this.getAnchorModel(targetPart, targetAnchor));
        if (req instanceof CreateBendedConnectionRequest) {
            CreateBendedConnectionRequest request = (CreateBendedConnectionRequest)req;
            Connection tmpConnection = this.createDummyConnection((Request)req);
            this.getLayer((Object)"Connection Layer").add((IFigure)tmpConnection);
            StyleKey.ConnectionRouterId routerId = request.getData().getRoutingMode();
            ConnectionRouter router = this.getRouterRegistry().get((Object)routerId);
            tmpConnection.setConnectionRouter(router);
            ret.setRouterKind(routerId);
            tmpConnection.setSourceAnchor(srcAnchor);
            tmpConnection.setTargetAnchor(targetAnchor);
            IConnectionHelper connPath = ConnectionHelperFactory.createFromRawData((RawPathData)request.getData(), (Connection)tmpConnection);
            ret.setPathData(GmPathDataExtractor.extractDataModel((IConnectionHelper)connPath));
            this.getLayer((Object)"Connection Layer").remove((IFigure)tmpConnection);
        }
        return ret;
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        super.eraseTargetConnectionFeedback(request);
        if (this.highlight != null) {
            IFigure feedbackLayer = this.getFeedbackLayer();
            feedbackLayer.remove(this.highlight);
            this.highlight = null;
        }
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest req) {
        if (!(req.getNewObject() instanceof ModelioLinkCreationContext)) {
            return null;
        }
        ModelioLinkCreationContext context = (ModelioLinkCreationContext)req.getNewObject();
        if (context.getElementToUnmask() == null) {
            IElement sourceElement = ((IGmLinkable)req.getSourceEditPart().getModel()).getRelatedIElement();
            IElement targetElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert((IStereotype)context.getStereotype());
            if (stereotypeExpert != null && !stereotypeExpert.canLink(sourceElement, targetElement, null)) {
                return null;
            }
            ICreationExpert linkExpert = CreationExpertRegistry.getExpert((Class)MetaModelExpert.getMetaclass((String)context.getMetaclass()));
            if (!linkExpert.canLink(sourceElement, targetElement, null)) {
                return null;
            }
        } else {
            IElement hostElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            if (hostElement == null || !hostElement.isValid() || !hostElement.equals((Object)LinkExpert.getTarget((IElement)context.getElementToUnmask()))) {
                return null;
            }
        }
        DefaultCreateLinkCommand startCommand = (DefaultCreateLinkCommand)req.getStartCommand();
        startCommand.setTarget((IGmLinkable)this.getHost().getModel());
        startCommand.setPath(this.createPathModel(req));
        return startCommand;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest req) {
        if (!(req.getNewObject() instanceof ModelioLinkCreationContext)) {
            return null;
        }
        ModelioLinkCreationContext context = (ModelioLinkCreationContext)req.getNewObject();
        if (context.getElementToUnmask() == null) {
            IElement sourceElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert((IStereotype)context.getStereotype());
            if (stereotypeExpert != null && !stereotypeExpert.canLinkFrom(sourceElement, null)) {
                return null;
            }
            ICreationExpert linkExpert = CreationExpertRegistry.getExpert((Class)MetaModelExpert.getMetaclass((String)context.getMetaclass()));
            if (!linkExpert.canLinkFrom(sourceElement, null)) {
                return null;
            }
        }
        DefaultCreateLinkCommand command = new DefaultCreateLinkCommand(context);
        command.setSource((IGmLinkable)this.getHost().getModel());
        req.setStartCommand((Command)command);
        return command;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest request) {
        return new BendpointConnectionRouter();
    }

    protected Command getReconnectSourceCommand(ReconnectRequest req) {
        IElement linkElement;
        IElement targetElement;
        IElement newSrcElement;
        ConnectionEditPart connectionEditPart;
        GmLink linkModel;
        NodeEditPart newSourceNodeEditPart = (NodeEditPart)req.getTarget();
        GmModel newSourceNodeModel = (GmModel)newSourceNodeEditPart.getModel();
        if (newSourceNodeModel != (linkModel = (GmLink)(connectionEditPart = req.getConnectionEditPart()).getModel()).getFrom() && !this.canLink(newSrcElement = newSourceNodeModel.getRelatedIElement(), targetElement = linkModel.getTo().getRelatedIElement(), linkElement = linkModel.getRelatedIElement())) {
            return null;
        }
        DefaultReconnectSourceCommand cmd = new DefaultReconnectSourceCommand(linkModel, (IGmLinkable)newSourceNodeEditPart.getModel());
        ConnectionAnchor srcAnchor = newSourceNodeEditPart.getSourceConnectionAnchor((Request)req);
        cmd.setAnchorModel(this.getAnchorModel(newSourceNodeEditPart, srcAnchor));
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest req) {
        ConnectionEditPart connectionEditPart;
        GmLink gmLink;
        NodeEditPart destEditPart = (NodeEditPart)req.getTarget();
        IGmLinkable newTargetNode = (IGmLinkable)destEditPart.getModel();
        if (newTargetNode != (gmLink = (GmLink)(connectionEditPart = req.getConnectionEditPart()).getModel()).getTo() && !this.canLink(gmLink.getFrom().getRelatedIElement(), newTargetNode.getRelatedIElement(), gmLink.getRelatedIElement())) {
            return null;
        }
        DefaultReconnectTargetCommand cmd = new DefaultReconnectTargetCommand(gmLink, newTargetNode);
        ConnectionAnchor targetAnchor = destEditPart.getTargetConnectionAnchor((Request)req);
        cmd.setAnchorModel(this.getAnchorModel(destEditPart, targetAnchor));
        return cmd;
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        if (!(request.getNewObject() instanceof ModelioLinkCreationContext)) {
            return;
        }
        if (request instanceof CreateBendedConnectionRequest) {
            CreateBendedConnectionRequest req = (CreateBendedConnectionRequest)request;
            this.getFeedbackHelper(request);
            ConnectionRouter router = this.getRouterRegistry().get((Object)req.getData().getRoutingMode());
            this.connectionFeedback.setConnectionRouter(router);
            ConnectionAnchor srcAnchor = this.getSourceConnectionAnchor((CreateConnectionRequest)req);
            this.connectionFeedback.setSourceAnchor(srcAnchor);
            ConnectionAnchor targetAnchor = this.getTargetConnectionAnchor((CreateConnectionRequest)req);
            if (targetAnchor == null) {
                this.dummyAnchor.setLocation(request.getLocation());
                targetAnchor = this.dummyAnchor;
            }
            this.connectionFeedback.setTargetAnchor(targetAnchor);
            IConnectionHelper connHelper = this.getUpdatedConnectionHelper(req, this.connectionFeedback);
            this.connectionFeedback.setRoutingConstraint(connHelper.getRoutingConstraint());
        } else {
            super.showCreationFeedback(request);
        }
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        Command c = this.getHost().getCommand((Request)request);
        FigureUtilities2.HighlightType hightlightType = FigureUtilities2.HighlightType.INFO;
        hightlightType = c == null ? FigureUtilities2.HighlightType.ERROR : (c.canExecute() ? FigureUtilities2.HighlightType.SUCCESS : FigureUtilities2.HighlightType.WARNING);
        if (this.highlight == null) {
            this.highlight = FigureUtilities2.createHighlightFigure((IFigure)this.getFeedbackLayer(), (IFigure)this.getHostFigure(), (FigureUtilities2.HighlightType)hightlightType);
            this.getFeedbackLayer().add(this.highlight);
        } else {
            FigureUtilities2.updateHighlightType((IFigure)this.highlight, (FigureUtilities2.HighlightType)hightlightType);
        }
    }

    private boolean canLink(IElement newSrcElement, IElement targetElement, IElement linkElement) {
        ICreationExpert linkExpert = CreationExpertRegistry.getExpert(linkElement.getClass());
        if (!linkExpert.canLink(newSrcElement, targetElement, null)) {
            return false;
        }
        if (linkElement instanceof IModelElement) {
            for (IStereotype s : ((IModelElement)linkElement).getExtension()) {
                ICreationExpert steExpert = CreationExpertRegistry.getExpert((IStereotype)s);
                if (steExpert == null || steExpert.canLink(newSrcElement, targetElement, null)) continue;
                return false;
            }
        }
        return true;
    }

    private Object getAnchorModel(NodeEditPart editpart, ConnectionAnchor anchor) {
        if (editpart instanceof IAnchorModelProvider) {
            return ((IAnchorModelProvider)editpart).createAnchorModel(anchor);
        }
        return null;
    }

    private EditPart getReconnectSourceTargetEditPart(ReconnectRequest request) {
        ConnectionEditPart reconnectedConnectionEP = request.getConnectionEditPart();
        GmLink gmLink = (GmLink)reconnectedConnectionEP.getModel();
        IGmLinkable newSrcNode = (IGmLinkable)this.getHost().getModel();
        IGmLinkable oldSrcNode = gmLink.getFrom();
        if (oldSrcNode == newSrcNode) {
            return this.getHost();
        }
        if (this.isLinkCycle(this.getHost(), reconnectedConnectionEP)) {
            return null;
        }
        IElement newSrcElement = newSrcNode.getRelatedIElement();
        IElement targetElement = gmLink.getTo().getRelatedIElement();
        IElement linkElement = gmLink.getRelatedIElement();
        if (newSrcElement == null || targetElement == null || linkElement == null) {
            return null;
        }
        if (this.isOpaque || this.canLink(newSrcElement, targetElement, linkElement)) {
            return this.getHost();
        }
        return null;
    }

    private EditPart getReconnectTargetTargetEditPart(ReconnectRequest request) {
        ConnectionEditPart reconnectedConnectionEP = request.getConnectionEditPart();
        GmLink gmLink = (GmLink)reconnectedConnectionEP.getModel();
        IGmLinkable newTargetNode = (IGmLinkable)this.getHost().getModel();
        IGmLinkable oldTargetNode = gmLink.getTo();
        if (oldTargetNode == newTargetNode) {
            return this.getHost();
        }
        if (this.isLinkCycle(this.getHost(), reconnectedConnectionEP)) {
            return null;
        }
        IElement newTargetElement = newTargetNode.getRelatedIElement();
        IElement srcElement = gmLink.getFrom().getRelatedIElement();
        IElement linkElement = gmLink.getRelatedIElement();
        if (newTargetElement == null || srcElement == null || linkElement == null) {
            return null;
        }
        if (this.isOpaque || this.canLink(srcElement, newTargetElement, linkElement)) {
            return this.getHost();
        }
        return null;
    }

    private ConnectionRouterRegistry getRouterRegistry() {
        return (ConnectionRouterRegistry)this.getHost().getViewer().getProperty("ConnectionRouterRegistry");
    }

    protected EditPart getTargetEditPartConnectionEnd(CreateConnectionRequest request) {
        if (!(request.getNewObject() instanceof ModelioLinkCreationContext)) {
            return null;
        }
        ModelioLinkCreationContext context = (ModelioLinkCreationContext)request.getNewObject();
        if (context.getElementToUnmask() == null) {
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert((IStereotype)context.getStereotype());
            ICreationExpert linkExpert = CreationExpertRegistry.getExpert((Class)MetaModelExpert.getMetaclass((String)context.getMetaclass()));
            IElement sourceElement = null;
            IElement targetElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            IGmLinkable sourceNode = (IGmLinkable)request.getSourceEditPart().getModel();
            if (sourceNode == null || (sourceElement = sourceNode.getRelatedIElement()) == null || targetElement == null || stereotypeExpert != null && !stereotypeExpert.canLink(sourceElement, targetElement, null) || !linkExpert.canLink(sourceElement, targetElement, null) && !this.isOpaque) {
                return null;
            }
        }
        return this.getHost();
    }

    protected EditPart getTargetEditPartConnectionStart(CreateConnectionRequest request) {
        if (!(request.getNewObject() instanceof ModelioLinkCreationContext)) {
            return null;
        }
        ModelioLinkCreationContext context = (ModelioLinkCreationContext)request.getNewObject();
        if (context.getElementToUnmask() == null) {
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert((IStereotype)context.getStereotype());
            ICreationExpert linkExpert = CreationExpertRegistry.getExpert((Class)MetaModelExpert.getMetaclass((String)context.getMetaclass()));
            IElement sourceElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            if (sourceElement == null) {
                return null;
            }
            if (this.isOpaque) {
                return this.getHost();
            }
            if (stereotypeExpert != null && !stereotypeExpert.canLinkFrom(sourceElement, null)) {
                return null;
            }
            if (!linkExpert.canLinkFrom(sourceElement, null)) {
                return null;
            }
        }
        return this.getHost();
    }

    private IConnectionHelper getUpdatedConnectionHelper(CreateBendedConnectionRequest req, Connection connection) {
        IConnectionHelper connHelper = (IConnectionHelper)req.getExtendedData().get(IConnectionHelper.class);
        if (connHelper == null || connHelper.getRoutingMode() != req.getData().getRoutingMode()) {
            connHelper = ConnectionHelperFactory.createFromRawData((RawPathData)req.getData(), (Connection)connection);
            req.getExtendedData().put(IConnectionHelper.class, connHelper);
        } else {
            connHelper.updateFrom(req.getData());
        }
        return connHelper;
    }

    private boolean isLinkCycle(EditPart testedEditPart, ConnectionEditPart reconnectedConnectionEP) {
        if (testedEditPart.equals(reconnectedConnectionEP)) {
            return true;
        }
        if (testedEditPart instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEP = (ConnectionEditPart)testedEditPart;
            return this.isLinkCycle(connectionEP.getSource(), reconnectedConnectionEP) || this.isLinkCycle(connectionEP.getTarget(), reconnectedConnectionEP);
        }
        return false;
    }
}

