/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import org.eclipse.gef.commands.Command;

public class DefaultReconnectSourceCommand
extends Command {
    private final GmLink gmLink;
    private final IGmLinkable newSrcNode;
    private Object anchorModel;

    public DefaultReconnectSourceCommand(GmLink gmLink, IGmLinkable dest) {
        this.gmLink = gmLink;
        this.newSrcNode = dest;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.gmLink.getDiagram())) {
            return false;
        }
        IGmLinkable oldSrcNode = this.gmLink.getFrom();
        if (oldSrcNode == null) {
            return true;
        }
        if (this.newSrcNode.getRepresentedRef().equals((Object)oldSrcNode.getRepresentedRef())) {
            return true;
        }
        return this.isModifableElement(oldSrcNode) && this.isModifableElement(this.newSrcNode) && this.isModifableElement((IGmLinkable)this.gmLink);
    }

    public void execute() {
        this.updateLinkSource();
        if (this.anchorModel != null) {
            this.gmLink.getPath().setSourceAnchor(this.anchorModel);
            this.gmLink.setLayoutData((Object)new GmPath(this.gmLink.getPath()));
        }
    }

    public void setAnchorModel(Object anchorModel) {
        this.anchorModel = anchorModel;
    }

    protected void updateLinkSource() {
        IGmLinkable oldSourceNode = this.gmLink.getFrom();
        if (oldSourceNode != this.newSrcNode) {
            IElement link = this.gmLink.getRelatedIElement();
            IElement newSource = this.newSrcNode.getRelatedIElement();
            if (oldSourceNode != null) {
                IElement oldSource = oldSourceNode.getRelatedIElement();
                if (!newSource.equals((Object)oldSource)) {
                    LinkServices.changeSource((IElement)link, (IElement)oldSource, (IElement)newSource);
                }
                oldSourceNode.removeStartingLink((IGmLink)this.gmLink);
            } else {
                LinkServices.changeSource((IElement)link, null, (IElement)newSource);
            }
            this.newSrcNode.addStartingLink((IGmLink)this.gmLink);
        }
    }

    private boolean isModifableElement(IGmLinkable model) {
        IElement relatedIElement = model.getRelatedIElement();
        if (relatedIElement != null && relatedIElement.isValid()) {
            return relatedIElement.getElementStatus().isModifiable();
        }
        return true;
    }
}

