/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import org.eclipse.gef.commands.Command;

public class DefaultReconnectTargetCommand
extends Command {
    private Object anchorModel;
    private final GmLink gmLink;
    private final IGmLinkable newTargetNode;

    public DefaultReconnectTargetCommand(GmLink gmLink, IGmLinkable newTarget) {
        this.gmLink = gmLink;
        this.newTargetNode = newTarget;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.gmLink.getDiagram())) {
            return false;
        }
        IGmLinkable oldTargetNode = this.gmLink.getTo();
        if (oldTargetNode == null) {
            return true;
        }
        if (this.newTargetNode.getRepresentedRef().equals((Object)oldTargetNode.getRepresentedRef())) {
            return true;
        }
        return this.isModifableElement(oldTargetNode) && this.isModifableElement((IGmLinkable)this.gmLink);
    }

    public void execute() {
        this.updateLinkTarget();
        if (this.anchorModel != null) {
            this.gmLink.getPath().setTargetAnchor(this.anchorModel);
            this.gmLink.setLayoutData((Object)new GmPath(this.gmLink.getPath()));
        }
    }

    public void setAnchorModel(Object anchorModel) {
        this.anchorModel = anchorModel;
    }

    protected void updateLinkTarget() {
        IGmLinkable oldTargetNode = this.gmLink.getTo();
        if (oldTargetNode != this.newTargetNode) {
            IElement link = this.gmLink.getRelatedIElement();
            IElement newDest = this.newTargetNode.getRelatedIElement();
            if (oldTargetNode != null) {
                IElement oldDest = oldTargetNode.getRelatedIElement();
                if (!newDest.equals((Object)oldDest)) {
                    LinkServices.changeTarget((IElement)link, (IElement)oldDest, (IElement)newDest);
                }
                oldTargetNode.removeEndingLink((IGmLink)this.gmLink);
            } else {
                LinkServices.changeTarget((IElement)link, null, (IElement)newDest);
            }
            this.newTargetNode.addEndingLink((IGmLink)this.gmLink);
        }
    }

    private boolean isModifableElement(IGmLinkable model) {
        IElement relatedIElement = model.getRelatedIElement();
        if (relatedIElement != null && relatedIElement.isValid()) {
            return relatedIElement.getElementStatus().isModifiable();
        }
        return true;
    }
}

