/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public abstract class GmAbstractLinkAnchor
implements IPersistent {
    private Dimension location;
    private Collection<GmLink> links = new ArrayList(1);
    private static final int MAJOR_VERSION = 0;

    public GmAbstractLinkAnchor(Dimension location) {
        this.location = location;
    }

    public GmAbstractLinkAnchor() {
    }

    public Dimension getLocation() {
        return this.location;
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public void read(IDiagramReader in) {
        Object o = in.readProperty("location");
        if (o instanceof Point) {
            Point readPoint = (Point)o;
            this.location = new Dimension(readPoint.x, readPoint.y);
        } else {
            this.location = (Dimension)o;
        }
    }

    public void setLocation(Dimension location) {
        this.location = location;
        for (GmLink l : this.links) {
            l.fireAnchorMoved(this);
        }
    }

    public void write(IDiagramWriter out) {
        out.writeProperty("location", this.location);
    }

    void addLink(GmLink l) {
        this.links.add(l);
    }

    void removeLink(GmLink l) {
        this.links.remove(l);
    }

    public int getMajorVersion() {
        return 0;
    }
}

