/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.link.GmAbstractLinkAnchor;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmConnectionEndpoinLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmFractionalConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.IGmLocator;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class GmLink
extends GmModel
implements IGmLink {
    protected IGmLinkable from;
    protected IGmLinkable to;
    private Map<GmNodeModel, IGmLocator> extensions = new HashMap();
    private final List<IGmLink> startingLinks = new ArrayList();
    private final List<IGmLink> endingLinks = new ArrayList();
    public static final String PROP_SOURCE_GM = "Source graphic model changed";
    public static final String PROP_TARGET_GM = "Target graphic model changed";
    public static final String PROP_SOURCE_EL = "Source element model changed";
    public static final String PROP_TARGET_EL = "Target element model changed";
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmLink(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.from = null;
        this.to = null;
        this.init();
    }

    public GmLink() {
        this.init();
    }

    public final void addEndingLink(IGmLink link) {
        this.endingLinks.add(link);
        link.setTo((IGmLinkable)this);
        this.firePropertyChange("Link target", null, (Object)link);
    }

    public void addExtension(GmNodeModel extension, IGmLocator constraint) {
        this.extensions.put(extension, constraint);
        extension.setParentLink(this);
        this.firePropertyChange("Children", null, (Object)extension);
    }

    public void addExtension(String key, GmNodeModel extension) {
        if (key.equals("sourceNW")) {
            GmConnectionEndpoinLocator constraint = new GmConnectionEndpoinLocator();
            constraint.setEnd(false);
            constraint.setVDistance(-5);
            constraint.setUDistance(5);
            this.extensions.put(extension, constraint);
        } else if (key.equals("SourceSE")) {
            GmConnectionEndpoinLocator constraint = new GmConnectionEndpoinLocator();
            constraint.setEnd(false);
            constraint.setVDistance(5);
            constraint.setUDistance(5);
            this.extensions.put(extension, constraint);
        } else if (key.equals("TargetNW")) {
            GmConnectionEndpoinLocator constraint = new GmConnectionEndpoinLocator();
            constraint.setEnd(true);
            constraint.setVDistance(-5);
            constraint.setUDistance(5);
            this.extensions.put(extension, constraint);
        } else if (key.equals("TargetSE")) {
            GmConnectionEndpoinLocator constraint = new GmConnectionEndpoinLocator();
            constraint.setEnd(true);
            constraint.setVDistance(5);
            constraint.setUDistance(5);
            this.extensions.put(extension, constraint);
        } else if (key.equals("MiddleSE")) {
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator();
            constraint.setFraction(0.5);
            constraint.setUDistance(0);
            constraint.setVDistance(-20);
            this.extensions.put(extension, constraint);
        } else if (key.equals("MiddleNW")) {
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator();
            constraint.setFraction(0.5);
            constraint.setUDistance(0);
            constraint.setVDistance(20);
            this.extensions.put(extension, constraint);
        } else if (key.equals("OnSourceThird")) {
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator();
            constraint.setFraction(0.25);
            constraint.setUDistance(0);
            constraint.setVDistance(0);
            this.extensions.put(extension, constraint);
        } else if (key.equals("OnTargetThird")) {
            GmFractionalConnectionLocator constraint = new GmFractionalConnectionLocator();
            constraint.setFraction(0.75);
            constraint.setUDistance(0);
            constraint.setVDistance(0);
            this.extensions.put(extension, constraint);
        } else {
            throw new IllegalArgumentException("'" + extension + "' is not supproted");
        }
        extension.setParentLink(this);
        this.firePropertyChange("Children", null, (Object)this.getRelatedIElement().getName());
    }

    public final void addStartingLink(IGmLink link) {
        this.startingLinks.add(link);
        link.setFrom((IGmLinkable)this);
        this.firePropertyChange("Link source", null, (Object)link);
    }

    public boolean canCreate(Class<? extends IElement> type) {
        return false;
    }

    public boolean canUnmask(IElement el) {
        return false;
    }

    public void delete() {
        for (IGmLink l : new ArrayList(this.startingLinks)) {
            l.delete();
        }
        for (IGmLink l : new ArrayList(this.endingLinks)) {
            l.delete();
        }
        for (GmNodeModel extension : new ArrayList(this.extensions.keySet())) {
            extension.delete();
        }
        if (this.from != null) {
            this.from.removeStartingLink((IGmLink)this);
            this.from = null;
        }
        if (this.to != null) {
            this.to.removeEndingLink((IGmLink)this);
            this.to = null;
        }
        super.delete();
    }

    public final void fireChildVisibilityChanged(GmNodeModel child) {
        this.firePropertyChange("Children", null, (Object)child);
    }

    public final void firePathChanged(IGmPath path) {
        this.firePropertyChange("LayoutData", null, (Object)path);
    }

    public final List<IGmLink> getEndingLinks() {
        return this.endingLinks;
    }

    public final Collection<GmNodeModel> getExtensions() {
        return this.extensions.keySet();
    }

    public final IGmLinkable getFrom() {
        return this.from;
    }

    public abstract IElement getFromElement();

    public final IGmLocator getLayoutContraint(IGmObject extension) {
        return (IGmLocator)this.extensions.get(extension);
    }

    public final GmModel getParent() {
        return null;
    }

    public final IGmPath getPath() {
        return (IGmPath)this.getLayoutData();
    }

    public StyleKey.RepresentationMode getRepresentationMode() {
        return StyleKey.RepresentationMode.STRUCTURED;
    }

    public final Object getSourceAnchor() {
        return this.getPath().getSourceAnchor();
    }

    public final List<IGmLink> getStartingLinks() {
        return this.startingLinks;
    }

    public final Object getTargetAnchor() {
        return this.getPath().getTargetAnchor();
    }

    public final IGmLinkable getTo() {
        return this.to;
    }

    public abstract IElement getToElement();

    public Collection<GmNodeModel> getVisibleExtensions() {
        Collection allExtensions = this.getExtensions();
        ArrayList<GmNodeModel> ret = new ArrayList<GmNodeModel>(allExtensions.size());
        for (GmNodeModel childNode : allExtensions) {
            if (!childNode.isVisible()) continue;
            ret.add(childNode);
        }
        return ret;
    }

    public void obElementAdded(IElement addedEl) {
        super.obElementAdded(addedEl);
        for (GmNodeModel m : this.getExtensions()) {
            if (m.getRepresentedIElement() != null) continue;
            m.obElementAdded(addedEl);
        }
    }

    public void obElementResolved(IElement ev) {
        super.obElementResolved(ev);
        for (GmNodeModel m : this.getExtensions()) {
            if (m.getRepresentedIElement() != null) continue;
            m.obElementResolved(ev);
        }
    }

    public final void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmLink.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public final void removeEndingLink(IGmLink gmLink) {
        this.endingLinks.remove(gmLink);
        gmLink.setTo(null);
        this.firePropertyChange("Link target", (Object)gmLink, null);
    }

    public void removeExtension(GmNodeModel gmNodeModel) throws IllegalArgumentException {
        assert (this.extensions.containsKey(gmNodeModel));
        this.extensions.remove(gmNodeModel);
        this.firePropertyChange("Children", (Object)gmNodeModel, null);
        gmNodeModel.setParentLink(null);
    }

    public final void removeStartingLink(IGmLink gmLink) {
        this.startingLinks.remove(gmLink);
        gmLink.setFrom(null);
        this.firePropertyChange("Link source", (Object)gmLink, null);
    }

    public void setFrom(IGmLinkable from) {
        if (from != this.from) {
            IGmLinkable oldFrom = this.from;
            this.from = from;
            this.firePropertyChange(PROP_SOURCE_GM, (Object)oldFrom, (Object)from);
        }
    }

    public final void setLayoutConstraint(GmNodeModel extension, IGmLocator layoutData) {
        this.extensions.put(extension, layoutData);
        this.firePropertyChange("LayoutData", (Object)extension, (Object)layoutData);
    }

    public final void setLayoutData(Object layoutData) {
        IGmPath oldPath = this.getPath();
        IGmPath newPath = (IGmPath)layoutData;
        if (newPath != null && this.getStyle() != null) {
            if (newPath.getRouterKind() == null) {
                newPath.setRouterKind(this.getRouterFromStyle(this.getStyle()));
            } else {
                this.getPath().setRouterKind(newPath.getRouterKind());
                StyleKey routerStyleKey = this.getStyleKey(MetaKey.CONNECTIONROUTER);
                if (routerStyleKey != null && this.getStyle().getProperty(routerStyleKey) != newPath.getRouterKind()) {
                    this.getStyle().setProperty(routerStyleKey, (Object)newPath.getRouterKind());
                }
            }
        }
        Object oldSrcAnchor = null;
        Object oldDestAnchor = null;
        if (oldPath != null) {
            oldSrcAnchor = oldPath.getSourceAnchor();
            oldDestAnchor = oldPath.getTargetAnchor();
            if (oldSrcAnchor instanceof GmAbstractLinkAnchor) {
                ((GmAbstractLinkAnchor)oldSrcAnchor).removeLink(this);
            }
            if (oldDestAnchor instanceof GmAbstractLinkAnchor) {
                ((GmAbstractLinkAnchor)oldDestAnchor).removeLink(this);
            }
        }
        if (newPath != null) {
            Object newSrcAnchor = newPath.getSourceAnchor();
            Object newDestAnchor = newPath.getTargetAnchor();
            if (newSrcAnchor instanceof GmAbstractLinkAnchor && newSrcAnchor != oldSrcAnchor) {
                ((GmAbstractLinkAnchor)newSrcAnchor).addLink(this);
            }
            if (newDestAnchor instanceof GmAbstractLinkAnchor && newDestAnchor != oldDestAnchor) {
                ((GmAbstractLinkAnchor)newDestAnchor).addLink(this);
            }
        }
        super.setLayoutData(layoutData);
    }

    @Deprecated
    public final void setSourceAnchor(GmAbstractLinkAnchor newAnchor) {
        GmPath path = new GmPath(this.getPath());
        path.setSourceAnchor((Object)newAnchor);
        this.setLayoutData((Object)path);
    }

    @Deprecated
    public final void setTargetAnchor(GmAbstractLinkAnchor newAnchor) {
        GmPath path = new GmPath(this.getPath());
        path.setTargetAnchor((Object)newAnchor);
        this.setLayoutData((Object)path);
    }

    public void setTo(IGmLinkable to) {
        this.to = to;
        if (to != this.to) {
            IGmLinkable oldTo = this.to;
            this.to = to;
            this.firePropertyChange(PROP_SOURCE_GM, (Object)oldTo, (Object)to);
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        assert (this.from != null && this.to != null) : "this.from == null || this.to == null";
        out.writeProperty("Source", (IPersistent)this.from);
        out.writeProperty("Dest", (IPersistent)this.to);
        out.writeProperty("extensions", this.extensions);
        if (false) {
            out.writeProperty("GmLink.version", (Object)0);
        }
    }

    final void fireAnchorMoved(GmAbstractLinkAnchor gmLinkAnchor) {
        this.firePropertyChange("LayoutData", null, (Object)gmLinkAnchor);
    }

    final StyleKey.ConnectionRouterId getRouterFromStyle(IStyle style) {
        StyleKey routerStyleKey = this.getStyleKey(MetaKey.CONNECTIONROUTER);
        if (routerStyleKey != null) {
            StyleKey.ConnectionRouterId newRouter = (StyleKey.ConnectionRouterId)style.getProperty(routerStyleKey);
            return newRouter;
        }
        return StyleKey.ConnectionRouterId.DIRECT;
    }

    protected final boolean areEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    protected void readLink(IDiagramReader in) {
    }

    protected void refreshFromObModel() {
        IElement relatedIElement = this.getRelatedIElement();
        if (relatedIElement != null && relatedIElement.isValid()) {
            IElement modelTargetElement;
            IElement modelSourceElement;
            IElement graphicSourceElement = this.getFromElement();
            if (this.getFrom() == null) {
                this.firePropertyChange(PROP_SOURCE_EL, null, (Object)graphicSourceElement);
            } else if (this.getFrom() instanceof GmModel && !this.areEqual((Object)(modelSourceElement = ((GmModel)this.getFrom()).getRelatedIElement()), (Object)graphicSourceElement)) {
                this.firePropertyChange(PROP_SOURCE_EL, (Object)modelSourceElement, (Object)graphicSourceElement);
            }
            IElement graphicTargetElement = this.getToElement();
            if (this.getTo() == null) {
                this.firePropertyChange(PROP_TARGET_EL, null, (Object)graphicTargetElement);
            } else if (this.getTo() instanceof GmModel && !this.areEqual((Object)(modelTargetElement = ((GmModel)this.getTo()).getRelatedIElement()), (Object)graphicTargetElement)) {
                this.firePropertyChange(PROP_TARGET_EL, (Object)modelTargetElement, (Object)graphicTargetElement);
            }
        }
    }

    private void init() {
        GmPath path = new GmPath();
        path.setPathData(new ArrayList());
        this.setLayoutData((Object)path);
    }

    private final void read_0(IDiagramReader in) {
        Object targetAnchor;
        super.read(in);
        this.from = (IGmLinkable)in.readProperty("Source");
        this.to = (IGmLinkable)in.readProperty("Dest");
        this.extensions = in.readMapProperty("extensions");
        Object sourceAnchor = this.getPath().getSourceAnchor();
        if (sourceAnchor instanceof GmAbstractLinkAnchor) {
            ((GmAbstractLinkAnchor)sourceAnchor).addLink(this);
        }
        if ((targetAnchor = this.getPath().getTargetAnchor()) instanceof GmAbstractLinkAnchor) {
            ((GmAbstractLinkAnchor)targetAnchor).addLink(this);
        }
        this.readLink(in);
        for (GmNodeModel ext : this.extensions.keySet()) {
            ext.setParentLink(this);
        }
        if (this.from != null) {
            this.from.addStartingLink((IGmLink)this);
        }
        if (this.to != null) {
            this.to.addEndingLink((IGmLink)this);
        }
    }

    public int getMajorVersion() {
        return 0;
    }
}

