/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link;

import com.modeliosoft.modelio.diagram.elements.core.figures.LinkFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.PointListUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;

public class SelectConnectionEditPartTracker
extends SelectEditPartTracker {
    private final int MODIFIER_NO_SNAPPING = SWT.getPlatform().equals("carbon") ? 262144 : 65536;
    private Request sourceRequest;
    private int index = -1;
    private String type;
    private boolean bSourceFeedback = false;
    private PrecisionRectangle sourceRectangle;
    private Point originalLocation = null;
    private Collection<Object> exclusionSet;

    public SelectConnectionEditPartTracker(ConnectionEditPart owner) {
        super((EditPart)owner);
    }

    public void deactivate() {
        if (!this.isInState(0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
        }
        this.sourceRequest = null;
        super.deactivate();
    }

    protected final void setIndex(int i) {
        this.index = i;
    }

    protected final void setType(String type) {
        this.type = type;
    }

    protected Cursor calculateCursor() {
        if (this.getType() == "move bendpoint") {
            return Cursors.SIZEALL;
        }
        return this.getConnection().getCursor();
    }

    protected final List<EditPart> createOperationSet() {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        list.add((EditPart)this.getConnectionEditPart());
        return list;
    }

    protected Request createSourceRequest() {
        String t = this.getType();
        if (t.equals("create bendpoint") || t.equals("move bendpoint")) {
            BendpointRequest request = new BendpointRequest();
            request.setType((Object)this.getType());
            request.setIndex(this.getIndex());
            request.setSource((ConnectionEditPart)this.getSourceEditPart());
            return request;
        }
        if (t.equals("Reconnection source") || t.equals("Reconnection target")) {
            ReconnectRequest req = new ReconnectRequest();
            req.setConnectionEditPart(this.getConnectionEditPart());
            req.setType((Object)t);
            return req;
        }
        throw new IllegalStateException("Unknow request type:" + t);
    }

    protected final String getCommandName() {
        return this.getType();
    }

    protected final Command getCommand() {
        Request r = this.getSourceRequest();
        if (r instanceof TargetRequest) {
            if (this.getTargetEditPart() != null) {
                return this.getTargetEditPart().getCommand(r);
            }
            return null;
        }
        return this.getSourceEditPart().getCommand(r);
    }

    protected String getDebugName() {
        return "Bendpoint Handle Tracker " + this.getCommandName();
    }

    protected final int getIndex() {
        return this.index;
    }

    protected final String getType() {
        return this.type;
    }

    protected final boolean handleButtonDown(int button) {
        if (!super.handleButtonDown(button)) {
            return false;
        }
        LinkFigure connection = this.getConnection();
        Point p = this.getLocation();
        connection.translateToRelative((Translatable)p);
        PointList points = connection.getPoints();
        if (connection.getSourceDecoration() != null && connection.getSourceDecoration().containsPoint(p)) {
            this.handleButtonDownOnSource(button);
        } else if (connection.getTargetDecoration() != null && connection.getTargetDecoration().containsPoint(p)) {
            this.handleButtonDownOnTarget(button);
        } else {
            Dimension size = new Dimension(9, 9);
            connection.translateToRelative((Translatable)size);
            int i = 0;
            while (i < points.size()) {
                Point ptCenter = points.getPoint(i);
                Rectangle rect = new Rectangle(ptCenter.x - size.width / 2, ptCenter.y - size.height / 2, size.width, size.height);
                if (rect.contains(p)) {
                    if (i == 0) {
                        this.handleButtonDownOnSource(button);
                    } else if (i == points.size() - 1) {
                        this.handleButtonDownOnTarget(button);
                    } else {
                        this.handleButtonDownOnBendpoint(button, i, points);
                    }
                }
                ++i;
            }
            if (this.getIndex() == -1) {
                this.setIndex(PointListUtilities.findNearestLineSegIndexOfPoint((PointList)connection.getPoints(), (Point)new Point(p.x, p.y)));
                this.setIndex(this.getIndex() - 1);
                this.setType("create bendpoint");
            }
        }
        return true;
    }

    protected final boolean handleButtonUp(int button) {
        boolean bExecuteDrag = this.isInState(4) && this.shouldAllowDrag();
        boolean bRet = super.handleButtonUp(button);
        if (bExecuteDrag) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.setCurrentCommand(this.getCommand());
            this.executeCurrentCommand();
        }
        return bRet;
    }

    protected final boolean handleDragInProgress() {
        if (this.isInState(4) && this.shouldAllowDrag()) {
            this.updateSourceRequest();
            if (this.getSourceRequest() instanceof TargetRequest) {
                this.updateTargetUnderMouse();
                this.showTargetFeedback();
            }
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected final boolean handleDragStarted() {
        this.originalLocation = null;
        this.sourceRectangle = null;
        return this.stateTransition(2, 4);
    }

    protected final boolean shouldAllowDrag() {
        return this.getIndex() != -1;
    }

    protected final void updateSourceRequest() {
        LocationRequest request = (LocationRequest)this.getSourceRequest();
        if (this.originalLocation == null) {
            this.originalLocation = this.getStartLocation().getCopy();
        }
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        SnapToHelper snapToHelper = (SnapToHelper)this.getConnectionEditPart().getAdapter(SnapToHelper.class);
        Rectangle rect = new Rectangle(this.originalLocation.x, this.originalLocation.y, 1, 1);
        if (this.sourceRectangle == null) {
            this.sourceRectangle = new PrecisionRectangle(rect);
        }
        if (snapToHelper != null && !this.getCurrentInput().isModKeyDown(this.MODIFIER_NO_SNAPPING)) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            baseRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            Point newLocation = this.originalLocation.getCopy().translate((Point)preciseDelta);
            request.setLocation(newLocation);
        } else {
            request.setLocation(this.getLocation());
        }
    }

    private void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        this.setShowingFeedback(false);
        List editParts = this.getOperationSet();
        for (EditPart editPart : editParts) {
            editPart.eraseSourceFeedback(this.getSourceRequest());
        }
    }

    protected final ConnectionEditPart getConnectionEditPart() {
        return (ConnectionEditPart)this.getSourceEditPart();
    }

    protected final LinkFigure getConnection() {
        return (LinkFigure)this.getConnectionEditPart().getFigure();
    }

    private Request getSourceRequest() {
        if (this.sourceRequest == null) {
            this.sourceRequest = this.createSourceRequest();
        }
        return this.sourceRequest;
    }

    private boolean isShowingFeedback() {
        return this.bSourceFeedback;
    }

    private void setShowingFeedback(boolean bSet) {
        this.bSourceFeedback = bSet;
    }

    private void showSourceFeedback() {
        for (Object o : this.getOperationSet()) {
            EditPart editPart = (EditPart)o;
            editPart.showSourceFeedback(this.getSourceRequest());
        }
        this.setShowingFeedback(true);
    }

    protected void handleButtonDownOnBendpoint(int button, int pointIndex, PointList points) {
        if (pointIndex == 0) {
            this.setType("Reconnection source");
            this.setIndex(pointIndex);
        } else if (pointIndex == points.size() - 1) {
            this.setType("Reconnection target");
            this.setIndex(pointIndex);
        } else {
            this.setType("move bendpoint");
            this.setIndex(pointIndex - 1);
        }
    }

    protected void handleButtonDownOnSource(int button) {
        this.setType("Reconnection source");
        this.setIndex(0);
    }

    protected void handleButtonDownOnTarget(int button) {
        this.setType("Reconnection target");
        this.setIndex(0);
    }

    protected final Request getTargetRequest() {
        return this.getSourceRequest();
    }

    protected final Collection getExclusionSet() {
        if (this.exclusionSet == null) {
            this.exclusionSet = new ArrayList();
            this.exclusionSet.add(this.getConnection());
        }
        return this.exclusionSet;
    }
}

