/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.extensions;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class FractionalConnectionLocator
implements Locator {
    private double fraction;
    private static final Point P1 = new Point();
    private static final Point P2 = new Point();
    private static final float BIGSLOPE = 9999.0f;
    private Connection connection;
    private int uDistance;
    private int vDistance;
    private boolean towardTarget;

    public static FractionalConnectionLocator createFromXyPoint(Connection c, double fraction, Point figLocation, boolean towardTarget) {
        FractionalConnectionLocator ret = new FractionalConnectionLocator(c, fraction);
        Point center = new Point();
        Point previousPoint = new Point();
        ret.setTowardTarget(towardTarget);
        ret.getReferenceSegment(c.getPoints(), center, previousPoint);
        Dimension xy = figLocation.getDifference(center);
        Dimension segDiff = center.getDifference(previousPoint);
        double dist = previousPoint.getDistance(center);
        double cost = (double)segDiff.width / dist;
        double sint = (double)segDiff.height / dist;
        ret.setUDistance((int)((double)xy.width * cost + (double)xy.height * sint));
        ret.setVDistance((int)((double)(-xy.width) * sint + (double)xy.height * cost));
        return ret;
    }

    public FractionalConnectionLocator(Connection c, double fraction) {
        this.connection = c;
        if (fraction > 1.0 || fraction < 0.0) {
            throw new IllegalArgumentException("fraction must be 0.0 < f < 1.0");
        }
        this.fraction = fraction;
    }

    public double getFraction() {
        return this.fraction;
    }

    public Point getLocation(IFigure target) {
        Connection conn = this.getConnection();
        Point center = new Point();
        Point previousPoint = new Point();
        this.getReferenceSegment(conn.getPoints(), center, previousPoint);
        Dimension t = this.getUvTranslation(previousPoint, center);
        center.translate(t);
        conn.translateToAbsolute((Translatable)center);
        target.translateToRelative((Translatable)center);
        return center;
    }

    public void getReferenceSegment(PointList points, Point center, Point previous) {
        long theLength = this.length(points);
        long remainingLength = Math.round(this.getFraction() * (double)theLength);
        int n = points.size() - 1;
        int i = 0;
        while (i < n) {
            points.getPoint(P1, i);
            points.getPoint(P2, i + 1);
            long nextLength = Math.round(P2.getDistance(P1));
            if (nextLength >= remainingLength) {
                this.pointOn(remainingLength, P1, P2, center);
                if (this.towardTarget) {
                    previous.setLocation(P1);
                } else {
                    previous.setLocation(P2);
                }
                return;
            }
            remainingLength -= nextLength;
            ++i;
        }
        throw new IllegalStateException("Failed to compute location");
    }

    public int getUDistance() {
        return this.uDistance;
    }

    public int getVDistance() {
        return this.vDistance;
    }

    public boolean isTowardTarget() {
        return this.towardTarget;
    }

    public void relocate(IFigure target) {
        Connection conn = this.getConnection();
        Point center = new Point();
        Point fromPoint = new Point();
        this.getReferenceSegment(conn.getPoints(), center, fromPoint);
        Dimension t = this.getUvTranslation(fromPoint, center);
        center.translate(t);
        fromPoint.translate(t);
        if (target instanceof RotatableDecoration) {
            RotatableDecoration rot = (RotatableDecoration)target;
            conn.translateToAbsolute((Translatable)center);
            target.translateToRelative((Translatable)center);
            conn.translateToAbsolute((Translatable)fromPoint);
            target.translateToRelative((Translatable)fromPoint);
            rot.setLocation(center);
            rot.setReferencePoint(fromPoint);
        } else {
            Dimension prefSize = target.getPreferredSize();
            conn.translateToAbsolute((Translatable)center);
            target.translateToRelative((Translatable)center);
            target.setBounds(this.getNewBounds(prefSize, center));
        }
    }

    public void setTowardTarget(boolean towardTarget) {
        this.towardTarget = towardTarget;
    }

    public void setUDistance(int uDistance) {
        this.uDistance = uDistance;
    }

    public void setVDistance(int vDistance) {
        this.vDistance = vDistance;
    }

    public final float slope(Point start, Point end) {
        if (end.x == start.x) {
            return 9999.0f;
        }
        return (float)(end.y - start.y) / (float)(end.x - start.x);
    }

    protected Rectangle getNewBounds(Dimension size, Point center) {
        Rectangle bounds = new Rectangle(center, size);
        bounds.x -= bounds.width / 2;
        bounds.y -= bounds.height / 2;
        return bounds;
    }

    protected Point getReferencePoint() {
        Point center = new Point();
        Point directionPoint = new Point();
        this.getReferenceSegment(this.getConnection().getPoints(), center, directionPoint);
        this.getConnection().translateToAbsolute((Translatable)center);
        return center;
    }

    private Connection getConnection() {
        return this.connection;
    }

    private Dimension getUvTranslation(Point origin, Point direction) {
        Dimension diff = direction.getDifference(origin);
        double dist = origin.getDistance(direction);
        double cost = (double)diff.width / dist;
        double sint = (double)diff.height / dist;
        double u = (double)this.uDistance * cost - (double)this.vDistance * sint;
        double v = (double)this.uDistance * sint + (double)this.vDistance * cost;
        return new Dimension((int)u, (int)v);
    }

    private long length(PointList points) {
        long ret = 0L;
        int n = points.size() - 1;
        int i = 0;
        while (i < n) {
            points.getPoint(P1, i);
            points.getPoint(P2, i + 1);
            ret += Math.round(P2.getDistance(P1));
            ++i;
        }
        return ret;
    }

    private boolean pointOn(long theDistance, Point start, Point end, Point ptResult) {
        boolean in_line;
        int startX = 0;
        int startY = 0;
        int otherX = 0;
        int otherY = 0;
        startX = start.x;
        startY = start.y;
        otherX = end.x;
        otherY = end.y;
        float m = this.slope(start, end);
        double d_squared = (float)theDistance * (float)theDistance;
        double m_squared = m * m;
        float dx_float = (float)Math.sqrt(d_squared / (m_squared + 1.0));
        int dx = (int)((double)dx_float + 0.5);
        int dy = (int)(Math.sqrt(d_squared * m_squared / (m_squared + 1.0)) + 0.5);
        if (theDistance < 0L) {
            dx = -dx;
            dy = -dy;
        }
        ptResult.x = startX > otherX ? startX - dx : startX + dx;
        int n = ptResult.y = startY > otherY ? startY - dy : startY + dy;
        if (startX > otherX) {
            in_line = ptResult.x >= otherX;
        } else {
            boolean bl = in_line = ptResult.x <= otherX;
        }
        if (in_line) {
            in_line = startY > otherY ? ptResult.y >= otherY : ptResult.y <= otherY;
        }
        return in_line;
    }
}

