/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.extensions;

import com.modeliosoft.modelio.diagram.elements.core.link.extensions.FractionalConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmConnectionEndpoinLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.GmFractionalConnectionLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.IGmLocator;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.LocatorFactory;
import com.modeliosoft.modelio.diagram.elements.core.link.extensions.SidedConnectionEndpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class LocatorFactory {
    private static LocatorFactory instance = new LocatorFactory();
    private SidedConnectionEndpointLocatorFactory sidedConnectionEndpointLocatorFactory = new SidedConnectionEndpointLocatorFactory();

    public static LocatorFactory getInstance() {
        return instance;
    }

    public SidedConnectionEndpointLocator getLocator(Connection conn, IFigure extension, Dimension moveDelta, Point mouseLocation) {
        return this.sidedConnectionEndpointLocatorFactory.getLocator(conn, extension, moveDelta, mouseLocation);
    }

    public Locator getLocator(Connection connection, IGmLocator layoutContraint) {
        if (layoutContraint == null) {
            return null;
        }
        if (layoutContraint instanceof GmFractionalConnectionLocator) {
            return this.getLocator(connection, (GmFractionalConnectionLocator)layoutContraint);
        }
        if (layoutContraint instanceof GmConnectionLocator) {
            return this.getLocator(connection, (GmConnectionLocator)layoutContraint);
        }
        if (layoutContraint instanceof GmConnectionEndpoinLocator) {
            return this.getLocator(connection, (GmConnectionEndpoinLocator)layoutContraint);
        }
        throw new IllegalArgumentException(String.valueOf(layoutContraint.toString()) + " not supported.");
    }

    private Locator getLocator(Connection conn, GmFractionalConnectionLocator gmLoc) {
        FractionalConnectionLocator ret = new FractionalConnectionLocator(conn, gmLoc.getFraction());
        ret.setUDistance(gmLoc.getUDistance());
        ret.setVDistance(gmLoc.getVDistance());
        ret.setTowardTarget(gmLoc.isTowardTarget());
        return ret;
    }

    private SidedConnectionEndpointLocator getLocator(Connection conn, GmConnectionEndpoinLocator gmLoc) {
        SidedConnectionEndpointLocator ret = new SidedConnectionEndpointLocator(conn, gmLoc.isEnd());
        ret.setUDistance(gmLoc.getUDistance());
        ret.setVDistance(gmLoc.getVDistance());
        return ret;
    }

    private ConnectionLocator getLocator(Connection conn, GmConnectionLocator gmLoc) {
        ConnectionLocator ret = new ConnectionLocator(conn, gmLoc.getAlignment());
        ret.setGap(gmLoc.getGap());
        ret.setRelativePosition(gmLoc.getRelativePosition());
        return ret;
    }
}

