/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.ortho;

import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.IAnchorModelProvider;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.HandleBounds;

public class ChangeLinkRoutingConstraintCommand
extends Command {
    private IGmPath path;
    private List<Bendpoint> routingConstraint;
    private Object sourceAnchorModel;
    private Object targetAnchorModel;
    private GmLink model;
    private Connection connection;

    public ChangeLinkRoutingConstraintCommand(IGmPath path, ConnectionEditPart connectionEP) {
        this.model = (GmLink)connectionEP.getModel();
        this.connection = (Connection)connectionEP.getFigure();
        this.path = new GmPath(path);
        this.routingConstraint = (List)this.connection.getRoutingConstraint();
        this.sourceAnchorModel = ((IAnchorModelProvider)connectionEP.getSource()).createAnchorModel(this.connection.getSourceAnchor());
        this.targetAnchorModel = ((IAnchorModelProvider)connectionEP.getTarget()).createAnchorModel(this.connection.getTargetAnchor());
    }

    public void execute() {
        this.path.setSourceAnchor(this.sourceAnchorModel);
        this.path.setTargetAnchor(this.targetAnchorModel);
        ArrayList<Point> points = new ArrayList<Point>(this.routingConstraint.size());
        for (Bendpoint bendpoint : this.routingConstraint) {
            points.add(new Point(bendpoint.getLocation()));
        }
        Rectangle sourceBounds = this.getAnchorOwnerAbsoluteBounds(this.connection.getSourceAnchor()).expand(1, 1);
        this.connection.translateToRelative((Translatable)sourceBounds);
        Rectangle targetBounds = this.getAnchorOwnerAbsoluteBounds(this.connection.getTargetAnchor()).expand(1, 1);
        this.connection.translateToRelative((Translatable)targetBounds);
        if (!sourceBounds.contains(targetBounds)) {
            while (!points.isEmpty() && sourceBounds.contains((Point)points.get(0))) {
                points.remove(0);
            }
        } else {
            points.remove(0);
        }
        if (!targetBounds.contains(sourceBounds)) {
            while (!points.isEmpty() && targetBounds.contains((Point)points.get(points.size() - 1))) {
                points.remove(points.size() - 1);
            }
        } else {
            points.remove(points.size() - 1);
        }
        this.path.setPathData(points);
        this.model.setLayoutData((Object)this.path);
    }

    private Rectangle getAnchorOwnerAbsoluteBounds(ConnectionAnchor anchor) {
        IFigure f = anchor.getOwner();
        if (f == null) {
            Point p = anchor.getReferencePoint();
            return new Rectangle(p.x, p.y, 1, 1);
        }
        Rectangle bounds = f instanceof HandleBounds ? ((HandleBounds)f).getHandleBounds().getCopy() : f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)bounds);
        return bounds;
    }
}

