/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.ortho;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Orientation;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.BendPointMoveHandle;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.ChangeLinkRoutingConstraintCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.HorizontalSegmentMoveHandle;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.TranslateBendpointsCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.ortho.VerticalSegmentMoveHandle;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class OrthoBendpointEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private static final List<Bendpoint> NULL_CONSTRAINT = new ArrayList();
    private List<Bendpoint> originalConstraint;
    private static final int TOLERANCE = 7;
    private ConnectionAnchor originalSourceAnchor;
    private ConnectionAnchor originalTargetAnchor;
    private static final double CONSTANT_FACTOR = 1000.0;
    private static final Point p1 = new PrecisionPoint();
    private static final Point p2 = new PrecisionPoint();

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    protected List<?> createSelectionHandles() {
        ArrayList<Object> list = new ArrayList<Object>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        p1.setLocation(points.getPoint(0));
        p2.setLocation(points.getPoint(1));
        Orientation orientation = this.getSegmentOrientation(p1, p2);
        if (orientation == Orientation.HORIZONTAL) {
            list.add(new HorizontalSegmentMoveHandle(connEP, 0));
        } else if (orientation == Orientation.VERTICAL) {
            list.add(new VerticalSegmentMoveHandle(connEP, 0));
        }
        int i = 1;
        while (i < points.size() - 1) {
            list.add(new BendPointMoveHandle(connEP, i, orientation));
            p1.setLocation(points.getPoint(i));
            p2.setLocation(points.getPoint(i + 1));
            orientation = this.getSegmentOrientation(p1, p2);
            if (orientation == Orientation.HORIZONTAL) {
                list.add(new HorizontalSegmentMoveHandle(connEP, i));
            } else if (orientation == Orientation.VERTICAL) {
                list.add(new VerticalSegmentMoveHandle(connEP, i));
            }
            ++i;
        }
        return list;
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    protected void eraseConnectionFeedback(BendpointRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move connection segment".equals(request.getType()) || "move bendpoint".equals(request.getType())) {
            this.eraseConnectionFeedback((BendpointRequest)request);
        } else if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("move connection segment".equals(request.getType())) {
            return this.getMoveSegmentCommand((BendpointRequest)request);
        }
        if ("move bendpoint".equals(request.getType())) {
            return this.getMoveBendpointCommand((BendpointRequest)request);
        }
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        ConnectionEditPart hostEP = (ConnectionEditPart)this.getHost();
        IGmPath path = ((GmLink)hostEP.getModel()).getPath();
        return new ChangeLinkRoutingConstraintCommand(path, hostEP);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    protected void restoreOriginalConstraint() {
        if (this.originalConstraint != null) {
            if (this.originalConstraint == NULL_CONSTRAINT) {
                this.getConnection().setRoutingConstraint(null);
            } else {
                this.getConnection().setRoutingConstraint((Object)this.originalConstraint);
            }
        }
        this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        this.getConnection().setTargetAnchor(this.originalTargetAnchor);
    }

    protected void saveOriginalConstraint() {
        this.originalConstraint = (List)this.getConnection().getRoutingConstraint();
        if (this.originalConstraint == null) {
            this.originalConstraint = NULL_CONSTRAINT;
        }
        this.originalSourceAnchor = this.getConnection().getSourceAnchor();
        this.originalTargetAnchor = this.getConnection().getTargetAnchor();
        this.getConnection().setRoutingConstraint((Object)this.rebuildRoutingConstraint(this.getConnection()));
    }

    protected void showMoveBendpointFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        if (request.getExtendedData().get(Orientation.class) == Orientation.HORIZONTAL) {
            this.showMoveHorizontalBendpointFeedback(request);
        } else if (request.getExtendedData().get(Orientation.class) == Orientation.VERTICAL) {
            this.showMoveVerticalBendpointFeedback(request);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("move connection segment".equals(request.getType())) {
            this.showMoveSegmentFeedback((BendpointRequest)request);
        } else if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    private Command getMoveSegmentCommand(BendpointRequest request) {
        ConnectionEditPart hostEP = (ConnectionEditPart)this.getHost();
        IGmPath path = ((GmLink)hostEP.getModel()).getPath();
        return new ChangeLinkRoutingConstraintCommand(path, hostEP);
    }

    protected void showMoveSegmentFeedback(BendpointRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        if (request.getExtendedData().get(Orientation.class) == Orientation.HORIZONTAL) {
            this.showMoveHorizontalSegmentFeedback(request);
        } else {
            assert (request.getExtendedData().get(Orientation.class) == Orientation.VERTICAL) : "no orientation in data!";
            this.showMoveVerticalSegmentFeedback(request);
        }
    }

    private List<Bendpoint> rebuildRoutingConstraint(Connection connection) {
        PointList points = connection.getPoints();
        ArrayList<Bendpoint> newConstraint = new ArrayList<Bendpoint>(points.size());
        int i = 0;
        while (i < points.size()) {
            Point point = points.getPoint(i);
            newConstraint.add((Bendpoint)new AbsoluteBendpoint(point));
            ++i;
        }
        return newConstraint;
    }

    protected Orientation getSegmentOrientation(Point point1, Point point2) {
        if (point1 == null || point2 == null) {
            return Orientation.NONE;
        }
        if (point1.x() == point2.x()) {
            if (point1.y() == point2.y()) {
                return Orientation.NONE;
            }
            return Orientation.VERTICAL;
        }
        if (point1.y() == point2.y()) {
            return Orientation.HORIZONTAL;
        }
        double ratio = 1000.0 * (double)Math.abs(point1.x() - point2.x()) / (1000.0 * (double)Math.abs(point1.y() - point2.y()));
        if (ratio < 1.0) {
            return Orientation.VERTICAL;
        }
        if (ratio > 1.0) {
            return Orientation.HORIZONTAL;
        }
        return Orientation.NONE;
    }

    private void showMoveVerticalSegmentFeedback(BendpointRequest request) {
        ConnectionEditPart connectionEditPart;
        ReconnectRequest reconnectRequest;
        Connection connection = this.getConnection();
        List routingConstraint = (List)connection.getRoutingConstraint();
        Bendpoint startPoint = (Bendpoint)routingConstraint.get(request.getIndex());
        Bendpoint endPoint = (Bendpoint)routingConstraint.get(request.getIndex() + 1);
        boolean snapPrevious = false;
        boolean snapNext = false;
        p1.setLocation(startPoint.getLocation());
        connection.translateToAbsolute((Translatable)p1);
        p1.setX(request.getLocation().x());
        if (request.getIndex() > 0) {
            Point previous = ((Bendpoint)routingConstraint.get(request.getIndex() - 1)).getLocation().getCopy();
            connection.translateToAbsolute((Translatable)previous);
            if (Math.abs(previous.x() - p1.x()) < 7) {
                snapPrevious = true;
                p1.setX(previous.x());
            }
        }
        p2.setLocation(endPoint.getLocation());
        connection.translateToAbsolute((Translatable)p2);
        p2.setX(request.getLocation().x());
        if (request.getIndex() + 2 < routingConstraint.size()) {
            Point next = ((Bendpoint)routingConstraint.get(request.getIndex() + 2)).getLocation().getCopy();
            connection.translateToAbsolute((Translatable)next);
            if (Math.abs(next.x() - p2.x()) < 7) {
                snapNext = true;
                p2.setX(next.x());
            }
        }
        if (snapPrevious) {
            p2.setX(p1.x());
        } else if (snapNext) {
            p1.setX(p2.x());
        }
        connection.translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex(), new AbsoluteBendpoint(p1));
        connection.translateToRelative((Translatable)p2);
        routingConstraint.set(request.getIndex() + 1, new AbsoluteBendpoint(p2));
        if (request.getIndex() == 0) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection source");
            connectionEditPart = (ConnectionEditPart)this.getHost();
            reconnectRequest.setConnectionEditPart(connectionEditPart);
            NodeEditPart sourceEditPart = (NodeEditPart)connectionEditPart.getSource();
            reconnectRequest.setTargetEditPart((EditPart)sourceEditPart);
            connection.translateToAbsolute((Translatable)p1);
            reconnectRequest.setLocation(p1);
            connection.setSourceAnchor(sourceEditPart.getSourceConnectionAnchor((Request)reconnectRequest));
        }
        if (request.getIndex() == routingConstraint.size() - 2) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection target");
            connectionEditPart = (ConnectionEditPart)this.getHost();
            reconnectRequest.setConnectionEditPart(connectionEditPart);
            NodeEditPart targetEditPart = (NodeEditPart)connectionEditPart.getTarget();
            reconnectRequest.setTargetEditPart((EditPart)targetEditPart);
            connection.translateToAbsolute((Translatable)p2);
            reconnectRequest.setLocation(p2);
            connection.setTargetAnchor(targetEditPart.getTargetConnectionAnchor((Request)reconnectRequest));
        }
        connection.setRoutingConstraint((Object)routingConstraint);
    }

    private void showMoveHorizontalSegmentFeedback(BendpointRequest request) {
        ConnectionEditPart connectionEditPart;
        ReconnectRequest reconnectRequest;
        Connection connection = this.getConnection();
        List routingConstraint = (List)connection.getRoutingConstraint();
        Bendpoint startPoint = (Bendpoint)routingConstraint.get(request.getIndex());
        Bendpoint endPoint = (Bendpoint)routingConstraint.get(request.getIndex() + 1);
        boolean snapPrevious = false;
        boolean snapNext = false;
        p1.setLocation(startPoint.getLocation());
        connection.translateToAbsolute((Translatable)p1);
        p1.setY(request.getLocation().y());
        if (request.getIndex() > 0) {
            Point previous = ((Bendpoint)routingConstraint.get(request.getIndex() - 1)).getLocation().getCopy();
            connection.translateToAbsolute((Translatable)previous);
            if (Math.abs(previous.y() - p1.y()) < 7) {
                snapPrevious = true;
                p1.setY(previous.y());
            }
        }
        p2.setLocation(endPoint.getLocation());
        connection.translateToAbsolute((Translatable)p2);
        p2.setY(request.getLocation().y());
        if (request.getIndex() + 2 < routingConstraint.size()) {
            Point next = ((Bendpoint)routingConstraint.get(request.getIndex() + 2)).getLocation().getCopy();
            connection.translateToAbsolute((Translatable)next);
            if (Math.abs(next.y() - p2.y()) < 7) {
                snapNext = true;
                p2.setY(next.y());
            }
        }
        if (snapPrevious) {
            p2.setY(p1.y());
        } else if (snapNext) {
            p1.setY(p2.y());
        }
        connection.translateToRelative((Translatable)p1);
        connection.translateToRelative((Translatable)p2);
        routingConstraint.set(request.getIndex(), new AbsoluteBendpoint(p1));
        routingConstraint.set(request.getIndex() + 1, new AbsoluteBendpoint(p2));
        if (request.getIndex() == 0) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection source");
            connectionEditPart = (ConnectionEditPart)this.getHost();
            reconnectRequest.setConnectionEditPart(connectionEditPart);
            NodeEditPart sourceEditPart = (NodeEditPart)connectionEditPart.getSource();
            reconnectRequest.setTargetEditPart((EditPart)sourceEditPart);
            connection.translateToAbsolute((Translatable)p1);
            reconnectRequest.setLocation(p1);
            connection.setSourceAnchor(sourceEditPart.getSourceConnectionAnchor((Request)reconnectRequest));
        }
        if (request.getIndex() == routingConstraint.size() - 2) {
            reconnectRequest = new ReconnectRequest((Object)"Reconnection target");
            connectionEditPart = (ConnectionEditPart)this.getHost();
            reconnectRequest.setConnectionEditPart(connectionEditPart);
            NodeEditPart targetEditPart = (NodeEditPart)connectionEditPart.getTarget();
            reconnectRequest.setTargetEditPart((EditPart)targetEditPart);
            connection.translateToAbsolute((Translatable)p2);
            reconnectRequest.setLocation(p2);
            connection.setTargetAnchor(targetEditPart.getTargetConnectionAnchor((Request)reconnectRequest));
        }
        connection.setRoutingConstraint((Object)routingConstraint);
    }

    private void showMoveHorizontalBendpointFeedback(BendpointRequest request) {
        List routingConstraint = (List)this.getConnection().getRoutingConstraint();
        Bendpoint previousPoint = (Bendpoint)routingConstraint.get(request.getIndex() - 1);
        Bendpoint nextPoint = (Bendpoint)routingConstraint.get(request.getIndex() + 1);
        p1.setLocation(previousPoint.getLocation());
        this.getConnection().translateToAbsolute((Translatable)p1);
        p1.setY(request.getLocation().y());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex() - 1, new AbsoluteBendpoint(p1));
        p1.setLocation(nextPoint.getLocation());
        this.getConnection().translateToAbsolute((Translatable)p1);
        p1.setX(request.getLocation().x());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex() + 1, new AbsoluteBendpoint(p1));
        p1.setLocation(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex(), new AbsoluteBendpoint(p1));
        this.getConnection().setRoutingConstraint((Object)routingConstraint);
    }

    private void showMoveVerticalBendpointFeedback(BendpointRequest request) {
        List routingConstraint = (List)this.getConnection().getRoutingConstraint();
        Bendpoint previousPoint = (Bendpoint)routingConstraint.get(request.getIndex() - 1);
        Bendpoint nextPoint = (Bendpoint)routingConstraint.get(request.getIndex() + 1);
        p1.setLocation(previousPoint.getLocation());
        this.getConnection().translateToAbsolute((Translatable)p1);
        p1.setX(request.getLocation().x());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex() - 1, new AbsoluteBendpoint(p1));
        p1.setLocation(nextPoint.getLocation());
        this.getConnection().translateToAbsolute((Translatable)p1);
        p1.setY(request.getLocation().y());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex() + 1, new AbsoluteBendpoint(p1));
        p1.setLocation(request.getLocation());
        this.getConnection().translateToRelative((Translatable)p1);
        routingConstraint.set(request.getIndex(), new AbsoluteBendpoint(p1));
        this.getConnection().setRoutingConstraint((Object)routingConstraint);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ConnectionAnchor currentSourceAnchor = this.getConnection().getSourceAnchor();
        ConnectionAnchor currentTargetAnchor = this.getConnection().getTargetAnchor();
        this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        this.getConnection().setTargetAnchor(this.originalTargetAnchor);
        ConnectionEditPart hostEP = (ConnectionEditPart)this.getHost();
        IGmPath path = ((GmLink)hostEP.getModel()).getPath();
        TranslateBendpointsCommand command = new TranslateBendpointsCommand(path, hostEP);
        this.getConnection().setSourceAnchor(currentSourceAnchor);
        this.getConnection().setTargetAnchor(currentTargetAnchor);
        return command;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this.originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        Connection connection = this.getConnection();
        ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>();
        for (Bendpoint bendpoint : this.originalConstraint) {
            Point location = Point.SINGLETON;
            location.setLocation(bendpoint.getLocation());
            connection.translateToAbsolute((Translatable)location);
            location.translate(request.getMoveDelta());
            connection.translateToRelative((Translatable)location);
            newConstraint.add(new AbsoluteBendpoint(location));
        }
        this.getConnection().setSourceAnchor((ConnectionAnchor)new XYAnchor(this.originalSourceAnchor.getReferencePoint().getTranslated(request.getMoveDelta())));
        this.getConnection().setTargetAnchor((ConnectionAnchor)new XYAnchor(this.originalTargetAnchor.getReferencePoint().getTranslated(request.getMoveDelta())));
        this.getConnection().setRoutingConstraint(newConstraint);
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        this.restoreOriginalConstraint();
        this.originalConstraint = null;
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
    }

    public boolean understandsRequest(Request req) {
        if ("move".equals(req.getType())) {
            return true;
        }
        return super.understandsRequest(req);
    }
}

