/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.path;

import com.modeliosoft.modelio.diagram.elements.core.link.path.IConnectionHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.path.RawPathData;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;

public class ObliqueConnectionHelper
implements IConnectionHelper {
    private List<Point> bendPoints = new ArrayList();
    private Connection connection;

    public List<Point> getBendPoints() {
        return this.bendPoints;
    }

    public void updateFrom(RawPathData rawData) {
        this.bendPoints.clear();
        this.readRawPoints(rawData);
    }

    public StyleKey.ConnectionRouterId getRoutingMode() {
        return StyleKey.ConnectionRouterId.BENDPOINT;
    }

    public ObliqueConnectionHelper(RawPathData rawData, Connection connection) {
        this.connection = connection;
        this.readRawPoints(rawData);
    }

    public ObliqueConnectionHelper(List<Point> points, Connection connection) {
        this.connection = connection;
        this.bendPoints = points;
    }

    public Object getRoutingConstraint() {
        ArrayList<AbsoluteBendpoint> ret = new ArrayList<AbsoluteBendpoint>(this.bendPoints.size());
        for (Point p : this.bendPoints) {
            ret.add(new AbsoluteBendpoint(p));
        }
        return ret;
    }

    private void readRawPoints(RawPathData rawData) {
        Point tmp = Point.SINGLETON;
        for (Point absolutePoint : rawData.getPath()) {
            tmp.setLocation(absolutePoint);
            this.connection.translateToRelative((Translatable)tmp);
            this.bendPoints.add(tmp.getCopy());
        }
    }

    public static ObliqueConnectionHelper createFromRoutingConstraint(Object routingConstraint, Connection connection) {
        List bendpoints = (List)routingConstraint;
        ArrayList<Point> points = new ArrayList<Point>(bendpoints.size());
        for (Bendpoint bendpoint : bendpoints) {
            points.add(new Point(bendpoint.getLocation()));
        }
        return new ObliqueConnectionHelper(points, connection);
    }
}

