/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.path;

import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Direction;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.GeomUtils;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.Orientation;
import com.modeliosoft.modelio.diagram.elements.core.link.path.IConnectionHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.path.RawPathData;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;

public class OrthoConnectionHelper
implements IConnectionHelper {
    private List<Point> bendPoints = new ArrayList();
    private Connection connection;
    private static final int REFLEXIVE_OFFSET = 20;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$diagram$elements$core$figures$geometry$Direction;

    public static OrthoConnectionHelper createFromRoutingConstraint(Object routingConstraint, Connection connection) {
        List bendpoints = (List)routingConstraint;
        ArrayList<Point> points = new ArrayList<Point>(bendpoints.size());
        for (Bendpoint bendpoint : bendpoints) {
            points.add(new Point(bendpoint.getLocation()));
        }
        return new OrthoConnectionHelper(points, connection);
    }

    public OrthoConnectionHelper(Connection connection) {
        this.connection = connection;
        PointList l = connection.getPoints();
        this.bendPoints = new ArrayList(l.size());
        int i = 0;
        while (i < l.size()) {
            this.bendPoints.add(l.getPoint(i));
            ++i;
        }
    }

    public OrthoConnectionHelper(RawPathData rawData, Connection connection) {
        this.connection = connection;
        ConnectionAnchor sourceAnchor = connection.getSourceAnchor();
        IFigure sourceFigure = sourceAnchor.getOwner();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        IFigure targetFigure = targetAnchor.getOwner();
        if (sourceFigure != null && sourceFigure.equals(targetFigure) && rawData.getPath().isEmpty()) {
            RawPathData reflexivePath = new RawPathData();
            reflexivePath.setSrcPoint(rawData.getSrcPoint().getCopy());
            reflexivePath.setLastPoint(rawData.getLastPoint());
            reflexivePath.setRoutingMode(rawData.getRoutingMode());
            this.addReflexivePoints(reflexivePath, sourceAnchor, sourceFigure, targetAnchor);
            this.readRawPoints(reflexivePath.getPath(), reflexivePath.getLastPoint());
        } else {
            this.readRawPoints(rawData.getPath(), rawData.getLastPoint());
        }
    }

    public OrthoConnectionHelper(List<Point> points, Connection connection) {
        this.connection = connection;
        this.bendPoints = points;
    }

    public List<Point> getBendPoints() {
        return this.bendPoints;
    }

    public List<Bendpoint> getRoutingConstraint() {
        ArrayList<Bendpoint> ret = new ArrayList<Bendpoint>(this.bendPoints.size());
        for (Point p : this.bendPoints) {
            ret.add((Bendpoint)new AbsoluteBendpoint(p.x, p.y));
        }
        return ret;
    }

    public StyleKey.ConnectionRouterId getRoutingMode() {
        return StyleKey.ConnectionRouterId.ORTHOGONAL;
    }

    public void updateFrom(RawPathData req) {
        this.bendPoints.clear();
        ConnectionAnchor sourceAnchor = this.connection.getSourceAnchor();
        IFigure sourceFigure = sourceAnchor.getOwner();
        ConnectionAnchor targetAnchor = this.connection.getTargetAnchor();
        IFigure targetFigure = targetAnchor.getOwner();
        if (sourceFigure != null && sourceFigure.equals(targetFigure) && req.getPath().isEmpty()) {
            RawPathData reflexivePath = new RawPathData();
            reflexivePath.setSrcPoint(req.getSrcPoint().getCopy());
            reflexivePath.setLastPoint(req.getLastPoint());
            reflexivePath.setRoutingMode(req.getRoutingMode());
            this.addReflexivePoints(reflexivePath, sourceAnchor, sourceFigure, targetAnchor);
            this.readRawPoints(reflexivePath.getPath(), reflexivePath.getLastPoint());
        } else {
            this.readRawPoints(req.getPath(), req.getLastPoint());
        }
    }

    private Rectangle getAnchorOwnerAbsoluteBounds(ConnectionAnchor anchor) {
        IFigure f = anchor.getOwner();
        if (f == null) {
            Point p = anchor.getReferencePoint();
            return new Rectangle(p.x, p.y, 1, 1);
        }
        Rectangle bounds = f instanceof HandleBounds ? ((HandleBounds)f).getHandleBounds().getCopy() : f.getBounds().getCopy();
        f.translateToAbsolute((Translatable)bounds);
        return bounds;
    }

    private void readRawPoints(List<Point> path, Point lastPoint) {
        ConnectionAnchor sourceAnchor = this.connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = this.connection.getTargetAnchor();
        Point lastReferencePoint = targetAnchor != null ? targetAnchor.getReferencePoint() : lastPoint;
        Point tmpPoint = Point.SINGLETON;
        if (path.size() > 0) {
            tmpPoint.setLocation(path.get(0));
            this.connection.translateToAbsolute((Translatable)tmpPoint);
        } else {
            tmpPoint.setLocation(lastReferencePoint);
        }
        Point sourceLocation = sourceAnchor.getLocation(tmpPoint);
        Rectangle sourceBounds = this.getAnchorOwnerAbsoluteBounds(sourceAnchor);
        Direction sourceAnchorOrientation = GeomUtils.getDirection((Point)sourceLocation, (Rectangle)sourceBounds);
        Orientation currentOrientation = GeomUtils.getOrientation((Direction)sourceAnchorOrientation);
        if (path.size() > 0) {
            Point previousPoint = sourceLocation;
            int i = 0;
            while (i < path.size()) {
                Point currentPoint = path.get(i);
                if (currentOrientation == Orientation.HORIZONTAL) {
                    tmpPoint.setLocation(currentPoint.x, previousPoint.y);
                    currentOrientation = Orientation.VERTICAL;
                } else {
                    tmpPoint.setLocation(previousPoint.x, currentPoint.y);
                    currentOrientation = Orientation.HORIZONTAL;
                }
                this.connection.translateToRelative((Translatable)tmpPoint);
                this.bendPoints.add(tmpPoint.getCopy());
                this.connection.translateToAbsolute((Translatable)tmpPoint);
                previousPoint.setLocation(tmpPoint);
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void addReflexivePoints(RawPathData rawData, ConnectionAnchor sourceAnchor, IFigure sourceFigure, ConnectionAnchor targetAnchor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$modeliosoft$modelio$diagram$elements$core$figures$geometry$Direction() {
        if ($SWITCH_TABLE$com$modeliosoft$modelio$diagram$elements$core$figures$geometry$Direction != null) {
            return $SWITCH_TABLE$com$modeliosoft$modelio$diagram$elements$core$figures$geometry$Direction;
        }
        int[] nArray = new int[Direction.values().length];
        try {
            nArray[Direction.EAST.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.NORTH.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.SOUTH.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Direction.WEST.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$modeliosoft$modelio$diagram$elements$core$figures$geometry$Direction = nArray;
        return nArray;
    }
}

