/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.path;

import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import com.modeliosoft.modelio.diagram.elements.core.link.path.IConnectionHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.path.RawPathData;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;

public class RakeConnectionHelper
implements IConnectionHelper {
    private Connection connection;
    private RakeConstraint constraint;

    public List<Point> getBendPoints() {
        if (this.constraint == null) {
            return Collections.emptyList();
        }
        ArrayList<Point> ret = new ArrayList<Point>(2);
        XYAnchor anchor = this.constraint.getSourceRakeAnchor();
        if (anchor != null) {
            ret.add(anchor.getReferencePoint());
        }
        if ((anchor = this.constraint.getTargetRakeAnchor()) != null) {
            ret.add(anchor.getReferencePoint());
        }
        return ret;
    }

    public void updateFrom(RawPathData req) {
        ConnectionAnchor targetAnchor1 = this.connection.getTargetAnchor();
        IFigure targetFig = targetAnchor1.getOwner();
        if (targetFig instanceof Connection) {
            Connection targetConn = (Connection)targetFig;
            if (targetConn.getRoutingConstraint() instanceof RakeConstraint) {
                this.constraint = (RakeConstraint)targetConn.getRoutingConstraint();
            } else {
                Point rakeLocation = targetAnchor1.getLocation(req.getLastPoint());
                this.constraint = new RakeConstraint();
                this.constraint.setTargetRakeAnchor(new XYAnchor(rakeLocation));
                this.connection.setTargetAnchor(targetConn.getTargetAnchor());
            }
        }
    }

    public StyleKey.ConnectionRouterId getRoutingMode() {
        return StyleKey.ConnectionRouterId.ORTHOGONAL;
    }

    public RakeConnectionHelper(Object serializedData, Connection connection) {
        this.constraint = (RakeConstraint)serializedData;
        this.connection = connection;
    }

    public RakeConnectionHelper(RawPathData req, Connection connection) {
        this.connection = connection;
        this.updateFrom(req);
    }

    public Object getRoutingConstraint() {
        return this.constraint;
    }
}

