/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.rake;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeRouter;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkEditPart;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.IAnchorModelProvider;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.link.rake.CreateRakedLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.rake.RakeLinkOnSourceCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.rake.RakeLinkOnTargetCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmPath;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class CreateRakeLinkEditPolicy
extends GraphicalNodeEditPolicy {
    private static boolean activated = true;

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (this.allowRakeCreation(request)) {
            GmLink gm = (GmLink)this.getHost().getModel();
            CreateRakedLinkCommand cmd = new CreateRakedLinkCommand((ModelioLinkCreationContext)request.getNewObject(), gm);
            cmd.setSource((IGmLinkable)request.getSourceEditPart().getModel());
            cmd.setTarget(gm.getTo());
            cmd.setPath(this.createPathModel(request, gm));
            return cmd;
        }
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        return null;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        if (!this.isHandled((Request)request)) {
            return null;
        }
        ConnectionEditPart toReconnect = request.getConnectionEditPart();
        Point loc = request.getLocation();
        toReconnect.getFigure().translateToRelative((Translatable)loc);
        NodeEditPart newSourceEditPart = (NodeEditPart)((ConnectionEditPart)this.getHost()).getSource();
        ConnectionAnchor anchor = this.getFinalSourceAnchor(newSourceEditPart, request);
        Object gmAnchor = ((IAnchorModelProvider)newSourceEditPart).createAnchorModel(anchor);
        return new RakeLinkOnSourceCommand((GmLink)toReconnect.getModel(), (GmLink)this.getHost().getModel(), loc, gmAnchor);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        if (!this.isHandled((Request)request)) {
            return null;
        }
        ConnectionEditPart toReconnect = request.getConnectionEditPart();
        Point loc = request.getLocation().getCopy();
        toReconnect.getFigure().translateToRelative((Translatable)loc);
        NodeEditPart newTargetEditPart = (NodeEditPart)((ConnectionEditPart)this.getHost()).getTarget();
        ConnectionAnchor anchor = this.getFinalTargetAnchor(newTargetEditPart, request);
        Object gmAnchor = ((IAnchorModelProvider)newTargetEditPart).createAnchorModel(anchor);
        return new RakeLinkOnTargetCommand((GmLink)toReconnect.getModel(), (GmLink)this.getHost().getModel(), loc, gmAnchor);
    }

    private ConnectionAnchor getFinalSourceAnchor(NodeEditPart newSourceEditPart, ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        Connection fig = (Connection)connectionEditPart.getFigure();
        Object oldConstraint = fig.getRoutingConstraint();
        ConnectionRouter oldRouter = fig.getConnectionRouter();
        fig.setConnectionRouter((ConnectionRouter)new RakeRouter());
        fig.setRoutingConstraint((Object)new RakeConstraint());
        ReconnectRequest r = new ReconnectRequest((Object)"Reconnection source");
        r.setConnectionEditPart(request.getConnectionEditPart());
        r.setLocation(request.getLocation());
        r.setTargetEditPart((EditPart)newSourceEditPart);
        ConnectionAnchor ret = newSourceEditPart.getSourceConnectionAnchor((Request)r);
        fig.setConnectionRouter(oldRouter);
        fig.setRoutingConstraint(oldConstraint);
        return ret;
    }

    private ConnectionAnchor getFinalTargetAnchor(NodeEditPart newTargetEditPart, ReconnectRequest request) {
        ConnectionEditPart connectionEditPart = request.getConnectionEditPart();
        Connection fig = (Connection)connectionEditPart.getFigure();
        Object oldConstraint = fig.getRoutingConstraint();
        ConnectionRouter oldRouter = fig.getConnectionRouter();
        fig.setConnectionRouter((ConnectionRouter)new RakeRouter());
        fig.setRoutingConstraint((Object)new RakeConstraint());
        Point p = ((Connection)this.getHostFigure()).getPoints().getLastPoint();
        fig.translateToAbsolute((Translatable)p);
        ReconnectRequest r = new ReconnectRequest((Object)"Reconnection target");
        r.setConnectionEditPart(connectionEditPart);
        r.setLocation(p);
        r.setTargetEditPart((EditPart)newTargetEditPart);
        ConnectionAnchor ret = newTargetEditPart.getTargetConnectionAnchor((Request)r);
        fig.setConnectionRouter(oldRouter);
        fig.setRoutingConstraint(oldConstraint);
        return ret;
    }

    public void showTargetFeedback(Request request) {
        if (!this.isHandled(request)) {
            return;
        }
        boolean cfr_ignored_0 = request instanceof ReconnectRequest;
    }

    protected boolean isHandled(Request request) {
        if (request instanceof ReconnectRequest) {
            GmLinkEditPart toReconnect;
            if (((ReconnectRequest)request).getConnectionEditPart() instanceof GmLinkEditPart && (toReconnect = (GmLinkEditPart)((ReconnectRequest)request).getConnectionEditPart()).getModel().getClass() == this.getHost().getModel().getClass()) {
                return true;
            }
        } else if (request instanceof CreateConnectionRequest) {
            IElement repEl;
            Class toCreate = this.getMetaclass((CreateConnectionRequest)request);
            if (toCreate.isAssignableFrom((repEl = ((GmLink)this.getHost().getModel()).getRelatedIElement()).getClass())) {
                return false;
            }
            return false;
        }
        return false;
    }

    private Class<? extends IElement> getMetaclass(CreateConnectionRequest request) {
        Object factory = request.getNewObject();
        if (factory instanceof ModelioLinkCreationContext) {
            ModelioLinkCreationContext ctx = (ModelioLinkCreationContext)factory;
            return MetaModelExpert.getMetaclass((String)ctx.getMetaclass());
        }
        if (factory instanceof ModelioCreationContext) {
            ModelioCreationContext ctx = (ModelioCreationContext)factory;
            return MetaModelExpert.getMetaclass((String)ctx.getMetaclass());
        }
        return null;
    }

    protected IGmPath createPathModel(CreateConnectionRequest req, GmLink gmTargetLink) {
        GmPath path = new GmPath();
        path.setRouterKind(StyleKey.ConnectionRouterId.ORTHOGONAL);
        req.getExtendedData().put("rake", Boolean.TRUE);
        NodeEditPart sourceEditPart = (NodeEditPart)req.getSourceEditPart();
        ConnectionAnchor srcAnchor = sourceEditPart.getSourceConnectionAnchor((Request)req);
        path.setSourceAnchor(this.getAnchorModel(sourceEditPart, srcAnchor));
        IGmPath targetLinkPath = gmTargetLink.getPath();
        if (targetLinkPath.getTargetRake() == null) {
            NodeEditPart targetPart = (NodeEditPart)((ConnectionEditPart)this.getHost()).getTarget();
            ConnectionAnchor targetAnchor = targetPart.getTargetConnectionAnchor((Request)req);
            path.setTargetAnchor(this.getAnchorModel(targetPart, targetAnchor));
            GmLinkRake rake = new GmLinkRake();
            rake.setSharedAnchor(path.getTargetAnchor());
            path.setTargetRake((IGmLinkRake)rake);
            NodeEditPart thisLinkPart = (NodeEditPart)this.getHost();
            Point p = thisLinkPart.getTargetConnectionAnchor((Request)req).getReferencePoint();
            thisLinkPart.getFigure().translateToRelative((Translatable)p);
            RakeConstraint pathData = new RakeConstraint();
            pathData.setTargetRakeAnchor(new XYAnchor(p));
            path.setPathData((Object)pathData);
        } else {
            path.setTargetAnchor(targetLinkPath.getTargetAnchor());
            path.setTargetRake(targetLinkPath.getTargetRake());
            path.setPathData(targetLinkPath.getPathData());
        }
        return path;
    }

    private Object getAnchorModel(NodeEditPart editpart, ConnectionAnchor anchor) {
        if (editpart instanceof IAnchorModelProvider) {
            return ((IAnchorModelProvider)editpart).createAnchorModel(anchor);
        }
        return null;
    }

    private boolean allowRakeCreation(CreateConnectionRequest request) {
        if (!activated) {
            return false;
        }
        activated = false;
        try {
            Command cmd = this.getHost().getCommand((Request)request);
            if (cmd != null && cmd.canExecute()) {
                return false;
            }
        }
        finally {
            activated = true;
        }
        EditPart ep = request.getTargetEditPart();
        request.setTargetEditPart(((ConnectionEditPart)this.getHost()).getTarget());
        EditPart t = request.getTargetEditPart().getTargetEditPart((Request)request);
        boolean ret = t != null && t.getCommand((Request)request) != null;
        request.setTargetEditPart(ep);
        return ret;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType())) {
            return this.getHost();
        }
        if ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            ConnectionEditPart reconnectedConnectionEP = ((ReconnectRequest)request).getConnectionEditPart();
            if (this.isLinkCycle(this.getHost(), reconnectedConnectionEP)) {
                return null;
            }
            return this.getHost();
        }
        return null;
    }

    private boolean isLinkCycle(EditPart testedEditPart, ConnectionEditPart reconnectedConnectionEP) {
        if (testedEditPart.equals(reconnectedConnectionEP)) {
            return true;
        }
        if (testedEditPart instanceof ConnectionEditPart) {
            ConnectionEditPart connectionEP = (ConnectionEditPart)testedEditPart;
            return this.isLinkCycle(connectionEP.getSource(), reconnectedConnectionEP) || this.isLinkCycle(connectionEP.getTarget(), reconnectedConnectionEP);
        }
        return false;
    }
}

