/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.rake;

import com.modeliosoft.modelio.diagram.elements.core.figures.anchors.ISlidableAnchor;
import com.modeliosoft.modelio.diagram.elements.core.figures.geometry.LineSeg;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import com.modeliosoft.modelio.diagram.elements.core.link.rake.LineSegMoveInvisibleHandle;
import com.modeliosoft.modelio.diagram.elements.core.link.rake.RakeLinkEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.BendpointLocator;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleHandleProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.handles.BendpointMoveHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class RakeLinkEditPolicy
extends SelectionHandlesEditPolicy
implements PropertyChangeListener {
    private FeedbackState feedbackState = null;

    public void activate() {
        super.activate();
        this.getConnection().addPropertyChangeListener("points", (PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getConnection().removePropertyChangeListener("points", (PropertyChangeListener)this);
        super.deactivate();
    }

    public void eraseSourceFeedback(Request request) {
        if ("move bendpoint".equals(request.getType()) || "create bendpoint".equals(request.getType())) {
            this.restoreOriginalConstraint();
            this.getFeedbackState().originalConstraint = null;
            if (((BendpointRequest)request).getSource() != this.getHost()) {
                this.cleanFeedbackState();
            }
        } else {
            this.cleanFeedbackState();
        }
    }

    public Object getAdapter(Class key) {
        if (key == AccessibleHandleProvider.class && this.handles == null) {
            return null;
        }
        return super.getAdapter(key);
    }

    public Command getCommand(Request request) {
        if ("move bendpoint".equals(request.getType())) {
            return this.getFeedbackState().currentCommand;
        }
        if ("create bendpoint".equals(request.getType())) {
            return this.getFeedbackState().currentCommand;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    public void showSourceFeedback(Request request) {
        if ("create bendpoint".equals(request.getType())) {
            this.showMoveLineSegFeedback((BendpointRequest)request);
            this.getFeedbackState().currentCommand = this.getBendpointsChangedCommand((BendpointRequest)request);
        } else if ("move bendpoint".equals(request.getType())) {
            this.showMoveOrthogonalBendpointFeedback((BendpointRequest)request);
            this.getFeedbackState().currentCommand = this.getBendpointsChangedCommand((BendpointRequest)request);
        }
        super.showSourceFeedback(request);
    }

    protected void addSelectionHandles() {
        if (this.handles == null) {
            super.addSelectionHandles();
        } else {
            int points;
            int count = this.handles.size();
            if (count != (points = this.getConnection().getPoints().size()) * 2 - 3) {
                super.addSelectionHandles();
            }
        }
    }

    protected void cleanFeedbackState() {
        this.feedbackState = null;
    }

    protected List<?> createSelectionHandles() {
        return this.createManualHandles();
    }

    private void addInvisibleCreationHandle(List<BendpointHandle> list, ConnectionEditPart connEP, int i) {
        list.add((BendpointHandle)new LineSegMoveInvisibleHandle(connEP, i));
    }

    private void adjustLineToRectangle(LineSeg line, IFigure figure) {
        PrecisionRectangle endRect = new PrecisionRectangle(figure.getBounds());
        if (line.isHorizontal()) {
            endRect.shrink(0, 5);
        } else {
            endRect.shrink(5, 0);
        }
        figure.translateToAbsolute((Translatable)endRect);
        this.getConnection().translateToRelative((Translatable)endRect);
        Point p1 = line.getOrigin();
        Point p2 = line.getTerminus();
        if (line.isHorizontal()) {
            if (p2.y < endRect.y) {
                p1.y = endRect.y;
                p2.y = endRect.y;
                line.setOrigin(p1);
                line.setTerminus(p2);
            } else if (p2.y > endRect.bottom()) {
                p1.y = endRect.bottom();
                p2.y = endRect.bottom();
                line.setOrigin(p1);
                line.setTerminus(p2);
            }
        }
        if (line.isVertical()) {
            if (p2.x < endRect.x) {
                p1.x = endRect.x;
                p2.x = endRect.x;
                line.setOrigin(p1);
                line.setTerminus(p2);
            } else if (p2.x > endRect.right()) {
                p1.x = endRect.right();
                p2.x = endRect.right();
                line.setOrigin(p1);
                line.setTerminus(p2);
            }
        }
    }

    private boolean adjustOutsideBoundsLineFeedback(LineSeg newLine, int index, RakeConstraint constraint, LineSeg moveLine) {
        if (index == 0) {
            this.adjustLineToRectangle(newLine, this.getConnection().getSourceAnchor().getOwner());
        } else if (index == 2) {
            this.adjustLineToRectangle(newLine, this.getConnection().getTargetAnchor().getOwner());
        }
        return false;
    }

    private List<BendpointHandle> createManualHandles() {
        ArrayList<BendpointHandle> list = new ArrayList<BendpointHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        ArrayList<Point> debugPoints = new ArrayList<Point>(points.size() - 2);
        int i = 1;
        while (i < points.size() - 1) {
            this.addInvisibleCreationHandle(list, connEP, i - 1);
            list.add((BendpointHandle)new BendpointMoveHandle(connEP, i, (Locator)new BendpointLocator(this.getConnection(), i)));
            debugPoints.add(points.getPoint(i));
            ++i;
        }
        this.addInvisibleCreationHandle(list, connEP, points.size() - 2);
        return list;
    }

    private Command getBendpointsChangedCommand(BendpointRequest request) {
        Connection connection = this.getConnection();
        RakeConstraint c = this.getFeedbackState().feedbackConstraint;
        ConnectionAnchor srcAnchor = connection.getSourceAnchor();
        ConnectionAnchor targetAnchor = connection.getTargetAnchor();
        1 cleanFpCmd = new /* Unavailable Anonymous Inner Class!! */;
        return new SetRakeConstraintCommand((ConnectionEditPart)this.getHost(), c.getSourceRakeLocation(), c.getTargetRakeLocation(), srcAnchor, targetAnchor).chain((Command)cleanFpCmd);
    }

    private Connection getConnection() {
        return (Connection)((ConnectionEditPart)this.getHost()).getFigure();
    }

    private RakeConstraint getConnectionRoutingConstraint() {
        return (RakeConstraint)this.getConnection().getRoutingConstraint();
    }

    private Point getConstrainedPoint(Connection connection, int index) {
        return connection.getPoints().getPoint(index);
    }

    private FeedbackState getFeedbackState() {
        if (this.feedbackState == null) {
            this.feedbackState = new FeedbackState();
        }
        return this.feedbackState;
    }

    private final LineSeg getLineSeg(Connection connection, int nIndex) {
        Point pt1 = new Point(this.getConstrainedPoint(connection, nIndex - 1));
        Point pt2 = new Point(this.getConstrainedPoint(connection, nIndex));
        return new LineSeg(pt1, pt2);
    }

    private ConnectionAnchor getNewSourceAnchor(Point absolutePoint) {
        ConnectionEditPart connEp = (ConnectionEditPart)this.getHost();
        NodeEditPart sourceEp = (NodeEditPart)connEp.getSource();
        ReconnectRequest r = new ReconnectRequest((Object)"Reconnection source");
        r.setConnectionEditPart(connEp);
        r.setTargetEditPart((EditPart)sourceEp);
        r.setLocation(absolutePoint);
        return sourceEp.getSourceConnectionAnchor((Request)r);
    }

    private ConnectionAnchor getNewTargetAnchor(Point absolutePoint) {
        ConnectionEditPart connEp = (ConnectionEditPart)this.getHost();
        NodeEditPart sourceEp = (NodeEditPart)connEp.getTarget();
        ReconnectRequest r = new ReconnectRequest((Object)"Reconnection target");
        r.setConnectionEditPart(connEp);
        r.setTargetEditPart((EditPart)sourceEp);
        r.setLocation(absolutePoint);
        return sourceEp.getTargetConnectionAnchor((Request)r);
    }

    private void restoreOriginalConstraint() {
        RakeConstraint originalConstraint = this.getFeedbackState().originalConstraint;
        if (originalConstraint != null) {
            RakeConstraint current = this.getConnectionRoutingConstraint();
            if (current.getSourceRakeAnchor() != null) {
                current.getSourceRakeAnchor().setLocation(originalConstraint.getSourceRakeAnchor().getReferencePoint());
            }
            if (current.getTargetRakeAnchor() != null) {
                current.getTargetRakeAnchor().setLocation(originalConstraint.getTargetRakeAnchor().getReferencePoint());
            }
        }
        this.getHost().refresh();
    }

    private void saveOriginalConstraint() {
        FeedbackState fbState = this.getFeedbackState();
        RakeConstraint currentConstraint = this.getConnectionRoutingConstraint();
        fbState.originalConstraint = new RakeConstraint();
        fbState.feedbackConstraint = currentConstraint;
        if (currentConstraint != null) {
            XYAnchor anchor = currentConstraint.getSourceRakeAnchor();
            if (anchor != null) {
                fbState.originalConstraint.setSourceRakeAnchor(new XYAnchor(anchor.getReferencePoint()));
            }
            if ((anchor = currentConstraint.getTargetRakeAnchor()) != null) {
                fbState.originalConstraint.setTargetRakeAnchor(new XYAnchor(anchor.getReferencePoint()));
            }
        }
    }

    private void setContrainedPoint(Connection connection, RakeConstraint c, int index, Point relativePoint) {
        Point absolutePoint = new Point(relativePoint);
        connection.translateToAbsolute((Translatable)absolutePoint);
        switch (index) {
            case 0: {
                if (connection.getSourceAnchor() instanceof ISlidableAnchor) {
                    ISlidableAnchor a = (ISlidableAnchor)connection.getSourceAnchor();
                    a.setLocation(absolutePoint);
                    break;
                }
                connection.setSourceAnchor(this.getNewSourceAnchor(absolutePoint));
                break;
            }
            case 1: {
                if (c.getSourceRakeAnchor() == null) break;
                c.getSourceRakeAnchor().setLocation(relativePoint);
                break;
            }
            case 2: {
                if (c.getTargetRakeAnchor() == null) break;
                c.getTargetRakeAnchor().setLocation(relativePoint);
                break;
            }
            case 3: {
                if (connection.getTargetAnchor() instanceof ISlidableAnchor) {
                    ISlidableAnchor a = (ISlidableAnchor)connection.getTargetAnchor();
                    a.setLocation(absolutePoint);
                    break;
                }
                connection.setTargetAnchor(this.getNewTargetAnchor(absolutePoint));
                break;
            }
            default: {
                throw new IllegalArgumentException("index out of bounds");
            }
        }
    }

    private void setLineSeg(Connection c, RakeConstraint rakeConstraint, int nIndex, LineSeg newSeg) {
        this.setContrainedPoint(c, rakeConstraint, nIndex - 1, newSeg.getOrigin());
        this.setContrainedPoint(c, rakeConstraint, nIndex, newSeg.getTerminus());
    }

    private void showMoveLineSegFeedback(BendpointRequest request) {
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        Point ptLoc = new Point(request.getLocation());
        Connection connection = this.getConnection();
        connection.translateToRelative((Translatable)ptLoc);
        int index = request.getIndex();
        RakeConstraint constraint = this.getConnectionRoutingConstraint();
        LineSeg moveLine = this.getLineSeg(connection, index + 1);
        LineSeg newLine = moveLine.getParallelLineSegThroughPoint(ptLoc);
        this.adjustOutsideBoundsLineFeedback(newLine, index, constraint, moveLine);
        this.setLineSeg(connection, constraint, index + 1, newLine);
        connection.setRoutingConstraint((Object)constraint);
    }

    private void showMoveOrthogonalBendpointFeedback(BendpointRequest request) {
        Dimension diff;
        if (this.getFeedbackState().originalConstraint == null) {
            this.saveOriginalConstraint();
        }
        Point ptLoc = new Point(request.getLocation());
        Connection connection = this.getConnection();
        connection.translateToRelative((Translatable)ptLoc);
        int index = request.getIndex();
        Point previous = this.getConstrainedPoint(connection, index - 1);
        Point moving = this.getConstrainedPoint(connection, index);
        Point next = this.getConstrainedPoint(connection, index + 1);
        LineSeg originalFirst = new LineSeg(previous.getCopy(), moving.getCopy());
        LineSeg originalSecond = new LineSeg(moving.getCopy(), next.getCopy());
        if (originalFirst.isHorizontal()) {
            diff = ptLoc.getDifference(moving);
            previous.y += diff.height;
            next.x += diff.width;
        } else {
            diff = ptLoc.getDifference(moving);
            previous.x += diff.width;
            next.y += diff.height;
        }
        LineSeg movedFirst = new LineSeg(previous, ptLoc.getCopy());
        LineSeg movedSecond = new LineSeg(ptLoc.getCopy(), next);
        RakeConstraint constraint = this.getConnectionRoutingConstraint();
        this.adjustOutsideBoundsLineFeedback(movedFirst, index - 1, constraint, originalFirst);
        this.setContrainedPoint(connection, constraint, index - 1, movedFirst.getOrigin());
        this.setContrainedPoint(connection, constraint, index, movedFirst.getTerminus());
        this.adjustOutsideBoundsLineFeedback(movedSecond, index, constraint, originalSecond);
        this.setContrainedPoint(connection, constraint, index + 1, movedSecond.getTerminus());
        connection.setRoutingConstraint((Object)constraint);
    }
}

