/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.core.link.rake;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.LinkServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.figures.routers.RakeConstraint;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkRake;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class RakeLinkOnSourceCommand
extends Command {
    private final GmLink toConnect;
    private final GmLink rakeLink;
    private final Point rakeLocation;
    private Object gmSourceAnchor;

    public RakeLinkOnSourceCommand(GmLink toConnect, GmLink rakeLink, Point loc, Object gmSourceAnchor) {
        this.rakeLink = rakeLink;
        this.toConnect = toConnect;
        this.rakeLocation = loc;
        this.gmSourceAnchor = gmSourceAnchor;
    }

    public void execute() {
        this.updateLinkSource();
        if (this.rakeLink.getPath().getSourceRake() == null) {
            this.setRakeMode();
        }
        GmPath newConnectPath = new GmPath(this.toConnect.getPath());
        newConnectPath.setPathData(this.rakeLink.getPath().getPathData());
        newConnectPath.setRouterKind(StyleKey.ConnectionRouterId.ORTHOGONAL);
        newConnectPath.setSourceAnchor(this.rakeLink.getPath().getSourceAnchor());
        newConnectPath.setSourceRake(this.rakeLink.getPath().getSourceRake());
        this.toConnect.setLayoutData((Object)newConnectPath);
    }

    public boolean canExecute() {
        if (this.toConnect.getStyleKey(MetaKey.CONNECTIONROUTER) != null && this.rakeLink.getStyleKey(MetaKey.CONNECTIONROUTER) != null && (this.toConnect == null || this.toConnect.getClass() == this.rakeLink.getClass())) {
            return AuthHelper.canModifyDiagram((GmAbstractDiagram)this.toConnect.getDiagram());
        }
        return false;
    }

    private void setRakeMode() {
        GmLinkRake sourceRake = new GmLinkRake();
        sourceRake.setSharedAnchor(this.gmSourceAnchor);
        RakeConstraint rakeData = new RakeConstraint();
        rakeData.setSourceRakeAnchor(new XYAnchor(this.rakeLocation));
        GmPath path = new GmPath(this.rakeLink.getPath());
        path.setPathData((Object)rakeData);
        path.setRouterKind(StyleKey.ConnectionRouterId.ORTHOGONAL);
        path.setSourceAnchor(this.gmSourceAnchor);
        path.setSourceRake((IGmLinkRake)sourceRake);
        this.rakeLink.setLayoutData((Object)path);
    }

    protected void updateLinkSource() {
        IElement link = this.toConnect.getRelatedIElement();
        IElement newSource = this.rakeLink.getFromElement();
        IGmLinkable oldSourceNode = this.toConnect.getFrom();
        if (oldSourceNode != null) {
            IElement oldSource = oldSourceNode.getRelatedIElement();
            if (!newSource.equals((Object)oldSource)) {
                LinkServices.changeSource((IElement)link, (IElement)oldSource, (IElement)newSource);
            }
            oldSourceNode.removeStartingLink((IGmLink)this.toConnect);
        } else {
            LinkServices.changeSource((IElement)link, null, (IElement)newSource);
        }
        this.rakeLink.getFrom().addStartingLink((IGmLink)this.toConnect);
    }
}

